/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.neuronalnet.core;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.neuronalnet.api.DataPoint;
import de.planetensuche.neuronalnet.core.DataAccessException;
import de.planetensuche.neuronalnet.core.ROLFNeuronalNetwork;
import de.planetensuche.neuronalnet.core.TrainingSetService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;

@Deprecated
public final class TrainingSetCsvService
implements TrainingSetService {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(TrainingSetCsvService.class);
    private static final int UNTIL_DISCOVERY_YEAR = 2017;

    @Override
    public void learnAbsMagTEff(ROLFNeuronalNetwork rOLFNeuronalNetwork) throws DataAccessException {
        List<String> list = this.getData(2017);
        int n = 0;
        for (String string : list) {
            String[] stringArray = string.split(",");
            if (stringArray[5].isEmpty() || stringArray[6].isEmpty() || stringArray[7].isEmpty()) continue;
            double d = Double.parseDouble(stringArray[5]);
            double d2 = Double.parseDouble(stringArray[6]);
            double d3 = Double.parseDouble(stringArray[7]);
            double d4 = -1.0 * (5.0 * Math.log10(d) - 5.0 - d2);
            rOLFNeuronalNetwork.learn(d3, d4 *= 1000.0, true);
            ++n;
        }
        LOGGER.debug(n + " data points compared with " + rOLFNeuronalNetwork.getSize() + " neurons");
        rOLFNeuronalNetwork.learn(100000.0, -1000.0, false);
        rOLFNeuronalNetwork.learn(30000.0, -10000.0, false);
        rOLFNeuronalNetwork.learn(4000.0, 20000.0, false);
    }

    @Override
    public void learnPlMassStarMetal(ROLFNeuronalNetwork rOLFNeuronalNetwork) throws DataAccessException {
        List<String> list = this.getData(2017);
        LOGGER.debug(list.size() + " data sets found");
        int n = 0;
        for (String string : list) {
            String[] stringArray = string.split(",");
            if (stringArray[2].isEmpty() || stringArray[23].isEmpty()) continue;
            double d = Double.parseDouble(stringArray[2]);
            double d2 = Double.parseDouble(stringArray[23]);
            double d3 = d * 318.0;
            if (d3 > 5.0) {
                rOLFNeuronalNetwork.learn(d2, d, false);
                continue;
            }
            rOLFNeuronalNetwork.learn(d2, d, true);
            ++n;
        }
        LOGGER.debug(n + " data points compared with " + rOLFNeuronalNetwork.getSize() + " neurons");
    }

    @Override
    public void learnPlMassStarMassEarthlike(ROLFNeuronalNetwork rOLFNeuronalNetwork) throws DataAccessException {
        List<String> list = this.getData(2017);
        LOGGER.debug(list.size() + " data sets found");
        int n = 0;
        for (String string : list) {
            String[] stringArray = string.split(",");
            if (stringArray[2].isEmpty() || stringArray[8].isEmpty()) continue;
            double d = Double.parseDouble(stringArray[2]);
            double d2 = Double.parseDouble(stringArray[8]);
            double d3 = d * 318.0;
            if (d3 > 10.0) {
                rOLFNeuronalNetwork.learn(d, d2, false);
                continue;
            }
            rOLFNeuronalNetwork.learn(d, d2, true);
            ++n;
        }
        LOGGER.debug(n + " data points compared with " + rOLFNeuronalNetwork.getSize() + " neurons");
    }

    @Override
    public void learnPlMassStarMassJupiterlike(ROLFNeuronalNetwork rOLFNeuronalNetwork) throws DataAccessException {
        List<String> list = this.getData(2017);
        LOGGER.debug(list.size() + " data sets found");
        int n = 0;
        for (String string : list) {
            String[] stringArray = string.split(",");
            if (stringArray[2].isEmpty() || stringArray[8].isEmpty()) continue;
            double d = Double.parseDouble(stringArray[2]);
            double d2 = Double.parseDouble(stringArray[8]);
            double d3 = d * 318.0;
            if (d3 > 10.0) {
                rOLFNeuronalNetwork.learn(d, d2, true);
                ++n;
                continue;
            }
            rOLFNeuronalNetwork.learn(d, d2, false);
        }
        LOGGER.debug(n + " data points compared with " + rOLFNeuronalNetwork.getSize() + " neurons");
    }

    @Override
    public void learnStarMassMetalEarthlike(ROLFNeuronalNetwork rOLFNeuronalNetwork) throws DataAccessException {
        double d;
        double d2;
        String[] stringArray;
        List<String> list = this.getData(2017);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (String string : list) {
            stringArray = string.split(",");
            if (stringArray[2].isEmpty() && stringArray[3].isEmpty() || stringArray[8].isEmpty() || stringArray[23].isEmpty()) continue;
            d2 = 0.0;
            if (!stringArray[2].trim().isEmpty()) {
                d2 = Double.parseDouble(stringArray[2]);
            }
            d = 0.0;
            if (!stringArray[3].trim().isEmpty()) {
                d = Double.parseDouble(stringArray[3]);
            }
            double d3 = d2 * 318.0;
            double d4 = d * 11.0;
            if (!(d3 != 0.0 && d3 <= 10.0) && (d4 == 0.0 || !(d4 <= 2.0))) continue;
            String string2 = stringArray[1];
            hashMap.put(string2, true);
        }
        for (String string : list) {
            stringArray = string.split(",");
            if (stringArray[2].isEmpty() && stringArray[3].isEmpty() || stringArray[8].isEmpty() || stringArray[23].isEmpty()) continue;
            d2 = Double.parseDouble(stringArray[8]);
            d = Double.parseDouble(stringArray[23]);
            String string3 = stringArray[1];
            Boolean bl = (Boolean)hashMap.get(string3);
            if (bl == null || !bl.booleanValue()) continue;
            rOLFNeuronalNetwork.learn(d, d2, true);
        }
        LOGGER.debug("NNW hat " + rOLFNeuronalNetwork.getSize() + " Neutronen");
    }

    @Override
    public List<DataPoint> getAllDataPointsAbsMagTEff() throws DataAccessException {
        List<String> list = this.getData(2100);
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        for (String string : list) {
            String[] stringArray = string.split(",");
            if (stringArray[5].isEmpty() || stringArray[6].isEmpty() || stringArray[7].isEmpty()) continue;
            double d = Double.parseDouble(stringArray[5]);
            double d2 = Double.parseDouble(stringArray[6]);
            double d3 = Double.parseDouble(stringArray[7]);
            double d4 = -1.0 * (5.0 * Math.log10(d) - 5.0 - d2);
            DataPoint dataPoint = new DataPoint();
            dataPoint.setX(d3);
            dataPoint.setY(d4 *= 1000.0);
            dataPoint.setName(stringArray[11]);
            arrayList.add(dataPoint);
        }
        return arrayList;
    }

    @Deprecated
    private List<String> getData(int n) throws DataAccessException {
        try {
            File file = new File("database/nasa-planets.csv");
            if (!file.exists()) {
                file = new File("src/test/resources/data/nasa-planets.csv");
            }
            List<String> list = FileUtils.readLines(file, StandardCharsets.UTF_8);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                int n2;
                String[] stringArray = string.split(",");
                if (stringArray.length <= 23 || "rowid".equalsIgnoreCase(stringArray[0]) || (n2 = Integer.parseInt(stringArray[15])) > n || !"3".equals(stringArray[16])) continue;
                arrayList.add(string);
            }
            return arrayList;
        }
        catch (IOException iOException) {
            LOGGER.error(iOException);
            throw new DataAccessException(iOException.getMessage());
        }
    }

    @Override
    public List<DataPoint> getPlMassStarMetal() throws DataAccessException {
        List<String> list = this.getDataByYear(2018);
        LOGGER.debug(list.size() + " data sets found");
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        for (String string : list) {
            String[] stringArray = string.split(",");
            if (stringArray[2].isEmpty() || stringArray[23].isEmpty()) continue;
            double d = Double.parseDouble(stringArray[2]);
            double d2 = Double.parseDouble(stringArray[23]);
            DataPoint dataPoint = new DataPoint();
            dataPoint.setName(stringArray[11]);
            dataPoint.setX(d2);
            dataPoint.setY(d);
            arrayList.add(dataPoint);
        }
        return arrayList;
    }

    @Override
    public List<DataPoint> getStarMassStarMetal() throws DataAccessException {
        List<String> list = this.getDataByYear(2018);
        LOGGER.debug(list.size() + " data sets found");
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        for (String string : list) {
            String[] stringArray = string.split(",");
            if (stringArray[2].isEmpty() && stringArray[3].isEmpty() || stringArray[8].isEmpty() || stringArray[23].isEmpty()) continue;
            double d = 0.0;
            if (!stringArray[2].trim().isEmpty()) {
                d = Double.parseDouble(stringArray[2]);
            }
            double d2 = 0.0;
            if (!stringArray[3].trim().isEmpty()) {
                d2 = Double.parseDouble(stringArray[3]);
            }
            double d3 = Double.parseDouble(stringArray[8]);
            double d4 = Double.parseDouble(stringArray[23]);
            DataPoint dataPoint = new DataPoint();
            dataPoint.setName(stringArray[1] + " (" + d + " Mjup, " + d2 + " Djup)");
            dataPoint.setX(d4);
            dataPoint.setY(d3);
            arrayList.add(dataPoint);
        }
        return arrayList;
    }

    @Deprecated
    private List<String> getDataByYear(int n) throws DataAccessException {
        try {
            File file = new File("database/nasa-planets.csv");
            if (!file.exists()) {
                file = new File("src/test/resources/data/nasa-planets.csv");
            }
            List<String> list = FileUtils.readLines(file, StandardCharsets.UTF_8);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                int n2;
                String[] stringArray = string.split(",");
                if (stringArray.length <= 23 || "rowid".equalsIgnoreCase(stringArray[0]) || (n2 = Integer.parseInt(stringArray[15])) != n || !"3".equals(stringArray[16])) continue;
                arrayList.add(string);
            }
            return arrayList;
        }
        catch (IOException iOException) {
            LOGGER.error(iOException);
            throw new DataAccessException(iOException.getMessage());
        }
    }
}

