/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.neuronalnet.core;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.neuronalnet.api.DataPoint;
import de.planetensuche.neuronalnet.core.DataAccessException;
import de.planetensuche.neuronalnet.core.ROLFNeuronalNetwork;
import de.planetensuche.neuronalnet.core.TrainingSetService;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class TrainingSetDbService
implements TrainingSetService {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(TrainingSetDbService.class);
    private final int defaultUntilDiscoveryYear;
    private final IDatenbankverbinder dbVerbinder;
    private final IIdCacheDAO idCacheDao;
    private final QDaten qDaten = QDaten.daten;

    public TrainingSetDbService(IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.defaultUntilDiscoveryYear = LocalDate.now().getYear() - 1;
        this.dbVerbinder = iDatenbankverbinder;
        this.idCacheDao = iIdCacheDAO;
    }

    @Override
    public List<DataPoint> getAllDataPointsAbsMagTEff() throws DataAccessException {
        try {
            List list = ((SQLQuery)((SQLQuery)this.dbVerbinder.getQueryFactory().select(new Expression[]{this.qDaten.id, this.qDaten.ah, this.qDaten.temperatur}).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsSterne()).and(this.qDaten.ah.isNotNull()).and(this.qDaten.ah.ne(-100.0)).and(this.qDaten.temperatur.isNotNull()).and(this.qDaten.temperatur.gt(0.0)))).fetch();
            Set<Integer> set = this.findStarIdsWithConfirmedPlanets(2100);
            List<DataPoint> list2 = list.stream().filter(tuple -> {
                Integer n = tuple.get(this.qDaten.id);
                return set.contains(n);
            }).map(tuple -> {
                DataPoint dataPoint = new DataPoint();
                dataPoint.setName("TODO");
                dataPoint.setX(tuple.get(this.qDaten.temperatur));
                dataPoint.setY(tuple.get(this.qDaten.ah));
                return dataPoint;
            }).collect(Collectors.toList());
            return list2;
        }
        catch (Exception exception) {
            LOGGER.error(exception);
            throw new DataAccessException(exception.getMessage());
        }
    }

    @Override
    public List<DataPoint> getPlMassStarMetal() throws DataAccessException {
        List<Tuple> list = this.findConfirmedPlanets(this.defaultUntilDiscoveryYear + 1);
        return list.stream().map(tuple -> {
            try {
                double d = tuple.get(this.qDaten.masse);
                Double d2 = (Double)((SQLQuery)((SQLQuery)this.dbVerbinder.getQueryFactory().select((Expression)this.qDaten.metallizitaet).from((Expression<?>)this.qDaten)).where(this.qDaten.id.eq(tuple.get(this.qDaten.zugehoerigkeit)))).fetchFirst();
                if (d2 != null) {
                    DataPoint dataPoint = new DataPoint();
                    dataPoint.setName("TODO");
                    dataPoint.setX(d2);
                    dataPoint.setY(d);
                    return dataPoint;
                }
            }
            catch (Exception exception) {
                LOGGER.error("Fehler beim Verarbeiten von planet id " + String.valueOf(tuple.get(this.qDaten.id)), exception);
            }
            return null;
        }).filter(dataPoint -> dataPoint != null).collect(Collectors.toList());
    }

    @Override
    public List<DataPoint> getStarMassStarMetal() throws DataAccessException {
        try {
            List list = ((SQLQuery)((SQLQuery)this.dbVerbinder.getQueryFactory().select(new Expression[]{this.qDaten.id, this.qDaten.masse, this.qDaten.metallizitaet}).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsSterne()).and(this.qDaten.masse.isNotNull()).and(this.qDaten.masse.ne(0.0)).and(this.qDaten.metallizitaet.isNotNull()).and(this.qDaten.metallizitaet.ne(-100.0)))).fetch();
            Set<Integer> set = this.findStarIdsWithConfirmedPlanets(this.defaultUntilDiscoveryYear + 1);
            List<DataPoint> list2 = list.stream().filter(tuple -> {
                Integer n = tuple.get(this.qDaten.id);
                return set.contains(n);
            }).map(tuple -> {
                double d = 0.0;
                double d2 = 0.0;
                DataPoint dataPoint = new DataPoint();
                dataPoint.setName("TODO name (" + d + " Mjup, " + d2 + " Djup)");
                dataPoint.setX(tuple.get(this.qDaten.metallizitaet));
                dataPoint.setY(tuple.get(this.qDaten.masse));
                return dataPoint;
            }).collect(Collectors.toList());
            return list2;
        }
        catch (Exception exception) {
            LOGGER.error(exception);
            throw new DataAccessException(exception.getMessage());
        }
    }

    @Override
    public void learnAbsMagTEff(ROLFNeuronalNetwork rOLFNeuronalNetwork) throws DataAccessException {
        try {
            List list = ((SQLQuery)((SQLQuery)this.dbVerbinder.getQueryFactory().select(new Expression[]{this.qDaten.id, this.qDaten.ah, this.qDaten.temperatur}).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsSterne()).and(this.qDaten.ah.isNotNull()).and(this.qDaten.ah.ne(-100.0)).and(this.qDaten.temperatur.isNotNull()).and(this.qDaten.temperatur.gt(0.0)))).fetch();
            Set<Integer> set = this.findStarIdsWithConfirmedPlanets(this.defaultUntilDiscoveryYear);
            List list2 = list.stream().filter(tuple -> {
                Integer n = tuple.get(this.qDaten.id);
                return set.contains(n);
            }).collect(Collectors.toList());
            int n = 0;
            for (Tuple tuple2 : list2) {
                double d = tuple2.get(this.qDaten.temperatur);
                double d2 = tuple2.get(this.qDaten.ah) * 1000.0;
                rOLFNeuronalNetwork.learn(d, d2, true);
                ++n;
            }
            LOGGER.debug(n + " data points compared with " + rOLFNeuronalNetwork.getSize() + " neurons");
            rOLFNeuronalNetwork.learn(100000.0, -1000.0, false);
            rOLFNeuronalNetwork.learn(30000.0, -10000.0, false);
            rOLFNeuronalNetwork.learn(4000.0, 20000.0, false);
        }
        catch (Exception exception) {
            LOGGER.error(exception);
            throw new DataAccessException(exception.getMessage());
        }
    }

    @Override
    public void learnPlMassStarMassEarthlike(ROLFNeuronalNetwork rOLFNeuronalNetwork) throws DataAccessException {
        try {
            int n = 0;
            List<Tuple> list = this.findConfirmedPlanets(this.defaultUntilDiscoveryYear);
            for (Tuple tuple : list) {
                Double d;
                Double d2 = tuple.get(this.qDaten.masse);
                if (d2 == null || !(d2 > 0.0) || (d = (Double)((SQLQuery)((SQLQuery)this.dbVerbinder.getQueryFactory().select((Expression)this.qDaten.masse).from((Expression<?>)this.qDaten)).where(this.qDaten.id.eq(tuple.get(this.qDaten.zugehoerigkeit)))).fetchFirst()) == null || !(d > 0.0)) continue;
                double d3 = d2 * 318.0;
                if (d3 > 10.0) {
                    rOLFNeuronalNetwork.learn(d2, d, false);
                    continue;
                }
                rOLFNeuronalNetwork.learn(d2, d, true);
                ++n;
            }
            LOGGER.debug(n + " data points compared with " + rOLFNeuronalNetwork.getSize() + " neurons");
        }
        catch (Exception exception) {
            LOGGER.error(exception);
            throw new DataAccessException(exception.getMessage());
        }
    }

    @Override
    public void learnPlMassStarMassJupiterlike(ROLFNeuronalNetwork rOLFNeuronalNetwork) throws DataAccessException {
        try {
            int n = 0;
            List<Tuple> list = this.findConfirmedPlanets(this.defaultUntilDiscoveryYear);
            for (Tuple tuple : list) {
                Double d;
                Double d2 = tuple.get(this.qDaten.masse);
                if (d2 == null || !(d2 > 0.0) || (d = (Double)((SQLQuery)((SQLQuery)this.dbVerbinder.getQueryFactory().select((Expression)this.qDaten.masse).from((Expression<?>)this.qDaten)).where(this.qDaten.id.eq(tuple.get(this.qDaten.zugehoerigkeit)))).fetchFirst()) == null || !(d > 0.0)) continue;
                double d3 = d2 * 318.0;
                if (d3 > 10.0) {
                    rOLFNeuronalNetwork.learn(d2, d, true);
                    ++n;
                    continue;
                }
                rOLFNeuronalNetwork.learn(d2, d, false);
            }
            LOGGER.debug(n + " data points compared with " + rOLFNeuronalNetwork.getSize() + " neurons");
        }
        catch (Exception exception) {
            LOGGER.error(exception);
            throw new DataAccessException(exception.getMessage());
        }
    }

    @Override
    public void learnPlMassStarMetal(ROLFNeuronalNetwork rOLFNeuronalNetwork) throws DataAccessException {
        try {
            int n = 0;
            List<Tuple> list = this.findConfirmedPlanets(this.defaultUntilDiscoveryYear);
            for (Tuple tuple : list) {
                Double d;
                Double d2 = tuple.get(this.qDaten.masse);
                if (d2 == null || !(d2 > 0.0) || (d = (Double)((SQLQuery)((SQLQuery)this.dbVerbinder.getQueryFactory().select((Expression)this.qDaten.metallizitaet).from((Expression<?>)this.qDaten)).where(this.qDaten.id.eq(tuple.get(this.qDaten.zugehoerigkeit)))).fetchFirst()) == null || d == -100.0) continue;
                double d3 = d2 * 318.0;
                if (d3 > 5.0) {
                    rOLFNeuronalNetwork.learn(d, d2, false);
                    continue;
                }
                rOLFNeuronalNetwork.learn(d, d2, true);
                ++n;
            }
            LOGGER.debug(n + " data points compared with " + rOLFNeuronalNetwork.getSize() + " neurons");
        }
        catch (Exception exception) {
            LOGGER.error(exception);
            throw new DataAccessException(exception.getMessage());
        }
    }

    @Override
    public void learnStarMassMetalEarthlike(ROLFNeuronalNetwork rOLFNeuronalNetwork) throws DataAccessException {
        try {
            List<Tuple> list = this.findConfirmedPlanets(this.defaultUntilDiscoveryYear);
            List list2 = list.stream().filter(tuple -> {
                Double d = tuple.get(this.qDaten.masse);
                Double d2 = tuple.get(this.qDaten.durchmesser);
                if (d != null && d > 0.0) {
                    double d3 = d * 318.0;
                    return d3 > 0.0 && d3 <= 10.0;
                }
                if (d2 != null && d2 > 0.0) {
                    double d4 = d2 * 11.0;
                    return d4 > 0.0 && d4 <= 2.0;
                }
                return false;
            }).collect(Collectors.toList());
            for (Tuple tuple2 : list2) {
                int n = tuple2.get(this.qDaten.zugehoerigkeit);
                Tuple tuple3 = (Tuple)((SQLQuery)((SQLQuery)this.dbVerbinder.getQueryFactory().select(new Expression[]{this.qDaten.masse, this.qDaten.metallizitaet}).from((Expression<?>)this.qDaten)).where(this.qDaten.id.eq(n).and(this.qDaten.masse.isNotNull()).and(this.qDaten.masse.gt(0.0)).and(this.qDaten.metallizitaet.isNotNull()).and(this.qDaten.metallizitaet.ne(-100.0)))).fetchFirst();
                if (tuple3 == null) continue;
                double d = tuple3.get(this.qDaten.masse);
                double d2 = tuple3.get(this.qDaten.metallizitaet);
                rOLFNeuronalNetwork.learn(d2, d, true);
            }
            LOGGER.debug("NNW hat " + rOLFNeuronalNetwork.getSize() + " Neutronen");
        }
        catch (Exception exception) {
            LOGGER.error(exception);
            throw new DataAccessException(exception.getMessage());
        }
    }

    private Set<Integer> findStarIdsWithConfirmedPlanets(int n) throws DataAccessException {
        List<Tuple> list = this.findConfirmedPlanets(n);
        Set<Integer> set = list.stream().map(tuple -> tuple.get(this.qDaten.zugehoerigkeit)).collect(Collectors.toSet());
        return set;
    }

    private List<Tuple> findConfirmedPlanets(int n) throws DataAccessException {
        try {
            List list = ((SQLQuery)((SQLQuery)this.dbVerbinder.getQueryFactory().select(new Expression[]{this.qDaten.id, this.qDaten.zugehoerigkeit, this.qDaten.entdeckungsdatum, this.qDaten.masse, this.qDaten.durchmesser}).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.eq(Boolean.TRUE)).and(this.qDaten.entdeckungsdatum.isNotNull()).and(this.qDaten.entdeckungsdatum.isNotEmpty()).and(this.qDaten.zugehoerigkeit.isNotNull()))).fetch();
            List<Tuple> list2 = list.stream().filter(tuple -> {
                String string = tuple.get(this.qDaten.entdeckungsdatum);
                if (string != null && string.length() == 10) {
                    String string2 = string.substring(6, 10);
                    int n2 = Integer.parseInt(string2);
                    if (n2 <= n) {
                        return true;
                    }
                } else {
                    LOGGER.warn("ung\u00fcltiges Entdeckungsdatum '" + string + "'");
                }
                return false;
            }).collect(Collectors.toList());
            return list2;
        }
        catch (Exception exception) {
            LOGGER.error(exception);
            throw new DataAccessException(exception.getMessage());
        }
    }
}

