/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen;

import com.google.inject.Injector;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.SendWindowAccessToWebService;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallback;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import de.planetensuche.simulationen.DiagrammDialog;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public final class DiagrammControler {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final ISprachcontainer sprachcontainer = SprachcontainerFabrik.getSprachcontainer();
    private final IChartRepository chartRepository;
    private DiagrammDialog dialog;

    public DiagrammControler(Injector injector) {
        this.chartRepository = injector.getInstance(IChartRepository.class);
    }

    public void showDialog() {
        if (this.dialog == null) {
            Map<String, Set<IChart>> map = this.chartRepository.getRegisteredCharts();
            if (map.isEmpty()) {
                throw new RuntimeException("keine Diagramme registriert!");
            }
            MouseListener mouseListener = this.createNewMouseListener();
            this.dialog = new DiagrammDialog(mouseListener, map);
        }
        this.dialog.setVisible(true);
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private MouseListener createNewMouseListener() {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    Object object;
                    JTree jTree = (JTree)mouseEvent.getComponent();
                    TreePath treePath = jTree.getSelectionPath();
                    if (treePath != null && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof IChart) {
                        jTree.clearSelection();
                        DiagrammControler.this.createAndShowChart(object);
                    }
                }
                catch (Exception exception) {
                    DiagrammControler.this.logging.error(exception);
                    JOptionPane.showMessageDialog(DiagrammControler.this.dialog, DiagrammControler.this.sprachcontainer.getString("sim_f1") + "\n" + exception.getLocalizedMessage(), DiagrammControler.this.sprachcontainer.getString("db_f4_titel"), 0);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        };
    }

    private void createAndShowChart(Object object) {
        IChart iChart = (IChart)object;
        iChart.beforeCollectData();
        AsyncLoadingScreenCallback asyncLoadingScreenCallback = () -> {
            try {
                long l = System.currentTimeMillis();
                iChart.collectData();
                long l2 = System.currentTimeMillis() - l;
                if (l2 > 3000L) {
                    this.logging.warn("!!!!!!! Daten laden f\u00fcr Diagramm '" + iChart.getChartName() + "' dauerte " + l2 + " ms !!!!!!!");
                }
                String string = this.chartRepository.getChartDescription(iChart);
                SwingUtilities.invokeLater(() -> {
                    JPanel jPanel = iChart.createChart();
                    this.dialog.showNewDiagramm(jPanel, string);
                });
                new SendWindowAccessToWebService().sendAsyncWithoutException(iChart.getBasisdialogId());
            }
            catch (SQLException sQLException) {
                this.logging.error(sQLException);
                JOptionPane.showMessageDialog(this.dialog, this.sprachcontainer.getString("sim_f1") + "\n" + sQLException.toString(), this.sprachcontainer.getString("db_f4_titel"), 0);
            }
        };
        new AsyncLoadingScreenCallbackExecutor().execute(this.dialog, asyncLoadingScreenCallback);
    }
}

