/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen;

import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.DiagrammTreeCellRenderer;
import de.planetensuche.simulationen.diagramme.IChart;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jfree.chart.ChartPanel;

public final class DiagrammDialog
extends Basisdialog {
    private JTree jTree;
    private JPanel jPanel;

    public DiagrammDialog(MouseListener mouseListener, Map<String, Set<IChart>> map) {
        super(BasisdialogId.SIMULATION_DIAGRAMM_HAUPTFENSTER);
        this.init(mouseListener, map);
    }

    private void init(MouseListener mouseListener, Map<String, Set<IChart>> map) {
        this.setTitle(this.i18n.getString("sim_gui6"));
        this.setDefaultCloseOperation(1);
        this.resizeToDesktopSize();
        this.setLayout(new BorderLayout());
        this.showMessageBar("First");
        this.createTree(map, mouseListener);
        JScrollPane jScrollPane = new JScrollPane(this.jTree);
        this.add((Component)jScrollPane, "Before");
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BorderLayout());
        this.add((Component)this.jPanel, "Center");
    }

    public void addTreeListener(TreeSelectionListener treeSelectionListener) {
        this.jTree.addTreeSelectionListener(treeSelectionListener);
    }

    public void showNewDiagramm(JPanel jPanel, String string) {
        this.showChartAndDescription(jPanel, string);
    }

    private void showChartAndDescription(JPanel jPanel, String string) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setOpaque(false);
        if (jPanel instanceof ChartPanel) {
            jScrollPane.setVerticalScrollBarPolicy(21);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setBackground(jScrollPane.getBackground());
        } else {
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            jScrollPane.setBackground(Color.black);
        }
        jScrollPane.setViewportView(jPanel);
        this.jPanel.removeAll();
        this.jPanel.add((Component)jScrollPane, "Center");
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(string.replaceAll("<br>", "\n"));
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setPreferredSize(new Dimension(jScrollPane.getWidth(), 100));
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setViewportView(jTextArea);
        this.jPanel.add((Component)jScrollPane2, "Last");
        this.jPanel.revalidate();
        this.jPanel.repaint();
    }

    private void createTree(Map<String, Set<IChart>> map, MouseListener mouseListener) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Kategorien                                 ");
        for (Map.Entry<String, Set<IChart>> entry : map.entrySet()) {
            String string = entry.getKey();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            for (IChart iChart : entry.getValue()) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(iChart));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        this.jTree = new JTree(defaultMutableTreeNode);
        this.jTree.setCellRenderer(new DiagrammTreeCellRenderer());
        this.jTree.addMouseListener(mouseListener);
    }
}

