/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen;

import com.google.inject.Injector;
import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.repos.IHabitableZoneRepository;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.JComboBoxExtended;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.simulationen.DiagrammControler;
import de.planetensuche.simulationen.DiagrammKategorieNummer;
import de.planetensuche.simulationen.HilfeDialog;
import de.planetensuche.simulationen.Weltbilder;
import de.planetensuche.simulationen.dbmodel.api.FilterCriteria;
import de.planetensuche.simulationen.dbmodel.api.IDAOlowAllgemein;
import de.planetensuche.simulationen.dbmodel.api.IObjektnamenSimulationDAO;
import de.planetensuche.simulationen.diagramme.old.DiagrammeAllgemein;
import de.planetensuche.simulationen.diameter.CompareDiameterController;
import de.planetensuche.simulationen.diashow.DiashowGui;
import de.planetensuche.simulationen.exoplanetensystem.ExoplanetensystemeListeControler;
import de.planetensuche.simulationen.exoplanetensystem.IExoplanetensystemeRepository;
import de.planetensuche.simulationen.sonnensystem.asteroiden.AsteroidenAuswahlControler;
import de.planetensuche.simulationen.sonnensystem.monde.SonnensystemGui;
import de.planetensuche.simulationen.sonnensystem.service.SonnensystemService;
import de.planetensuche.sternkarte.api.ISternkarte;
import de.planetensuche.sternkarte.api.SternkartenFabrik;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public final class SimulationDialog
extends Basisdialog {
    private final Injector injector;
    private final SternkartenFabrik sternkartenFabrik;
    private final JComboBoxExtended<String> art;
    private boolean semaphor;
    private int auswahl;
    private DiagrammControler diagrammControler;
    private JComboBox db;
    private JMenu diagramme;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu5;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem13;
    private JMenuItem jMenuItem23;
    private JMenuItem jMenuItem40;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItemPlanetDiameter;
    private JMenuItem jMenuItemStarDiameter;
    private JMenuItem jmenuHilfe;
    private JMenuItem menuItemDiashow;
    private JMenuItem menuItemStarMap;
    private JMenuItem planetensystemeMenuItem;
    private JComboBox wirdangezeigt;

    public SimulationDialog(KoordinatenFormat koordinatenFormat, Injector injector) {
        super(BasisdialogId.SIMULATION_HAUPTFENSTER);
        this.injector = injector;
        this.sternkartenFabrik = new SternkartenFabrik(koordinatenFormat);
        this.initComponents();
        this.setCursor(new Cursor(3));
        this.semaphor = true;
        this.art = new JComboBoxExtended(5);
        this.art.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.artActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.art);
        this.art.setBounds(210, 40, 150, 22);
        this.art.addItem(this.i18n.getString("ps_planeten"), ObjektKategorie.PLANETEN.getKategorienName());
        this.art.addItem(this.i18n.getString("ps_monde"), ObjektKategorie.MONDE.getKategorienName());
        this.art.addItem(this.i18n.getString("ps_asteroiden"), ObjektKategorie.ASTEROIDEN.getKategorienName());
        this.art.addItem(this.i18n.getString("ps_br_zwerge"), ObjektKategorie.BR_ZWERGE.getKategorienName());
        this.art.addItem(this.i18n.getString("ps_sterne"), ObjektKategorie.STERNE.getKategorienName());
        this.auswahlAus();
        this.semaphor = false;
        this.setTitle(this.i18n.getString("sim_fenster"));
        this.jButton1.setText(this.i18n.getString("sim_gui1"));
        this.jButton3.setText(this.i18n.getString("db_gui64"));
        this.jButton2.setText(this.i18n.getString("db_gui46"));
        this.jLabel4.setText(this.i18n.getString("sim_gui2"));
        this.jLabel1.setText(this.i18n.getString("sim_gui3"));
        this.jLabel2.setText(this.i18n.getString("sim_gui4"));
        this.jLabel3.setText(this.i18n.getString("sim_gui5"));
        this.diagramme.setText(this.i18n.getString("sim_gui6"));
        this.jMenu5.setText(this.i18n.getString("sim_gui7"));
        this.jMenu5.setIcon(new ImageIcon(IconPoolCustom.TORTENDIAGRAMM.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.jMenuItem6.setText(this.i18n.getString("sim_gui8"));
        this.jMenuItem5.setText(this.i18n.getString("sim_gui9"));
        this.jMenuItem23.setText(this.i18n.getString("sim_gui10"));
        this.jMenuItem10.setText(this.i18n.getString("sim_gui112"));
        this.jMenuItem10.setIcon(new ImageIcon(IconPoolCustom.BALKENDIAGRAMM.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.jMenuItem10.addActionListener(actionEvent -> {
            try {
                if (this.diagrammControler == null) {
                    this.diagrammControler = new DiagrammControler(injector);
                }
                this.diagrammControler.showDialog();
            }
            catch (Exception exception) {
                this.getLogger().error(exception);
            }
        });
        this.jMenu3.setText(this.i18n.getString("sim_gui63"));
        this.jMenuItem40.setText(this.i18n.getString("sim_gui65_1"));
        this.jMenuItem40.setIcon(new ImageIcon(IconPoolCustom.UMLAUFBAHN.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.jMenuItem1.setText(this.i18n.getString("sim_gui65_2"));
        this.jMenuItem1.setIcon(new ImageIcon(IconPoolCustom.UMLAUFBAHN.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.planetensystemeMenuItem.setText(this.i18n.getString("sim_gui66"));
        this.planetensystemeMenuItem.setIcon(new ImageIcon(IconPoolCustom.UMLAUFBAHN.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.jMenu2.setText(this.i18n.getString("db_menu_15"));
        this.jMenuItem13.setText(this.i18n.getString("sim_gui64"));
        this.jMenuItem13.setIcon(new ImageIcon(IconPoolCustom.WELTBILD_HEUTE.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.menuItemStarMap.setText(this.i18n.getString("sim_gui67"));
        this.menuItemStarMap.setIcon(new ImageIcon(IconPoolCustom.STERNBILD_ORION.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.menuItemDiashow.setText(this.i18n.getString("sim_gui68"));
        this.menuItemDiashow.setIcon(new ImageIcon(IconPoolCustom.NEBEL.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.jMenuItemStarDiameter.setText(this.i18n.getString("sim_gui131"));
        this.jMenuItemStarDiameter.setIcon(new ImageIcon(IconPoolCustom.SONNE.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.jMenuItemPlanetDiameter.setText(this.i18n.getString("sim_gui133"));
        this.jMenuItemPlanetDiameter.setIcon(new ImageIcon(IconPoolCustom.PLANET.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.jMenu1.setText(this.i18n.getString("db_menu_19"));
        this.jmenuHilfe.setText(this.i18n.getString("db_menu_26"));
        this.jmenuHilfe.setIcon(IconPoolDefault.HELP.getImageIcon());
        this.db.setToolTipText(this.i18n.getString("sim_m1"));
        this.wirdangezeigt.setToolTipText(this.i18n.getString("sim_m2"));
        for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
            this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
        }
        this.setCursor(new Cursor(0));
    }

    public void auswahlAus() {
        this.jLabel1.setVisible(false);
        this.jLabel2.setVisible(false);
        this.jLabel3.setVisible(false);
        this.jLabel4.setVisible(false);
        this.art.setVisible(false);
        this.db.setVisible(false);
        this.wirdangezeigt.setVisible(false);
        this.jButton1.setVisible(false);
        this.jButton2.setVisible(false);
        this.jButton3.setVisible(false);
    }

    public void auswahlEin() {
        this.semaphor = true;
        this.jLabel1.setVisible(true);
        this.jLabel2.setVisible(true);
        this.jLabel3.setVisible(true);
        this.jLabel4.setVisible(true);
        this.art.setVisible(true);
        this.db.setVisible(true);
        this.wirdangezeigt.removeAllItems();
        this.wirdangezeigt.setVisible(true);
        this.jButton1.setVisible(true);
        this.jButton2.setVisible(true);
        this.jButton3.setVisible(true);
        this.semaphor = false;
        this.art.setSelectedItem(ObjektKategorie.PLANETEN.getKategorienName());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.db = new JComboBox();
        this.jLabel3 = new JLabel();
        this.wirdangezeigt = new JComboBox();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel4 = new JLabel();
        this.jButton3 = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.diagramme = new JMenu();
        this.jMenu5 = new JMenu();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem23 = new JMenuItem();
        this.jMenuItem10 = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem40 = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.planetensystemeMenuItem = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem13 = new JMenuItem();
        this.menuItemStarMap = new JMenuItem();
        this.menuItemDiashow = new JMenuItem();
        this.jMenuItemStarDiameter = new JMenuItem();
        this.jMenuItemPlanetDiameter = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jmenuHilfe = new JMenuItem();
        this.setTitle("Simulationen und Statistiken");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SimulationDialog.this.formWindowClosing(windowEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SimulationDialog.this.formKeyPressed(keyEvent);
            }
        });
        this.getContentPane().setLayout(null);
        this.jLabel1.setText("Groessenvergleich zwischen:");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(20, 40, 190, 24);
        this.jLabel2.setText("in der Datenbank:");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(20, 70, 160, 24);
        this.getContentPane().add(this.db);
        this.db.setBounds(210, 70, 150, 24);
        this.jLabel3.setText("wird im Diagramm angezeigt:");
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(20, 100, 180, 24);
        this.getContentPane().add(this.wirdangezeigt);
        this.wirdangezeigt.setBounds(210, 100, 150, 24);
        this.jButton1.setText("hinzufuegen");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.jButton1);
        this.jButton1.setBounds(380, 70, 110, 24);
        this.jButton2.setText("fertig");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.jButton2ActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.jButton2);
        this.jButton2.setBounds(380, 130, 110, 24);
        this.jLabel4.setText("Wenn Sie die Liste zusammen gestellt haben, klicken Sie auf 'fertig'.");
        this.getContentPane().add(this.jLabel4);
        this.jLabel4.setBounds(20, 10, 440, 24);
        this.jButton3.setText("loeschen");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.jButton3ActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.jButton3);
        this.jButton3.setBounds(380, 100, 110, 24);
        this.diagramme.setText("Diagramme");
        this.jMenu5.setText("mehrere Kategorien");
        this.jMenuItem6.setText("Massevergleich");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.jMenuItem6ActionPerformed(actionEvent);
            }
        });
        this.jMenu5.add(this.jMenuItem6);
        this.jMenuItem5.setText("Groessenvergleich");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.jMenuItem5ActionPerformed(actionEvent);
            }
        });
        this.jMenu5.add(this.jMenuItem5);
        this.jMenuItem23.setText("Helligkeit und Entfernung");
        this.jMenuItem23.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.jMenuItem23ActionPerformed(actionEvent);
            }
        });
        this.jMenu5.add(this.jMenuItem23);
        this.diagramme.add(this.jMenu5);
        this.jMenuItem10.setText("jMenuItem10");
        this.diagramme.add(this.jMenuItem10);
        this.jMenuBar1.add(this.diagramme);
        this.jMenu3.setText("Umlaufbahn");
        this.jMenuItem40.setText("unser Sonnensystem - Asteroiden");
        this.jMenuItem40.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.jMenuItem40ActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.jMenuItem40);
        this.jMenuItem1.setText("unser Sonnensystem - Monde");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.jMenuItem1ActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.jMenuItem1);
        this.planetensystemeMenuItem.setText("Planetensysteme");
        this.planetensystemeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.planetensystemeMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.planetensystemeMenuItem);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu2.setText("Extras");
        this.jMenuItem13.setText("Heute");
        this.jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.jMenuItem13ActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.jMenuItem13);
        this.menuItemStarMap.setText("Sternenkarte");
        this.menuItemStarMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.menuItemStarMapActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.menuItemStarMap);
        this.menuItemDiashow.setText("Diashow");
        this.menuItemDiashow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.menuItemDiashowActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.menuItemDiashow);
        this.jMenuItemStarDiameter.setText("Gr\u00f6\u00dfenvergleich - Sterne");
        this.jMenuItemStarDiameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.jMenuItemStarDiameterActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.jMenuItemStarDiameter);
        this.jMenuItemPlanetDiameter.setText("jMenuItem2");
        this.jMenuItemPlanetDiameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.jMenuItemPlanetDiameterActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.jMenuItemPlanetDiameter);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu1.setText("Hilfe");
        this.jmenuHilfe.setText("Programmhilfe");
        this.jmenuHilfe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimulationDialog.this.jmenuHilfeActionPerformed(actionEvent);
            }
        });
        this.jmenuHilfe.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SimulationDialog.this.jmenuHilfeKeyPressed(keyEvent);
            }
        });
        this.jMenu1.add(this.jmenuHilfe);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        this.setSize(new Dimension(518, 350));
        this.setLocationRelativeTo(null);
    }

    private void jMenuItem40ActionPerformed(ActionEvent actionEvent) {
        try {
            this.auswahlAus();
            this.setCursor(new Cursor(3));
            SonnensystemService sonnensystemService = new SonnensystemService(this.injector);
            AsteroidenAuswahlControler asteroidenAuswahlControler = new AsteroidenAuswahlControler(sonnensystemService);
            asteroidenAuswahlControler.zeigeAuswahl();
            this.setCursor(new Cursor(0));
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(this, this.i18n.getString("sim_f1") + "\n" + exception.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    private void jmenuHilfeActionPerformed(ActionEvent actionEvent) {
        HilfeDialog hilfeDialog = new HilfeDialog("", this.i18n);
        hilfeDialog.setVisible(true);
    }

    private void menuItemStarMapActionPerformed(ActionEvent actionEvent) {
        try {
            ISternkarte iSternkarte = this.sternkartenFabrik.getInstance();
            iSternkarte.show();
        }
        catch (SQLException sQLException) {
            this.getLogger().error(sQLException);
        }
    }

    private void jMenuItem13ActionPerformed(ActionEvent actionEvent) {
        this.auswahlAus();
        Weltbilder weltbilder = new Weltbilder(this.i18n, this.getGuiDesigner());
        weltbilder.setVisible(true);
    }

    private void zeigeDiagramm(DiagrammKategorieNummer diagrammKategorieNummer, int n) {
        this.auswahlAus();
        this.setCursor(new Cursor(3));
        switch (diagrammKategorieNummer.getNummer()) {
            case 0: {
                DiagrammeAllgemein diagrammeAllgemein = new DiagrammeAllgemein(n, null, this, this.i18n, this.injector.getInstance(IDAOlowAllgemein.class), this.injector.getInstance(IKategorienRepository.class), this.injector.getInstance(IPlanetensucheObjektRepository.class), this.injector.getInstance(IObjektnamenRepository.class));
                diagrammeAllgemein.showDiagramm();
                break;
            }
            default: {
                throw new IllegalArgumentException("Kein Diagramm fuer Kategorie '" + String.valueOf((Object)diagrammKategorieNummer) + "' gefunden!");
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void jButton3ActionPerformed(ActionEvent actionEvent) {
        this.wirdangezeigt.removeAllItems();
    }

    private void formWindowClosing(WindowEvent windowEvent) {
    }

    private void jButton2ActionPerformed(ActionEvent actionEvent) {
        if (this.wirdangezeigt.getItemCount() > 0) {
            DiagrammeAllgemein diagrammeAllgemein = new DiagrammeAllgemein(10 + this.auswahl, this.wirdangezeigt, this, this.i18n, this.injector.getInstance(IDAOlowAllgemein.class), this.injector.getInstance(IKategorienRepository.class), this.injector.getInstance(IPlanetensucheObjektRepository.class), this.injector.getInstance(IObjektnamenRepository.class));
            diagrammeAllgemein.showDiagramm();
        }
    }

    private void menuItemDiashowActionPerformed(ActionEvent actionEvent) {
        this.auswahlAus();
        DiashowGui diashowGui = new DiashowGui(this.i18n);
        diashowGui.setVisible(true);
    }

    private void planetensystemeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.auswahl = 5;
        ExoplanetensystemeListeControler exoplanetensystemeListeControler = new ExoplanetensystemeListeControler(this.injector.getInstance(IPlanetensucheObjektRepository.class), this.injector.getInstance(IExoplanetensystemeRepository.class), this.injector.getInstance(IObjektnamenRepository.class), this.injector.getInstance(IHabitableZoneRepository.class));
        exoplanetensystemeListeControler.zeigeListe(this);
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(this.wirdangezeigt.getItemCount());
        for (n = 0; n < this.wirdangezeigt.getItemCount(); ++n) {
            arrayList.add(this.wirdangezeigt.getItemAt(n).toString());
        }
        n = this.auswahl == 5 ? 1 : 5;
        if (this.wirdangezeigt.getItemCount() < n && !arrayList.contains(this.db.getSelectedItem().toString())) {
            this.wirdangezeigt.addItem(this.db.getSelectedItem().toString());
        } else {
            JOptionPane.showMessageDialog(this, this.i18n.getString("sim_m6") + " " + n + " " + this.i18n.getString("sim_m7"), this.i18n.getString("db_f4_titel"), 2);
        }
    }

    private void jmenuHilfeKeyPressed(KeyEvent keyEvent) {
    }

    private void formKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 112) {
            HilfeDialog hilfeDialog = new HilfeDialog("", this.i18n);
            hilfeDialog.setVisible(true);
        }
    }

    private void artActionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.semaphor) {
                IObjektnamenSimulationDAO iObjektnamenSimulationDAO = this.injector.getInstance(IObjektnamenSimulationDAO.class);
                List<String> list = this.jLabel1.getText().equals(this.i18n.getString("sim_gui69")) ? iObjektnamenSimulationDAO.getNames(this.art.getSelectedInternalValue(), FilterCriteria.MASS_NOT_NULL) : iObjektnamenSimulationDAO.getNames(this.art.getSelectedInternalValue(), FilterCriteria.DIAMETER_NOT_NULL);
                Collections.sort(list);
                this.db.removeAllItems();
                for (int i = 0; i < list.size(); ++i) {
                    this.db.addItem(list.get(i));
                }
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
        }
    }

    private void jMenuItem23ActionPerformed(ActionEvent actionEvent) {
        this.zeigeDiagramm(DiagrammKategorieNummer.DIAGRAMM_ALLGEMEIN, 15);
    }

    private void jMenuItem5ActionPerformed(ActionEvent actionEvent) {
        this.jLabel1.setText(this.i18n.getString("sim_gui3"));
        this.auswahlEin();
        this.auswahl = 1;
    }

    private void jMenuItem6ActionPerformed(ActionEvent actionEvent) {
        this.jLabel1.setText(this.i18n.getString("sim_gui69"));
        this.auswahlEin();
        this.auswahl = 2;
    }

    private void jMenuItem1ActionPerformed(ActionEvent actionEvent) {
        try {
            this.auswahlAus();
            this.setCursor(new Cursor(3));
            SonnensystemService sonnensystemService = new SonnensystemService(this.injector);
            SonnensystemGui sonnensystemGui = new SonnensystemGui(sonnensystemService, this.i18n, this.getGuiDesigner());
            sonnensystemGui.setVisible(true);
            this.setCursor(new Cursor(0));
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(this, this.i18n.getString("sim_f1") + "\n" + exception.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    private void jMenuItemStarDiameterActionPerformed(ActionEvent actionEvent) {
        CompareDiameterController compareDiameterController = new CompareDiameterController(this.injector);
        compareDiameterController.showStarComparison(this);
    }

    private void jMenuItemPlanetDiameterActionPerformed(ActionEvent actionEvent) {
        CompareDiameterController compareDiameterController = new CompareDiameterController(this.injector);
        compareDiameterController.showPlanetComparison(this);
    }
}

