/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen;

import com.google.inject.Injector;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.errorlogger.api.Modulnummer;
import de.planetensuche.guidesigner.IPlanetensucheModul;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.simulationen.BeanFactory;
import de.planetensuche.simulationen.SimulationDialog;
import java.io.IOException;
import javax.swing.JOptionPane;

public final class Start
implements IPlanetensucheModul {
    private final ILogging logging;
    private final KonfigurationDTO konfigurationsDto;
    private SimulationDialog simulationDialog;

    public Start(KonfigurationDTO konfigurationDTO) throws IOException {
        this.konfigurationsDto = konfigurationDTO;
        this.logging = LoggingFactory.getLoggerForModule(Modulnummer.HAUPTLOG);
    }

    public void error(Exception exception, String string, String string2, boolean bl) {
        if (exception != null && string.isEmpty()) {
            this.logging.error(exception);
        } else if (exception != null && !string.isEmpty()) {
            this.logging.error(string, exception);
        } else if (exception == null && !string.isEmpty()) {
            this.logging.info(string);
        }
        if (bl) {
            JOptionPane.showMessageDialog(null, string, string2, 0);
        }
    }

    @Override
    public void showDialog() {
        if (this.simulationDialog == null) {
            this.simulationDialog = this.initSimulationsDialog();
        }
        this.simulationDialog.setVisible(true);
    }

    private SimulationDialog initSimulationsDialog() {
        this.logging.info("Simulation gestartet");
        Injector injector = BeanFactory.getInjector();
        SimulationDialog simulationDialog = new SimulationDialog(this.konfigurationsDto.getKoordinatenFormat(), injector);
        return simulationDialog;
    }
}

