/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen;

import de.planetensuche.guidesigner.IGuiDesigner;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public final class Weltbilder
extends Frame {
    private final ISprachcontainer sprache;
    private final IGuiDesigner guiDesigner;
    private int bildhoehe;
    private int bildbreite;
    private int sterne;

    public Weltbilder(ISprachcontainer iSprachcontainer, IGuiDesigner iGuiDesigner) {
        this.sprache = iSprachcontainer;
        this.guiDesigner = iGuiDesigner;
        this.sterne = 0;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.bildbreite = (int)dimension.getWidth();
        this.bildhoehe = (int)dimension.getHeight() - 30;
        this.setBounds(0, 0, this.bildbreite, this.bildhoehe);
        this.setResizable(false);
        this.setBackground(Color.black);
        this.setTitle(iSprachcontainer.getString("sim_fenster7"));
        this.setIconImage(IconPoolCustom.LOGO.getImageIcon().getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Weltbilder.this.setVisible(false);
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        graphics.setFont(this.guiDesigner.getFont(false));
        graphics.setColor(Color.white);
        graphics.setFont(new Font("Serif", 1, 20));
        for (n3 = 0; n3 < 400; ++n3) {
            n2 = (int)Math.round((double)this.bildbreite / 2.0 - Math.sin(n3) * 80.0);
            n = (int)Math.round((double)this.bildhoehe / 2.0 - 50.0 - Math.cos(n3) * 20.0);
            this.zeichneGalaxienarm(graphics, n2, n, 2, Color.yellow);
        }
        for (n3 = 0; n3 < 400; ++n3) {
            n2 = (int)Math.round((double)this.bildbreite / 2.0 - Math.sin(n3) * 200.0);
            n = (int)Math.round((double)this.bildhoehe / 2.0 - Math.cos(n3) * 100.0);
            if (n <= this.bildhoehe / 2 && (n >= this.bildhoehe / 2 || n2 >= this.bildbreite / 2)) continue;
            this.zeichneGalaxienarm(graphics, n2, n, 2, Color.white);
        }
        for (n3 = 0; n3 < 400; ++n3) {
            n2 = (int)Math.round((double)this.bildbreite / 2.0 - 175.0 - Math.sin(n3) * 400.0);
            n = (int)Math.round((double)this.bildhoehe / 2.0 - 50.0 - Math.cos(n3) * 350.0);
            if (n >= this.bildhoehe / 2 || n2 <= this.bildbreite / 2 - 400) continue;
            this.zeichneGalaxienarm(graphics, n2, n, 2, Color.white);
        }
        for (n3 = 0; n3 < 400; ++n3) {
            n2 = (int)Math.round((double)this.bildbreite / 2.0 + 75.0 - Math.sin(n3) * 200.0);
            n = (int)Math.round((double)this.bildhoehe / 2.0 + 75.0 - Math.cos(n3) * 100.0);
            if (n <= this.bildhoehe / 2 + 60) continue;
            this.zeichneGalaxienarm(graphics, n2, n, 2, Color.white);
        }
        for (n3 = 0; n3 < 400; ++n3) {
            n2 = (int)Math.round((double)this.bildbreite / 2.0 + 125.0 - Math.sin(n3) * 200.0);
            n = (int)Math.round((double)this.bildhoehe / 2.0 - 125.0 - Math.cos(n3) * 280.0);
            if (n2 <= this.bildbreite / 2 + 125) continue;
            this.zeichneGalaxienarm(graphics, n2, n, 2, Color.white);
        }
        for (n3 = 0; n3 < 400; ++n3) {
            n2 = (int)Math.round((double)this.bildbreite / 2.0 - 50.0 + Math.sin(n3) * 200.0);
            n = (int)Math.round((double)this.bildhoehe / 2.0 - 100.0 + Math.cos(n3) * 100.0);
            if (n2 <= this.bildbreite / 2 - 50) continue;
            this.zeichneGalaxienarm(graphics, n2, n, 2, Color.white);
        }
        for (n3 = 0; n3 < 400; ++n3) {
            n2 = (int)Math.round((double)this.bildbreite / 2.0 + 50.0 + Math.sin(n3) * 400.0);
            n = (int)Math.round((double)this.bildhoehe / 2.0 + Math.cos(n3) * 200.0);
            if (n2 >= this.bildbreite / 2) continue;
            this.zeichneGalaxienarm(graphics, n2, n, 2, Color.white);
        }
        for (n3 = 0; n3 < 400; ++n3) {
            n2 = (int)Math.round((double)this.bildbreite / 2.0 + 25.0 + Math.sin(n3) * 400.0);
            n = (int)Math.round((double)this.bildhoehe / 2.0 - 175.0 + Math.cos(n3) * 400.0);
            if (n2 <= this.bildbreite / 2 - 50 || n <= 100) continue;
            this.zeichneGalaxienarm(graphics, n2, n, 2, Color.white);
        }
        for (n3 = 0; n3 < 400; ++n3) {
            n2 = (int)Math.round((double)this.bildbreite / 2.0 - 125.0 + Math.sin(n3) * 300.0);
            n = (int)Math.round((double)this.bildhoehe / 2.0 - Math.cos(n3) * 300.0);
            if (!((double)n2 < (double)this.bildbreite / 2.0 - 50.0) && !((double)n < (double)this.bildhoehe / 2.0)) continue;
            this.zeichneGalaxienarm(graphics, n2, n, 2, Color.white);
        }
        graphics.setColor(Color.gray);
        graphics.fillRect((int)((double)this.bildbreite / 2.0) - 55, (int)((double)this.bildhoehe / 2.0) + 55, 120, 30);
        graphics.fillRect((int)((double)this.bildbreite / 2.0) + 90, (int)((double)this.bildhoehe / 2.0) + 105, 180, 30);
        graphics.fillRect((int)((double)this.bildbreite / 2.0 - 400.0), (int)((double)this.bildhoehe / 2.0 - 20.0), 150, 30);
        graphics.fillRect((int)((double)this.bildbreite / 2.0 - 505.0), (int)((double)this.bildhoehe / 2.0 - 120.0), 130, 30);
        graphics.setColor(Color.white);
        graphics.drawString("Norma-" + this.sprache.getString("sim_m104"), this.bildbreite / 2 - 50, this.bildhoehe / 2 + 75);
        graphics.drawString("Scutum-Crux-" + this.sprache.getString("sim_m104"), this.bildbreite / 2 + 100, this.bildhoehe / 2 + 125);
        graphics.drawString("Sagittarius-" + this.sprache.getString("sim_m104"), this.bildbreite / 2 - 395, this.bildhoehe / 2);
        graphics.drawString("Perseus-" + this.sprache.getString("sim_m104"), this.bildbreite / 2 - 500, this.bildhoehe / 2 - 100);
        graphics.setColor(Color.yellow);
        graphics.fillOval(this.bildbreite / 2 - 400, this.bildhoehe / 2 + 60, 30, 30);
        graphics.setColor(Color.gray);
        graphics.fillRect(this.bildbreite / 2 - 400, this.bildhoehe / 2 + 100, 70, 30);
        graphics.setColor(Color.white);
        graphics.drawString(this.sprache.getString("sim_m103"), this.bildbreite / 2 - 390, this.bildhoehe / 2 + 120);
    }

    private void zeichneGalaxienarm(Graphics graphics, int n, int n2, int n3, Color color) {
        int n4;
        graphics.setFont(this.guiDesigner.getFont(false));
        graphics.setColor(color);
        int n5 = n;
        int n6 = n2;
        graphics.fillOval(n5, n6, 2, 2);
        ++this.sterne;
        for (n4 = 1; n4 < 40; ++n4) {
            graphics.fillOval((int)((double)n5 + Math.random() * (double)n4), (int)((double)n6 + Math.random() * (double)(n4 + 1)), 2, 2);
            graphics.fillOval((int)((double)n5 + Math.random() * (double)(n4 + 1)), (int)((double)n6 + Math.random() * (double)n4), 2, 2);
            graphics.fillOval((int)((double)n5 - Math.random() * (double)n4), (int)((double)n6 - Math.random() * (double)(n4 + 1)), 2, 2);
            graphics.fillOval((int)((double)n5 - Math.random() * (double)(n4 + 1)), (int)((double)n6 - Math.random() * (double)n4), 2, 2);
            this.sterne += 4;
        }
        if (n3 == 2) {
            for (n4 = 40; n4 < 62; ++n4) {
                graphics.fillOval((int)((double)n5 + Math.random() * (double)n4), (int)((double)n6 + Math.random() * (double)(n4 + 2)), 2, 2);
                graphics.fillOval((int)((double)n5 + Math.random() * (double)(n4 + 2)), (int)((double)n6 + Math.random() * (double)n4), 2, 2);
                graphics.fillOval((int)((double)n5 - Math.random() * (double)n4), (int)((double)n6 - Math.random() * (double)(n4 + 2)), 2, 2);
                graphics.fillOval((int)((double)n5 - Math.random() * (double)(n4 + 2)), (int)((double)n6 - Math.random() * (double)n4), 2, 2);
                this.sterne += 4;
            }
        }
    }
}

