/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.basis;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.cache.IdCacheDAO;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.simulationen.dbmodel.basis.CountDto;
import de.planetensuche.simulationen.dbmodel.basis.ICountDAO;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class CountDAO
implements ICountDAO {
    private final IDatenbankverbinder datenbankverbinder;
    private final IdCacheDAO idCache;

    @Inject
    public CountDAO(IDatenbankverbinder iDatenbankverbinder, IdCacheDAO idCacheDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCache = idCacheDAO;
    }

    @Override
    public CountDto countObjects(ObjektKategorie objektKategorie, NumberPath<Double> numberPath, double d, double d2, double d3) throws SQLException {
        BooleanExpression booleanExpression;
        List<Integer> list;
        QDaten qDaten = QDaten.daten;
        if (ObjektKategorie.PLANETEN.getKategorienName().equals(objektKategorie.getKategorienName())) {
            list = this.idCache.getObjekttypenidsPlaneten();
            booleanExpression = qDaten.entdeckungbestaetigt.isTrue().and(qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne()));
        } else if (ObjektKategorie.STERNE.getKategorienName().equals(objektKategorie.getKategorienName())) {
            list = this.idCache.getObjekttypenidsSterne();
            booleanExpression = qDaten.id.ne(this.idCache.getDatenIdSonne());
        } else {
            throw new UnsupportedOperationException("category " + String.valueOf((Object)objektKategorie) + " is not supported yet");
        }
        double d4 = d2;
        if (d == d2) {
            d4 = d2 + 1.0E-6;
        }
        CountDto countDto = new CountDto();
        SQLQueryFactory sQLQueryFactory = this.datenbankverbinder.getQueryFactory();
        long l = ((SQLQuery)((SQLQuery)sQLQueryFactory.select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)list).and(booleanExpression).and(numberPath.eq(d)))).fetchCount();
        countDto.setCountObjectsNoValues(l);
        List list2 = ((SQLQuery)((SQLQuery)sQLQueryFactory.select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)list).and(booleanExpression).and(numberPath.between(d4, d3)))).fetch();
        countDto.setCountObjectsEquals(list2.size());
        countDto.setDatenIdsObjectsEquals(new HashSet<Integer>(list2));
        long l2 = ((SQLQuery)((SQLQuery)sQLQueryFactory.select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)list).and(booleanExpression))).fetchCount();
        countDto.setCountObjectsNonEquals(l2 - countDto.getCountObjectsNoValues() - (long)list2.size());
        return countDto;
    }
}

