/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.basis;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.IDAOhigh;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.util.SptypDoubleKonverter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class DAOhigh
implements IDAOhigh {
    private final ILogging logging;
    private final ISterneDAO sterneDAO;
    private final IDatenbankService datenbankService;
    private final IKategorienRepository kategorienRepository;

    @Inject
    public DAOhigh(ISterneDAO iSterneDAO, IDatenbankService iDatenbankService, IKategorienRepository iKategorienRepository) {
        this.sterneDAO = iSterneDAO;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.datenbankService = iDatenbankService;
        this.kategorienRepository = iKategorienRepository;
    }

    @Override
    public List<String> getKategorien() throws SQLException {
        return this.kategorienRepository.getKategorien();
    }

    @Override
    public String korrigiereNamen(String string) {
        Object object = "";
        String string2 = string;
        try {
            string2 = string2.replaceAll("upsilon", "Ypsilon");
            string2 = string2.replaceAll("Upsilon", "Ypsilon");
            string2 = string2.replaceAll("Ups", "Upsilon");
            String[] stringArray = string2.split(" ");
            if (stringArray.length < 2) {
                return "";
            }
            List<String> list = this.datenbankService.getSternbilderNamen(SternbildSprache.LATEINISCH_ABK);
            list.remove("");
            for (int i = 0; i < list.size(); ++i) {
                if (!stringArray[1].toLowerCase().equals(list.get(i).toLowerCase())) continue;
                String string3 = this.datenbankService.getSternbildGenitiv(list.get(i));
                StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
                stringBuilder.append(" ");
                stringBuilder.append(string3);
                if (stringArray.length == 3) {
                    stringBuilder.append(" ");
                    stringBuilder.append(stringArray[2]);
                }
                object = list.get(i) + ":::" + string3 + ":::" + stringBuilder.toString();
                this.logging.debug(object);
                return stringBuilder.toString();
            }
            return string2;
        }
        catch (Exception exception) {
            this.logging.error("Fehler in korrigiereNamen(kurzform='" + string + "', fehler in='" + (String)object + "')", exception);
            return "";
        }
    }

    @Override
    public List<String> getSterneMitEntfernung(double d) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SptypDoubleKonverter sptypDoubleKonverter = new SptypDoubleKonverter();
        List<String> list = this.sterneDAO.getSterneMitEntfernung(d);
        for (int i = 0; i < list.size(); ++i) {
            double d2;
            String[] stringArray = list.get(i).split(";");
            String string = "";
            double d3 = -1.0;
            double d4 = -1.0;
            try {
                string = stringArray[0];
                d3 = Double.parseDouble(stringArray[1]);
                d4 = Double.parseDouble(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                this.logging.error(numberFormatException);
            }
            if (d3 == -1.0 || d4 == -1.0 || !((d2 = sptypDoubleKonverter.getDoubleForSptyp(string.charAt(0))) > -1.0) || !((d3 += d2) > 0.0) || !(d4 <= d) || !(d4 > 0.0)) continue;
            arrayList.add(Double.toString(d4) + ";" + Double.toString(d3));
        }
        return arrayList;
    }
}

