/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.basis;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.helfer.Konverter;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.api.IDAOlowAllgemein;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class DAOlowAllgemein
implements IDAOlowAllgemein {
    private final ILogging logging;
    private final IIdCacheDAO idCache;
    private final ISterneDAO sterneDao;
    private final String sqlAnd;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public DAOlowAllgemein(IIdCacheDAO iIdCacheDAO, ISterneDAO iSterneDAO, IDatenbankverbinder iDatenbankverbinder) {
        this.idCache = iIdCacheDAO;
        this.sterneDao = iSterneDAO;
        this.sqlAnd = " AND ";
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public double[][] getDurchmesserHelligkeitAlbedo(double d, double d2) {
        try {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            String[] stringArray = new String[]{"albedo", "sh"};
            for (int n : this.idCache.getObjekttypenidsMonde()) {
                String string = "SELECT albedo, sh FROM daten WHERE objektid=" + n + " AND sh>-100.0 AND albedo>0.0 AND durchmesser<=" + d + " AND durchmesser>" + d2 + ";";
                arrayList.addAll(this.getDatenbankService().getListeMitDoubleOld(string, stringArray));
            }
            return Konverter.convertListToArray(arrayList);
        }
        catch (SQLException sQLException) {
            this.logging.error("getDurchmesserHelligkeitAlbedo(" + d + "," + d2 + ")", sQLException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getHelligkeitUndEntfernung(String string, double d) {
        try {
            String[] stringArray = new String[]{"entfernung", "sh"};
            List<Double> list = this.getDatenbankService().getListeMitDoubleOld("SELECT Entfernung, sh FROM daten WHERE objektid IN (SELECT id FROM objekttypen WHERE kategorieid=(SELECT id FROM kategorie WHERE Name='" + string + "')) AND Entfernung>0.0 AND Entfernung<" + d + " AND sh>-10.0;", stringArray);
            return Konverter.convertListToArray(list);
        }
        catch (SQLException sQLException) {
            this.logging.error("getHelligkeitUndEntfernung(" + string + ")", sQLException);
            return new double[0][0];
        }
    }

    @Override
    public List<ErgebnisXYDto> getDatenFuerSpalten(List<Integer> list, NumberPath<Double> numberPath, NumberPath<Double> numberPath2, double d, double d2, double d3, double d4, boolean bl) throws SQLException {
        QDaten qDaten = QDaten.daten;
        BooleanExpression booleanExpression = bl ? qDaten.zugehoerigkeit.eq(this.idCache.getDatenIdSonne()) : qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne());
        List list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{numberPath, numberPath2}).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)list).and(booleanExpression).and(qDaten.entdeckungbestaetigt.isTrue()).and(numberPath.between(d, d2)).and(numberPath2.between(d3, d4)))).fetch();
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        for (Tuple tuple : list2) {
            ErgebnisXYDto ergebnisXYDto = new ErgebnisXYDto(tuple.get(numberPath), tuple.get(numberPath2));
            arrayList.add(ergebnisXYDto);
        }
        return arrayList;
    }

    @Override
    public double[][] getTemperaturUndHelligkeit(boolean bl, String string) {
        List<Object> list = new ArrayList();
        if (ObjektKategorie.STERNE.getKategorienName().equals(string)) {
            list = this.idCache.getObjekttypenidsSterne();
        } else if (ObjektKategorie.BR_ZWERGE.getKategorienName().equals(string)) {
            list = this.idCache.getObjekttypenidsBraunezwerge();
        }
        QDaten qDaten = new QDaten("planeten");
        QDaten qDaten2 = new QDaten("eltern");
        BooleanExpression booleanExpression = bl ? qDaten.id.isNotNull().and(qDaten.entdeckungbestaetigt.isTrue()) : qDaten.id.isNull();
        List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten2.temperatur, qDaten2.ah}).from((Expression<?>)qDaten2)).leftJoin((EntityPath)qDaten)).on((Predicate)qDaten2.id.eq(qDaten.zugehoerigkeit))).where(qDaten2.objektid.in((Collection<Integer>)list).and(qDaten2.temperatur.gt(0.0)).and(qDaten2.ah.gt(-100.0)).and(booleanExpression))).groupBy((Expression<?>)qDaten2.id)).fetch();
        double[][] dArray = new double[list2.size()][2];
        int n = 0;
        for (Tuple tuple : list2) {
            dArray[n][0] = tuple.get(qDaten2.temperatur);
            dArray[n][1] = tuple.get(qDaten2.ah);
            ++n;
        }
        return dArray;
    }

    @Override
    public boolean getDatenFuerSonnensystem(List<String> list, List<String> list2) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("keine Namen angegeben");
        }
        try {
            StringBuilder stringBuilder = new StringBuilder(list.size());
            for (String stringArray2 : list) {
                stringBuilder.append("'").append(stringArray2).append("', ");
            }
            String string = stringBuilder.substring(0, stringBuilder.length() - 2);
            String[] stringArray = new String[]{"entfernung", "exzentritaet", "umlaufszeit"};
            List<String> list3 = this.getDatenbankService().getListeMitStrings("SELECT d.entfernung, d.exzentritaet, d.umlaufszeit FROM daten AS d JOIN namen AS n ON d.id=n.datenid WHERE n.namen IN (" + (String)string + ");", stringArray, ";");
            for (int i = 0; i < list3.size(); ++i) {
                list2.add(list.get(i) + ";" + list3.get(i));
            }
            return true;
        }
        catch (SQLException sQLException) {
            this.logging.error("getDatenFuerSonnensystem(" + list.size() + "," + list2.size() + ")", sQLException);
            return false;
        }
    }

    private IDatenbankService getDatenbankService() {
        return BeanFactory.getInstance();
    }
}

