/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.basis;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.IEntdeckungsdatumDAO;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public final class EntdeckungsdatumDAO
implements IEntdeckungsdatumDAO {
    private final ILogging logging;
    private final IIdCacheDAO idCache;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public EntdeckungsdatumDAO(IIdCacheDAO iIdCacheDAO, IDatenbankverbinder iDatenbankverbinder) {
        this.idCache = iIdCacheDAO;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public List<Double> getValuesForDiscoveryYearAndColumn(int n, NumberPath<Double> numberPath, double d, boolean bl) throws SQLException {
        QDaten qDaten = QDaten.daten;
        BooleanExpression booleanExpression = bl ? qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne()) : qDaten.zugehoerigkeit.eq(this.idCache.getDatenIdSonne());
        return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)numberPath).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungsjahr.eq(n)).and(qDaten.entdeckungbestaetigt.isTrue()).and(numberPath.between(1.0E-6, d)).and(booleanExpression))).fetch();
    }

    @Override
    public int getAnzahlProEntdeckungsjahr(int n, ObjektKategorie objektKategorie) {
        BooleanExpression booleanExpression;
        QDaten qDaten = QDaten.daten;
        List<Integer> list = null;
        if (ObjektKategorie.PLANETEN.equals((Object)objektKategorie)) {
            list = this.idCache.getObjekttypenidsPlaneten();
            booleanExpression = qDaten.entdeckungbestaetigt.isTrue();
        } else if (ObjektKategorie.MONDE.equals((Object)objektKategorie)) {
            list = this.idCache.getObjekttypenidsMonde();
            booleanExpression = qDaten.zugehoerigkeit.isNotNull();
        } else if (ObjektKategorie.GALAXIE_NEBEL.equals((Object)objektKategorie)) {
            list = this.idCache.getObjekttypenidsGalaxienundnebel();
            booleanExpression = Expressions.TRUE.isTrue();
        } else if (ObjektKategorie.STERNHAUFEN.equals((Object)objektKategorie)) {
            list = this.idCache.getObjekttypenidsSternhaufen();
            booleanExpression = Expressions.TRUE.isTrue();
        } else if (ObjektKategorie.ASTEROIDEN.equals((Object)objektKategorie)) {
            list = this.idCache.getObjekttypenidsAsteroiden();
            booleanExpression = Expressions.TRUE.isTrue();
        } else if (ObjektKategorie.KOMETEN.equals((Object)objektKategorie)) {
            list = this.idCache.getObjekttypenidsKometen();
            booleanExpression = Expressions.TRUE.isTrue();
        } else if (ObjektKategorie.BR_ZWERGE.equals((Object)objektKategorie)) {
            list = this.idCache.getObjekttypenidsBraunezwerge();
            booleanExpression = Expressions.TRUE.isTrue();
        } else {
            this.logging.warn("got " + String.valueOf((Object)objektKategorie) + " as category but is not supported!");
            throw new UnsupportedOperationException("category " + String.valueOf((Object)objektKategorie) + " is not supported yet");
        }
        return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)list).and(qDaten.entdeckungsjahr.eq(n)).and(booleanExpression))).fetchCount();
    }
}

