/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.basis;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.api.IFHDDAO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class FHDDAO
implements IFHDDAO {
    private final ILogging logging;
    private final IIdCacheDAO idCache;
    private final IObjektnamenRepository objektnamenRepository;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public FHDDAO(IIdCacheDAO iIdCacheDAO, IObjektnamenRepository iObjektnamenRepository, IDatenbankverbinder iDatenbankverbinder) {
        this.idCache = iIdCacheDAO;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.objektnamenRepository = iObjektnamenRepository;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public List<ErgebnisXYDto> getFHD(String string) {
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        try {
            List list;
            QDaten qDaten = QDaten.daten;
            int n = 0;
            if (!"".equals(string)) {
                int n2 = string.indexOf(" (");
                String string2 = string.substring(0, n2);
                n = this.objektnamenRepository.getIDFuerNamen(string2, true);
            } else {
                for (int n3 : this.idCache.getObjekttypenidsBraunezwerge()) {
                    list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.ah, qDaten.bv}).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n3).and(qDaten.ah.gt(-100.0)).and(qDaten.bv.gt(-100.0)))).fetch();
                    for (Tuple tuple : list) {
                        arrayList.add(new ErgebnisXYDto(tuple.get(qDaten.bv), tuple.get(qDaten.ah)));
                    }
                }
            }
            for (int n4 : this.idCache.getObjekttypenidsSterne()) {
                if (!"".equals(string)) {
                    list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.ah, qDaten.bv}).from((Expression<?>)qDaten)).where(qDaten.zugehoerigkeit.eq(n).and(qDaten.objektid.eq(n4)).and(qDaten.ah.gt(-100.0)).and(qDaten.bv.gt(-100.0)))).fetch();
                    for (Tuple tuple : list) {
                        arrayList.add(new ErgebnisXYDto(tuple.get(qDaten.bv), tuple.get(qDaten.ah)));
                    }
                    continue;
                }
                list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.ah, qDaten.bv}).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n4).and(qDaten.ah.gt(-100.0)).and(qDaten.bv.gt(-100.0)))).fetch();
                for (Tuple tuple : list) {
                    arrayList.add(new ErgebnisXYDto(tuple.get(qDaten.bv), tuple.get(qDaten.ah)));
                }
            }
        }
        catch (SQLException sQLException) {
            this.logging.error("getFHD(" + string + ")", sQLException);
        }
        return arrayList;
    }
}

