/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.basis;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.Temperatur;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp2;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.api.IHRDDAO;
import de.planetensuche.simulationen.diagramme.util.SptypDoubleKonverter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class HRDDAO
implements IHRDDAO {
    private final ILogging logging;
    private final IIdCacheDAO idCache;
    private final IObjektnamenRepository objektnamenRepository;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public HRDDAO(IIdCacheDAO iIdCacheDAO, IObjektnamenRepository iObjektnamenRepository, IDatenbankverbinder iDatenbankverbinder) {
        this.idCache = iIdCacheDAO;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.objektnamenRepository = iObjektnamenRepository;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public List<ErgebnisXYDto> getHRD(String string) {
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        SptypDoubleKonverter sptypDoubleKonverter = new SptypDoubleKonverter();
        try {
            double d;
            double d2;
            List<Double> list;
            Object object;
            Object object2;
            QDaten qDaten = QDaten.daten;
            QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
            QSpektraltyp2 qSpektraltyp2 = QSpektraltyp2.spektraltyp2;
            int n = 0;
            if (!string.isEmpty()) {
                int n2 = string.indexOf(" (");
                object2 = string.substring(0, n2);
                n = this.objektnamenRepository.getIDFuerNamen((String)object2, true);
            } else {
                for (int n3 : this.idCache.getObjekttypenidsBraunezwerge()) {
                    object = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.ah, qDaten.temperatur, qSpektraltyp.typ, qSpektraltyp2.typ}).from((Expression<?>)qDaten)).join((ForeignKey)qDaten.sptypFk, (RelationalPath)qSpektraltyp)).join((ForeignKey)qDaten.sptyp2Fk, (RelationalPath)qSpektraltyp2)).where(qDaten.objektid.eq(n3).and(qDaten.ah.gt(-100.0)))).fetch();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        list = (Tuple)iterator.next();
                        String string2 = list.get(qSpektraltyp.typ);
                        double d3 = list.get(qSpektraltyp2.typ);
                        d2 = list.get(qDaten.ah);
                        if (string2 == null || !((d = sptypDoubleKonverter.getDoubleForSptyp(string2.charAt(0))) > -1.0)) continue;
                        arrayList.add(new ErgebnisXYDto(d3 + d, d2));
                    }
                }
            }
            Integer n4 = this.getObjekttypenIdWeisseZwerge();
            object2 = new Temperatur();
            object = this.idCache.getObjekttypenidsSterne().iterator();
            while (object.hasNext()) {
                int n5 = object.next();
                list = !string.isEmpty() ? ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.ah, qDaten.temperatur, qSpektraltyp.typ, qSpektraltyp2.typ}).from((Expression<?>)qDaten)).join((ForeignKey)qDaten.sptypFk, (RelationalPath)qSpektraltyp)).join((ForeignKey)qDaten.sptyp2Fk, (RelationalPath)qSpektraltyp2)).where(qDaten.zugehoerigkeit.eq(n).and(qDaten.objektid.eq(n5)).and(qDaten.ah.gt(-100.0)))).fetch() : ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.ah, qDaten.temperatur, qSpektraltyp.typ, qSpektraltyp2.typ}).from((Expression<?>)qDaten)).join((ForeignKey)qDaten.sptypFk, (RelationalPath)qSpektraltyp)).join((ForeignKey)qDaten.sptyp2Fk, (RelationalPath)qSpektraltyp2)).where(qDaten.objektid.eq(n5).and(qDaten.ah.gt(-100.0)))).fetch();
                for (Tuple tuple : list) {
                    double d4;
                    String string3 = tuple.get(qSpektraltyp.typ);
                    d2 = tuple.get(qSpektraltyp2.typ);
                    d = tuple.get(qDaten.ah);
                    double d5 = tuple.get(qDaten.temperatur);
                    if ((string3 == null || string3.isEmpty() || "unbekannt".equals(string3)) && d5 > 0.0) {
                        boolean bl = n5 == n4;
                        String string4 = ((Temperatur)object2).getSpektraltypFuerStern(d5, bl);
                        int n6 = bl ? 2 : 1;
                        string3 = string4.substring(0, n6);
                        d2 = Double.parseDouble(string4.substring(n6, string4.length()));
                    }
                    if (string3 == null || !((d4 = this.getSpektraltypDoubleValue(string3, sptypDoubleKonverter)) > -1.0)) continue;
                    arrayList.add(new ErgebnisXYDto(d2 + d4, d));
                }
            }
        }
        catch (SQLException sQLException) {
            this.logging.error("getHRD(" + string + ")", sQLException);
        }
        return arrayList;
    }

    private Integer getObjekttypenIdWeisseZwerge() throws SQLException {
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Weisser Zwerg"))).fetchFirst();
        return n;
    }

    private double getSpektraltypDoubleValue(String string, SptypDoubleKonverter sptypDoubleKonverter) {
        double d = string.startsWith("D") ? sptypDoubleKonverter.getWertFuerWeissenZwerg(string) : sptypDoubleKonverter.getDoubleForSptyp(string.charAt(0));
        return d;
    }
}

