/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.basis;

import com.google.inject.Inject;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.FilterCriteria;
import de.planetensuche.simulationen.dbmodel.api.IObjektnamenSimulationDAO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ObjektnamenSimulationDAO
implements IObjektnamenSimulationDAO {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public ObjektnamenSimulationDAO(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public List<String> getNames(String string, FilterCriteria filterCriteria) {
        if (filterCriteria == null) {
            throw new IllegalArgumentException("FilterCriteria ist null");
        }
        List<String> list = new ArrayList<String>();
        try {
            List<Integer> list2 = this.getObjekttypenIds(string);
            QDaten qDaten = QDaten.daten;
            QNamen qNamen = QNamen.namen1;
            BooleanExpression booleanExpression = null;
            if (FilterCriteria.DIAMETER_NOT_NULL.equals((Object)filterCriteria)) {
                booleanExpression = qDaten.durchmesser.gt(0.0);
            } else if (FilterCriteria.MASS_NOT_NULL.equals((Object)filterCriteria)) {
                booleanExpression = qDaten.masse.gt(0.0);
            }
            list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qDaten)).join((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)list2).and(booleanExpression))).fetch();
        }
        catch (SQLException sQLException) {
            this.logger.error("Fehler getNames(" + string + "," + String.valueOf((Object)filterCriteria) + ")", sQLException);
        }
        return list;
    }

    private List<Integer> getObjekttypenIds(String string) throws SQLException {
        QKategorie qKategorie = QKategorie.kategorie;
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        List<Integer> list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).join((EntityPath)qKategorie)).on((Predicate)qKategorie.id.eq(qObjekttypen.kategorieid))).where(qKategorie.name.eq(string))).fetch();
        return list;
    }
}

