/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IAsteroidenDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.SonnensystemDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class AsteroidenDAO
implements IAsteroidenDAO {
    private final ILogging logging;
    private final IIdCacheDAO idCache;
    private final IObjektnamenRepository objektnamenRepository;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public AsteroidenDAO(IIdCacheDAO iIdCacheDAO, IObjektnamenRepository iObjektnamenRepository, IDatenbankverbinder iDatenbankverbinder) {
        this.idCache = iIdCacheDAO;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.objektnamenRepository = iObjektnamenRepository;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public double[][] getBahnabstandUndExzentrizitaet(double d) {
        try {
            QDaten qDaten = QDaten.daten;
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qDaten.exzentritaet}).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsAsteroiden()).and(qDaten.exzentritaet.gt(0.0).and(qDaten.entfernung.gt(0.0)).and(qDaten.entfernung.lt(d))))).fetch();
            double[][] dArray = new double[list.size()][2];
            int n = 0;
            for (Tuple tuple : list) {
                dArray[n][0] = tuple.get(qDaten.entfernung);
                dArray[n][1] = tuple.get(qDaten.exzentritaet);
                ++n;
            }
            return dArray;
        }
        catch (Exception exception) {
            this.logging.error("getBahnabstandUndExzentrizitaet(" + d + ")", exception);
            return new double[0][0];
        }
    }

    @Override
    public List<SonnensystemDTO> getAsteroidenZumStern(String string) {
        ArrayList<SonnensystemDTO> arrayList = new ArrayList<SonnensystemDTO>();
        try {
            QDaten qDaten = QDaten.daten;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.entfernung, qDaten.exzentritaet}).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsAsteroiden()).and(qDaten.entfernung.gt(0.0).and(qDaten.exzentritaet.gt(0.0))))).orderBy((OrderSpecifier<?>)qDaten.entfernung.asc())).fetch();
            for (Tuple tuple : list) {
                SonnensystemDTO sonnensystemDTO = new SonnensystemDTO();
                sonnensystemDTO.setObjektname(this.objektnamenRepository.getNamenByDatenId(tuple.get(qDaten.id), ObjektnamenSortierung.ALPHABETISCH).get(0));
                sonnensystemDTO.setEntfernung(tuple.get(qDaten.entfernung));
                sonnensystemDTO.setExzentrizitaet(tuple.get(qDaten.exzentritaet));
                arrayList.add(sonnensystemDTO);
            }
        }
        catch (Exception exception) {
            this.logging.error("getAsteroidsByStar(" + string + ")", exception);
        }
        return arrayList;
    }
}

