/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IZwischentabellenRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.api.IDAOlowAllgemein;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IBrauneZwergeDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenEntdeckungsmethodeDAO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public final class BrauneZwergeDAO
implements IBrauneZwergeDAO {
    private final ILogging logger;
    private final IPlanetenEntdeckungsmethodeDAO planetenEntdeckungsmethodenDao;
    private final IDAOlowAllgemein daoLowAllgemein;
    private final IIdCacheDAO idCache;
    private final IZwischentabellenRepository zwischentabellenRepository;
    private final IDatenbankService datenbankService;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public BrauneZwergeDAO(IIdCacheDAO iIdCacheDAO, IDAOlowAllgemein iDAOlowAllgemein, IPlanetenEntdeckungsmethodeDAO iPlanetenEntdeckungsmethodeDAO, IZwischentabellenRepository iZwischentabellenRepository, IDatenbankService iDatenbankService, IDatenbankverbinder iDatenbankverbinder) {
        this.idCache = iIdCacheDAO;
        this.daoLowAllgemein = iDAOlowAllgemein;
        this.planetenEntdeckungsmethodenDao = iPlanetenEntdeckungsmethodeDAO;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.zwischentabellenRepository = iZwischentabellenRepository;
        this.datenbankService = iDatenbankService;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public boolean isBraunerZwerg(int n) {
        try {
            Integer n2 = this.getDatenbankService().getInt("SELECT objektid FROM daten WHERE id=" + n, "objektid");
            return this.idCache.getObjekttypenidsBraunezwerge().contains(n2);
        }
        catch (SQLException sQLException) {
            this.logger.error("isBraunerZwerg(" + n + ")", sQLException);
            return false;
        }
    }

    @Override
    public void getEntdeckerVonBraunenZwergen(List<String> list, List<Integer> list2) {
        try {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Integer n : this.idCache.getObjekttypenidsBraunezwerge()) {
                String string = "SELECT id FROM daten WHERE objektid=" + n + ";";
                arrayList.addAll(this.getDatenbankService().getListeMitInt(string, "id"));
            }
            this.zwischentabellenRepository.getEntdeckerFuerObjektIds(arrayList, list, list2);
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
        }
    }

    @Override
    public List<String> getAnzahlBrauneZwergeProEntdeckungsmethode() {
        return this.planetenEntdeckungsmethodenDao.getAnzahlObjekteProEntdeckungsmethode(this.idCache.getObjekttypenidsBraunezwerge());
    }

    @Override
    public List<ErgebnisXYDto> getMasseUndBahnabstand(double d) {
        try {
            return this.daoLowAllgemein.getDatenFuerSpalten(this.idCache.getObjekttypenidsBraunezwerge(), QDaten.daten.entfernung, QDaten.daten.masse, 0.001, 10.0, d, 100.0, false);
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return Collections.emptyList();
        }
    }

    private IDatenbankService getDatenbankService() {
        return this.datenbankService;
    }

    @Override
    public List<Pair<Double, Double>> getDistanceAndTemperatureWithoutHostStar() {
        QDaten qDaten = QDaten.daten;
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qDaten.temperatur}).from((Expression<?>)qDaten)).where(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Brauner Zwerg ohne Stern"))).and(qDaten.entfernung.gt(0.0)).and(qDaten.temperatur.gt(0.0)))).fetch();
        ArrayList<Pair<Double, Double>> arrayList = new ArrayList<Pair<Double, Double>>();
        for (Tuple tuple : list) {
            arrayList.add(Pair.of(tuple.get(qDaten.entfernung), tuple.get(qDaten.temperatur)));
        }
        return arrayList;
    }

    @Override
    public List<Pair<Double, Double>> getDistanceAndTemperatureWithHostStar() {
        QDaten qDaten = new QDaten("br_zwerg");
        QDaten qDaten2 = new QDaten("stern");
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten2.entfernung, qDaten.temperatur}).from((Expression<?>)qDaten)).innerJoin((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).where(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Brauner Zwerg"))).and(qDaten.zugehoerigkeit.isNotNull()).and(qDaten2.entfernung.gt(0.0)).and(qDaten.temperatur.gt(0.0)))).fetch();
        ArrayList<Pair<Double, Double>> arrayList = new ArrayList<Pair<Double, Double>>();
        for (Tuple tuple : list) {
            arrayList.add(Pair.of(tuple.get(qDaten2.entfernung), tuple.get(qDaten.temperatur)));
        }
        return arrayList;
    }
}

