/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IObjektalterRepository;
import de.planetensuche.datenbankkern.api.repos.IObjekttypenRepository;
import de.planetensuche.datenbankkern.impl.tabellenmanipulation.Tabellenstruktur;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QObjektalter;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IDurchschnittsSternDAO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class DurchschnittsSternDAO
extends Tabellenstruktur
implements IDurchschnittsSternDAO {
    private final ILogging logger;
    private final IIdCacheDAO idCache;
    private final IDatenbankService datenbankService;
    private final IObjekttypenRepository objekttypenRepository;
    private final IObjektalterRepository objektalterRepository;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public DurchschnittsSternDAO(IIdCacheDAO iIdCacheDAO, IDatenbankService iDatenbankService, IObjekttypenRepository iObjekttypenRepository, IObjektalterRepository iObjektalterRepository, IDatenbankverbinder iDatenbankverbinder) {
        this.idCache = iIdCacheDAO;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.datenbankService = iDatenbankService;
        this.objekttypenRepository = iObjekttypenRepository;
        this.objektalterRepository = iObjektalterRepository;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public double getDurchschnittssternMasse(boolean bl) {
        return this.getDurchschnittsstern(bl, "masse", 0.0);
    }

    @Override
    public double getDurchschnittssternMetal(boolean bl) {
        return this.getDurchschnittsstern(bl, "metallizitaet", -100.0);
    }

    @Override
    public double getDurchschnittssternBV(boolean bl) {
        return this.getDurchschnittsstern(bl, "bv", -100.0);
    }

    @Override
    public Double getDurchschnittssternAlter(boolean bl) {
        try {
            List<Integer> list = this.findeSternIdsMitPlaneten();
            if (Check.isEmpty(list)) {
                throw new IllegalArgumentException("keine Sterne mit Exoplaneten gefunden");
            }
            QObjektalter qObjektalter = QObjektalter.objektalter;
            QDaten qDaten = QDaten.daten;
            long l = System.currentTimeMillis();
            Double d = bl ? (Double)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjektalter.alter.avg()).from((Expression<?>)qObjektalter)).leftJoin((EntityPath)qDaten)).on((Predicate)qObjektalter.datenid.eq(qDaten.id))).where(qDaten.id.in((Collection<Integer>)list).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetchOne() : (Double)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjektalter.alter.avg()).from((Expression<?>)qObjektalter)).leftJoin((EntityPath)qDaten)).on((Predicate)qObjektalter.datenid.eq(qDaten.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.id.notIn((Collection<Integer>)list)))).fetchOne();
            this.logger.debug("query durchschnittsstern alter ben\u00f6tigte " + (System.currentTimeMillis() - l) + " ms; sterneMitPlaneten? " + bl);
            return d;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getDurchschnittssternAlter(" + bl + ")", runtimeException);
            throw runtimeException;
        }
    }

    private List<Integer> findeSternIdsMitPlaneten() {
        QDaten qDaten = QDaten.daten;
        long l = System.currentTimeMillis();
        List<Integer> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.zugehoerigkeit.isNotNull()).and(qDaten.entdeckungbestaetigt.isTrue()))).fetch();
        this.logger.debug("sterne mit exoplaneten ermitteln dauerte " + (System.currentTimeMillis() - l) + " ms");
        return list;
    }

    @Override
    public double getDurchschnittsstern(boolean bl, String string, double d) {
        try {
            List<Integer> list = this.idCache.getObjekttypenidsSterne();
            int n = 0;
            double d2 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                List<Object> list2 = new ArrayList();
                if (bl) {
                    if ("alter".equals(string)) {
                        List<Integer> list3 = this.getDatenbankService().getListeMitInt("SELECT id FROM daten WHERE objektid=" + String.valueOf(list.get(i)) + " AND id!=" + this.idCache.getDatenIdSonne() + " AND id IN (SELECT zugehoerigkeit FROM daten WHERE zugehoerigkeit>0);", "id");
                        for (int n2 : list3) {
                            var14_15 = this.objektalterRepository.read(n2);
                            if (var14_15 == null) continue;
                            list2.add(var14_15.getAlter());
                        }
                    } else {
                        list2 = this.getDatenbankService().getListeMitDouble("SELECT " + string + " FROM daten WHERE objektid=" + String.valueOf(list.get(i)) + " AND " + string + ">" + d + " AND id!=" + this.idCache.getDatenIdSonne() + " AND id IN (SELECT zugehoerigkeit FROM daten WHERE zugehoerigkeit>0);", string);
                    }
                } else if ("alter".equals(string)) {
                    List<Integer> list4 = this.getDatenbankService().getListeMitInt("SELECT id FROM daten WHERE objektid=" + String.valueOf(list.get(i)) + " AND id!=" + this.idCache.getDatenIdSonne() + " AND id NOT IN (SELECT zugehoerigkeit FROM daten WHERE zugehoerigkeit>0);", "id");
                    for (int n2 : list4) {
                        var14_15 = this.objektalterRepository.read(n2);
                        if (var14_15 == null) continue;
                        list2.add(var14_15.getAlter());
                    }
                } else {
                    list2 = this.getDatenbankService().getListeMitDouble("SELECT " + string + " FROM daten WHERE objektid=" + String.valueOf(list.get(i)) + " AND " + string + ">" + d + " AND id!=" + this.idCache.getDatenIdSonne() + " AND id NOT IN (SELECT zugehoerigkeit FROM daten WHERE zugehoerigkeit>0);", string);
                }
                n += list2.size();
                for (int j = 0; j < list2.size(); ++j) {
                    d2 += ((Double)list2.get(j)).doubleValue();
                }
            }
            if (n > 0) {
                return d2 / (double)n;
            }
            return 0.0;
        }
        catch (SQLException sQLException) {
            this.logger.error("getDurchschnittsstern(" + bl + "," + string + ")", sQLException);
            return 0.0;
        }
    }

    @Override
    public double getDurchschnittBV(String string) {
        try {
            return this.getDatenbankService().getDouble("SELECT AVG(bv) AS x FROM daten WHERE spektralklasse=(SELECT id FROM spektraltyp WHERE Typ='" + string + "' AND kid=(SELECT id FROM kategorie WHERE Name='" + ObjektKategorie.STERNE.getKategorienName() + "')) AND bv>-100.0;", "x");
        }
        catch (SQLException sQLException) {
            this.logger.error("getDurchschnittBV(" + string + ")", sQLException);
            return -100.0;
        }
    }

    @Override
    public double getDurchschnittsAlter(String string) {
        try {
            QDaten qDaten = QDaten.daten;
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            QKategorie qKategorie = QKategorie.kategorie;
            QObjektalter qObjektalter = QObjektalter.objektalter;
            Double d = (Double)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjektalter.alter.avg()).from((Expression<?>)qObjektalter)).leftJoin((EntityPath)qDaten)).on((Predicate)qObjektalter.datenid.eq(qDaten.id))).where(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(string).and(qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.STERNE.getKategorienName())))))))).fetchOne();
            return d == null ? 0.0 : d;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getDurchschnittsAlter(" + string + ")", runtimeException);
            return 0.0;
        }
    }

    @Override
    public double getDurchschnittAHFuerBVUndLK(double d, String string) {
        double d2 = -100.0;
        try {
            Integer n = this.getDatenbankService().getInt("SELECT COUNT(ah) AS c FROM daten WHERE ah>-100.0 AND bv>" + (d - 0.05) + " AND bv<" + (d + 0.05) + " AND lumin=(SELECT id FROM lumin WHERE typ='" + string + "');", "c");
            if (n == null || n < 2) {
                return d2;
            }
            d2 = this.getDatenbankService().getDouble("SELECT AVG(ah) AS a FROM daten WHERE ah>-100.0 AND bv>" + (d - 0.05) + " AND bv<" + (d + 0.05) + " AND lumin=(SELECT id FROM lumin WHERE typ='" + string + "');", "a");
            return d2;
        }
        catch (SQLException sQLException) {
            this.logger.error("getDurchschnittAHFuerBVUndLK(" + d + "," + string + ")", sQLException);
            return -100.0;
        }
    }

    private IDatenbankService getDatenbankService() {
        return this.datenbankService;
    }
}

