/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IZwischentabellenRepository;
import de.planetensuche.datenbankkern.api.tabellenspalten.Daten;
import de.planetensuche.datenbankkern.api.tabellenspalten.ITabellenspalten;
import de.planetensuche.datenbankkern.helfer.Konverter;
import de.planetensuche.datenbankkern.impl.tabellenmanipulation.Tabellenstruktur;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QObjektalter;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IGalaxienNebelDAO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class GalaxienNebelDAO
extends Tabellenstruktur
implements IGalaxienNebelDAO {
    private final ILogging logger;
    private final IIdCacheDAO idCache;
    private final IZwischentabellenRepository zwischentabellenRepository;
    private final IDatenbankService datenbankService;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public GalaxienNebelDAO(IIdCacheDAO iIdCacheDAO, IZwischentabellenRepository iZwischentabellenRepository, IDatenbankService iDatenbankService, IDatenbankverbinder iDatenbankverbinder) {
        this.idCache = iIdCacheDAO;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.zwischentabellenRepository = iZwischentabellenRepository;
        this.datenbankService = iDatenbankService;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public double[][] getEntfernungUndMasseGalaxienNebel() {
        try {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<ITabellenspalten> arrayList2 = new ArrayList<ITabellenspalten>(2);
            arrayList2.add(Daten.ENTFERNUNG);
            arrayList2.add(Daten.MASSE);
            String string = "SELECT entfernung, masse FROM daten WHERE objektid=(SELECT id FROM objekttypen WHERE typ='Galaxie') AND masse>0.0 AND entfernung>0.0;";
            List<Map<ITabellenspalten, Double>> list = this.getDatenbankService().getListeMitDouble(string, arrayList2);
            for (Map<ITabellenspalten, Double> map : list) {
                arrayList.add(map.get(Daten.ENTFERNUNG));
                arrayList.add(map.get(Daten.MASSE));
            }
            return Konverter.convertListToArray(arrayList);
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getBVundAHGalaxienNebel(boolean bl) {
        try {
            QDaten qDaten = QDaten.daten;
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            List list = bl ? ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.bv.avg().as(qDaten.bv), qDaten.ah.avg().as(qDaten.ah)}).from((Expression<?>)qDaten)).where(qDaten.zugehoerigkeit.in((SubQueryExpression)((SQLQuery)SQLExpressions.selectDistinct(qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Galaxie"))))).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.bv.gt(-100.0)).and(qDaten.ah.gt(-100.0)))).groupBy((Expression<?>)qDaten.zugehoerigkeit)).fetch() : ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.bv, qDaten.ah}).from((Expression<?>)qDaten)).where(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Galaxie"))).and(qDaten.bv.gt(-100.0)).and(qDaten.ah.gt(-100.0)))).fetch();
            double[][] dArray = new double[list.size()][2];
            int n = 0;
            for (Tuple tuple : list) {
                dArray[n][0] = tuple.get(qDaten.bv);
                dArray[n][1] = tuple.get(qDaten.ah);
                ++n;
            }
            return dArray;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getBVundAH(" + bl + ")", runtimeException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getMetalUndAlterGalaxienNebel(boolean bl) {
        try {
            QDaten qDaten = QDaten.daten;
            QObjektalter qObjektalter = QObjektalter.objektalter;
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            List list = bl ? ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.metallizitaet.avg().as(qDaten.metallizitaet), qObjektalter.alter.avg().as(qObjektalter.alter)}).from((Expression<?>)qDaten)).join((EntityPath)qObjektalter)).on((Predicate)qDaten.id.eq(qObjektalter.datenid))).where(qDaten.zugehoerigkeit.in((SubQueryExpression)((SQLQuery)SQLExpressions.selectDistinct(qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Galaxie"))))).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.metallizitaet.gt(-100.0)).and(qObjektalter.alter.gt(0.0)))).groupBy((Expression<?>)qDaten.zugehoerigkeit)).fetch() : ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.metallizitaet, qObjektalter.alter}).from((Expression<?>)qDaten)).join((EntityPath)qObjektalter)).on((Predicate)qDaten.id.eq(qObjektalter.datenid))).where(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Galaxie"))).and(qDaten.metallizitaet.gt(-100.0)))).fetch();
            double[][] dArray = new double[list.size()][2];
            int n = 0;
            for (Tuple tuple : list) {
                dArray[n][0] = tuple.get(qDaten.metallizitaet);
                dArray[n][1] = tuple.get(qObjektalter.alter);
                ++n;
            }
            return dArray;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getMetalUndAlterGalaxienNebel(" + bl + ")", runtimeException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getGalaxienFRH(String string) {
        try {
            String[] stringArray = new String[]{"rotverschiebung", "sh"};
            String string2 = "SELECT rotverschiebung, sh FROM daten WHERE galaxienform=(SELECT id FROM galaxienform WHERE form='" + string + "') AND rotverschiebung>-10.0 AND sh>-100.0;";
            List<Double> list = this.getDatenbankService().getListeMitDoubleOld(string2, stringArray);
            return Konverter.convertListToArray(list);
        }
        catch (SQLException sQLException) {
            this.logger.error("getGalaxienFRH(" + string + ")", sQLException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getGalaxienFEH(String string, double d) {
        try {
            String[] stringArray = new String[]{"entfernung", "sh"};
            String string2 = "SELECT entfernung, sh FROM daten WHERE galaxienform=(SELECT id FROM galaxienform WHERE form='" + string + "') AND entfernung>0.0 AND sh>-100.0 AND entfernung<" + d + ";";
            List<Double> list = this.getDatenbankService().getListeMitDoubleOld(string2, stringArray);
            return Konverter.convertListToArray(list);
        }
        catch (SQLException sQLException) {
            this.logger.error("getGalaxienFEH(" + string + "," + d + ")", sQLException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getEntfernungUndRotverschiebungGalaxienNebel(double d) {
        try {
            String[] stringArray = new String[]{"entfernung", "rotverschiebung"};
            List<Double> list = this.getDatenbankService().getListeMitDoubleOld("SELECT rotverschiebung, entfernung FROM daten WHERE rotverschiebung>-10.0 AND entfernung>0.0 AND entfernung<" + d + ";", stringArray);
            return Konverter.convertListToArray(list);
        }
        catch (SQLException sQLException) {
            this.logger.error("getEntfernungUndRotverschiebung(" + d + ")", sQLException);
            return new double[0][0];
        }
    }

    @Override
    public int getAnzahlNebelarten(String string) {
        try {
            int n = this.getDatenbankService().getInt("SELECT id FROM nebelform WHERE form='" + string + "';", "id");
            return this.getDatenbankService().getInt("SELECT COUNT(id) AS c FROM daten WHERE nebelform=" + n + ";", "c");
        }
        catch (SQLException sQLException) {
            this.logger.error("getAnzahlNebelarten(" + string + ")", sQLException);
            return 0;
        }
    }

    @Override
    public int getAnzahlGalaxienarten(String string) {
        try {
            int n = this.getDatenbankService().getInt("SELECT id FROM galaxienart WHERE art='" + string + "';", "id");
            return this.getDatenbankService().getInt("SELECT COUNT(id) AS c FROM daten WHERE galaxienart=" + n + ";", "c");
        }
        catch (SQLException sQLException) {
            this.logger.error("getAnzahlGalaxienarten(" + string + ")", sQLException);
            return 0;
        }
    }

    @Override
    public int getAnzahlGalaxienform(String string) {
        try {
            int n = this.getDatenbankService().getInt("SELECT id FROM galaxienform WHERE form='" + string + "';", "id");
            return this.getDatenbankService().getInt("SELECT COUNT(id) AS c FROM daten WHERE galaxienform=" + n + ";", "c");
        }
        catch (SQLException sQLException) {
            this.logger.error("getAnzahlGalaxienform(" + string + ")", sQLException);
            return 0;
        }
    }

    @Override
    public void getEntdeckerVonGalaxienNebeln(List<String> list, List<Integer> list2) {
        try {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int n : this.idCache.getObjekttypenidsGalaxienundnebel()) {
                String string = "SELECT id FROM daten WHERE objektid=" + n + ";";
                arrayList.addAll(this.getDatenbankService().getListeMitInt(string, "id"));
            }
            this.zwischentabellenRepository.getEntdeckerFuerObjektIds(arrayList, list, list2);
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
        }
    }

    @Override
    public double[][] getEntfernungUndRadialgeschwindigkeit(double d) {
        try {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            String[] stringArray = new String[]{"entfernung", "geschwindigkeit"};
            for (Integer n : this.idCache.getObjekttypenidsGalaxienundnebel()) {
                arrayList.addAll(this.getDatenbankService().getListeMitDoubleOld("SELECT geschwindigkeit, entfernung FROM daten WHERE objektid=" + n + " AND geschwindigkeit!=0.0 AND entfernung>1.0 AND entfernung<" + d + ";", stringArray));
            }
            return Konverter.convertListToArray(arrayList);
        }
        catch (SQLException sQLException) {
            this.logger.error("getRadialUndEntfernung(" + d + ")", sQLException);
            return new double[0][0];
        }
    }

    private IDatenbankService getDatenbankService() {
        return this.datenbankService;
    }
}

