/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IZwischentabellenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.impl.tabellenmanipulation.Tabellenstruktur;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IMondeDAO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class MondeDAO
extends Tabellenstruktur
implements IMondeDAO {
    private final ILogging logging;
    private final IIdCacheDAO idCache;
    private final IZwischentabellenRepository zwischentabellenRepository;
    private final IDatenbankService datenbankService;
    private final IObjektnamenRepository objektnamenRepository;

    @Inject
    public MondeDAO(IIdCacheDAO iIdCacheDAO, IZwischentabellenRepository iZwischentabellenRepository, IDatenbankService iDatenbankService, IObjektnamenRepository iObjektnamenRepository) {
        this.idCache = iIdCacheDAO;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.zwischentabellenRepository = iZwischentabellenRepository;
        this.datenbankService = iDatenbankService;
        this.objektnamenRepository = iObjektnamenRepository;
    }

    @Override
    public void getEntdeckerVonMonden(List<String> list, List<Integer> list2) {
        try {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Integer n : this.idCache.getObjekttypenidsMonde()) {
                String string = "SELECT id FROM daten WHERE objektid=" + n + ";";
                arrayList.addAll(this.getDatenbankService().getListeMitInt(string, "id"));
            }
            this.zwischentabellenRepository.getEntdeckerFuerObjektIds(arrayList, list, list2);
        }
        catch (SQLException sQLException) {
            this.logging.error(sQLException);
        }
    }

    @Override
    public List<String> getMoonsByPlanet(String string, double d) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            int n = this.objektnamenRepository.getIDFuerNamen(string, true);
            List<Integer> list = this.getDatenbankService().getListeMitInt("SELECT D.id FROM daten AS D WHERE D.Zugehoerigkeit=" + n + " AND D.entfernung>0.0 AND D.entfernung<=" + d + " AND D.exzentritaet>0.0 ORDER BY D.entfernung;", "id");
            for (Integer n2 : list) {
                arrayList.add(this.objektnamenRepository.getNamenByDatenId(n2, ObjektnamenSortierung.ALPHABETISCH).get(0));
            }
        }
        catch (SQLException sQLException) {
            this.logging.error("getMoonsByPlanet(" + string + "," + d + ")", sQLException);
        }
        return arrayList;
    }

    private IDatenbankService getDatenbankService() {
        return this.datenbankService;
    }
}

