/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datamodel.formeln.EarthSimilarityIndexExoplanetCalculator;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QGaiaStars;
import de.planetensuche.datenbankkern.querydsl5.QHabitableZone;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.api.IDAOlowAllgemein;
import de.planetensuche.simulationen.dbmodel.basis.CountDto;
import de.planetensuche.simulationen.dbmodel.basis.HabitableZoneUtil;
import de.planetensuche.simulationen.dbmodel.basis.ICountDAO;
import de.planetensuche.simulationen.dbmodel.basis.RockyPlanetUtil;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IBrauneZwergeDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.PlanetDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.TemperaturParameterDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.TemperaturResultDto;
import de.planetensuche.simulationen.diagramme.util.MedianCalculator;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public final class PlanetenDAO
implements IPlanetenDAO {
    private final QDaten qDaten = QDaten.daten;
    private final ILogging logger;
    private final IDAOlowAllgemein daoLowAllgemein;
    private final ISterneDAO sterneDAO;
    private final IBrauneZwergeDAO brauneZwergeDAO;
    private final IIdCacheDAO idCache;
    private final IDatenbankService datenbankService;
    private final IObjektnamenRepository objektnamenRepository;
    private final IDatenbankverbinder datenbankverbinder;
    private final ICountDAO countDao;

    @Inject
    public PlanetenDAO(IIdCacheDAO iIdCacheDAO, IDAOlowAllgemein iDAOlowAllgemein, ISterneDAO iSterneDAO, IBrauneZwergeDAO iBrauneZwergeDAO, IDatenbankService iDatenbankService, IObjektnamenRepository iObjektnamenRepository, IDatenbankverbinder iDatenbankverbinder, ICountDAO iCountDAO) {
        this.idCache = iIdCacheDAO;
        this.daoLowAllgemein = iDAOlowAllgemein;
        this.sterneDAO = iSterneDAO;
        this.brauneZwergeDAO = iBrauneZwergeDAO;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.datenbankService = iDatenbankService;
        this.objektnamenRepository = iObjektnamenRepository;
        this.datenbankverbinder = iDatenbankverbinder;
        this.countDao = iCountDAO;
        if (this.logger.isDebugEnabled()) {
            List<Double> list;
            List<Double> list2 = this.getPlanetPeriods();
            if (!list2.isEmpty()) {
                double d = MedianCalculator.calculateMedian(list2);
                this.logger.debug("median confirmed exoplanet period in days: " + d);
            }
            if (!(list = this.getPlanetRadius()).isEmpty()) {
                double d = MedianCalculator.calculateMedian(list);
                this.logger.debug("median confirmed exoplanet radius in Rjup: " + d);
            }
        }
    }

    @Override
    public List<Double> getPlanetRadius() {
        try {
            return ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.durchmesser).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.durchmesser.gt(0.0)).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).orderBy((OrderSpecifier<?>)this.qDaten.durchmesser.asc())).fetch();
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return List.of();
        }
    }

    @Override
    public List<Double> getPlanetPeriods() {
        try {
            return ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.umlaufszeit).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.umlaufszeit.gt(0.0)).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).orderBy((OrderSpecifier<?>)this.qDaten.umlaufszeit.asc())).fetch();
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return List.of();
        }
    }

    @Override
    public CountDto getMasseJupiteraehnlicherPlaneten(double d, double d2) throws SQLException {
        return this.countDao.countObjects(ObjektKategorie.PLANETEN, this.qDaten.masse, 0.0, d2, d);
    }

    @Override
    public CountDto getExzentritaetJupiteraehnlicherPlaneten(double d, double d2) throws SQLException {
        return this.countDao.countObjects(ObjektKategorie.PLANETEN, this.qDaten.exzentritaet, 0.0, d2, d);
    }

    @Override
    public CountDto getAEJupiteraehnlicherPlaneten(double d, double d2) throws SQLException {
        return this.countDao.countObjects(ObjektKategorie.PLANETEN, this.qDaten.entfernung, 0.0, d2, d);
    }

    @Override
    @Deprecated
    public double[][] getSonnenmasseUndPlanetenmassen(int n) {
        try {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            if (n == 3) {
                hashSet.add(this.idCache.getDatenIdSonne());
            } else {
                hashSet.addAll(((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)this.qDaten.zugehoerigkeit).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).fetch());
            }
            for (Integer n2 : hashSet) {
                if (!(n == 2 && this.sterneDAO.isStern(n2) || n == 1 && this.brauneZwergeDAO.isBraunerZwerg(n2)) && n != 3) continue;
                double d = (Double)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.masse).from((Expression<?>)this.qDaten)).where(this.qDaten.id.eq(n2))).fetchOne();
                double d2 = (Double)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.masse.sum()).from((Expression<?>)this.qDaten)).where(this.qDaten.zugehoerigkeit.eq(n2).and(this.qDaten.entdeckungbestaetigt.isTrue()))).fetchOne();
                if (!(d > 0.0) || !(d2 > 0.0)) continue;
                if (this.brauneZwergeDAO.isBraunerZwerg(n2)) {
                    d /= 1048.45;
                }
                arrayList.add(d);
                arrayList.add(d2);
            }
            Object object = new double[arrayList.size() / 2][2];
            int n3 = 0;
            for (int i = 0; i < arrayList.size() - 1; i += 2) {
                object[n3][0] = (Double)arrayList.get(i);
                object[n3][1] = (Double)arrayList.get(i + 1);
                ++n3;
            }
            return object;
        }
        catch (Exception exception) {
            this.logger.error(exception);
            return new double[0][0];
        }
    }

    @Override
    public List<ErgebnisXYDto> getExzentritaetUndBahnabstand(double d, boolean bl) {
        try {
            return this.daoLowAllgemein.getDatenFuerSpalten(this.idCache.getObjekttypenidsPlaneten(), QDaten.daten.entfernung, QDaten.daten.exzentritaet, 0.0, d, 0.0, 2.0, bl);
        }
        catch (Exception exception) {
            this.logger.error("getExzentritaetUndBahnabstand(" + bl + ")", exception);
            return Collections.emptyList();
        }
    }

    @Override
    public double[][] getBahnabstandUndAbsoluteHelligkeit(double d) {
        try {
            QDaten qDaten = new QDaten("planeten");
            QDaten qDaten2 = new QDaten("sterne");
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten2.ah, qDaten.entfernung}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.entfernung.gt(0.0).and(qDaten.entfernung.lt(d))).and(qDaten2.id.ne(this.idCache.getDatenIdSonne())).and(qDaten2.ah.gt(-100.0)))).fetch();
            double[][] dArray = new double[list.size()][2];
            int n = 0;
            for (Tuple tuple : list) {
                dArray[n][0] = tuple.get(qDaten.entfernung);
                dArray[n][1] = tuple.get(qDaten2.ah);
                ++n;
            }
            return dArray;
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getBahnabstandUndMetalNurExoplaneten() {
        try {
            QDaten qDaten = new QDaten("planeten");
            QDaten qDaten2 = new QDaten("sterne");
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten2.metallizitaet, qDaten.entfernung}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.entfernung.gt(0.0)).and(qDaten2.id.ne(this.idCache.getDatenIdSonne())).and(qDaten2.metallizitaet.gt(-100.0)))).fetch();
            double[][] dArray = new double[list.size()][2];
            int n = 0;
            for (Tuple tuple : list) {
                dArray[n][0] = tuple.get(qDaten.entfernung);
                dArray[n][1] = tuple.get(qDaten2.metallizitaet);
                ++n;
            }
            return dArray;
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getMetallizitaetUndMasse(boolean bl) {
        try {
            QDaten qDaten = new QDaten("planeten");
            QDaten qDaten2 = new QDaten("sterne");
            List list = bl ? ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten2.metallizitaet, qDaten.masse}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten2.id.eq(this.idCache.getDatenIdSonne())))).fetch() : ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten2.metallizitaet, qDaten.masse}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.masse.gt(0.0)).and(qDaten2.id.ne(this.idCache.getDatenIdSonne())).and(qDaten2.metallizitaet.gt(-100.0)))).fetch();
            double[][] dArray = new double[list.size()][2];
            int n = 0;
            for (Tuple tuple : list) {
                dArray[n][0] = tuple.get(qDaten2.metallizitaet);
                dArray[n][1] = tuple.get(qDaten.masse);
                ++n;
            }
            return dArray;
        }
        catch (SQLException sQLException) {
            this.logger.error("getMasseUndMetallizitaet(" + bl + ")", sQLException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getEntfernungUndUmlaufszeit(double d, boolean bl) {
        try {
            List list = bl ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.entfernung, this.qDaten.umlaufszeit}).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.zugehoerigkeit.eq(this.idCache.getDatenIdSonne())).and(this.qDaten.umlaufszeit.gt(0.0)).and(this.qDaten.entfernung.between(1.0E-5, d)))).fetch() : ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.entfernung, this.qDaten.umlaufszeit}).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.umlaufszeit.gt(0.0)).and(this.qDaten.entfernung.between(1.0E-5, d)).and(this.qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).fetch();
            double[][] dArray = new double[list.size()][2];
            int n = 0;
            for (Tuple tuple : list) {
                dArray[n][0] = tuple.get(this.qDaten.entfernung);
                dArray[n][1] = tuple.get(this.qDaten.umlaufszeit) / 365.25;
                ++n;
            }
            return dArray;
        }
        catch (SQLException sQLException) {
            this.logger.error("getEntfernungUndUmlaufszeit(" + d + "," + bl + ")", sQLException);
            return new double[0][0];
        }
    }

    @Override
    public List<ErgebnisXYDto> getBahngeschwindigkeitUndBahnabstand(boolean bl, double d) {
        try {
            return this.daoLowAllgemein.getDatenFuerSpalten(this.idCache.getObjekttypenidsPlaneten(), QDaten.daten.entfernung, QDaten.daten.geschwindigkeit, 0.0, d, 0.0, 1000.0, bl);
        }
        catch (Exception exception) {
            this.logger.error("getBahngeschwindigkeitUndBahnabstand(" + bl + "," + d + ")", exception);
            return Collections.emptyList();
        }
    }

    @Override
    public int getAnzahlPlaneten(double d) {
        QDaten qDaten = new QDaten("planeten");
        QDaten qDaten2 = new QDaten("sterne");
        return (int)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten2.entfernung.between(1.0, d)))).fetchCount();
    }

    @Override
    public CountDto getJupiteraehnlichePlaneten2(double d, double d2, double d3, double d4, double d5, double d6) {
        CountDto countDto = new CountDto();
        try {
            countDto.setCountObjectsNoValues(((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.id).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.masse.eq(0.0).or(this.qDaten.entfernung.eq(0.0).or(this.qDaten.exzentritaet.eq(0.0)))))).fetchCount());
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.id).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.masse.between(d, d2)).and(this.qDaten.entfernung.between(d3, d4)).and(this.qDaten.exzentritaet.between(d5, d6)).and(this.qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).fetch();
            countDto.setCountObjectsEquals(list.size());
            countDto.setDatenIdsObjectsEquals(new HashSet<Integer>(list));
            countDto.setCountObjectsNonEquals((long)(this.getAnzahlBestatigeExoplaneten() - list.size()) - countDto.getCountObjectsNoValues());
            return countDto;
        }
        catch (SQLException sQLException) {
            this.logger.error("getJupiteraehnlichePlaneten2(" + d + "," + d2 + "," + d3 + "," + d4 + "," + d5 + "," + d6 + ")", sQLException);
            return countDto;
        }
    }

    private int getAnzahlBestatigeExoplaneten() throws SQLException {
        return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.id).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).fetchCount();
    }

    @Override
    public List<String> getPlanetsWithMoons() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)this.qDaten.zugehoerigkeit).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsMonde()))).fetch();
            for (Integer n : list) {
                String string = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.BEKANNTHEIT).get(0);
                arrayList.add(string);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return arrayList;
    }

    @Override
    public List<TemperaturResultDto> getOberflaechentemperaturUndBahnabstand(TemperaturParameterDto temperaturParameterDto) {
        ArrayList<TemperaturResultDto> arrayList = new ArrayList<TemperaturResultDto>();
        try {
            List<Integer> list = this.datenbankService.getObjekttypenidsPlaneten();
            BooleanExpression booleanExpression = this.qDaten.objektid.in((Collection<Integer>)list).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne()));
            if (temperaturParameterDto.isNurErdaehnliche()) {
                booleanExpression = booleanExpression.and(this.qDaten.temperatur.goe(273.0)).and(this.qDaten.temperatur.loe(308.0));
            } else {
                if (temperaturParameterDto.getMaxBahnabstandAE() != null) {
                    booleanExpression = booleanExpression.and(this.qDaten.entfernung.loe(temperaturParameterDto.getMaxBahnabstandAE()));
                }
                booleanExpression = temperaturParameterDto.getMinBahnabstandAE() != null ? booleanExpression.and(this.qDaten.entfernung.goe(temperaturParameterDto.getMinBahnabstandAE())) : booleanExpression.and(this.qDaten.entfernung.goe(0.0));
                if (temperaturParameterDto.getMaxTemperatur() != null) {
                    booleanExpression = booleanExpression.and(this.qDaten.temperatur.loe(temperaturParameterDto.getMaxTemperatur()));
                }
                booleanExpression = temperaturParameterDto.getMinTemperatur() != null ? booleanExpression.and(this.qDaten.temperatur.goe(temperaturParameterDto.getMinTemperatur())) : booleanExpression.and(this.qDaten.temperatur.goe(0.0));
            }
            SQLQuery sQLQuery = (SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.id, this.qDaten.entfernung, this.qDaten.temperatur}).from((Expression<?>)this.qDaten)).where(booleanExpression);
            List list2 = sQLQuery.fetch();
            for (Tuple tuple : list2) {
                Integer n = tuple.get(0, Integer.class);
                Double d = tuple.get(1, Double.class);
                Double d2 = tuple.get(2, Double.class);
                if (n == null) continue;
                String string = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.BEKANNTHEIT).get(0);
                TemperaturResultDto temperaturResultDto = new TemperaturResultDto();
                temperaturResultDto.setBahnabstandAE(d);
                temperaturResultDto.setPlanetName(string);
                temperaturResultDto.setTemperatur(d2);
                arrayList.add(temperaturResultDto);
            }
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error(exception);
        }
        return arrayList;
    }

    @Override
    public List<PlanetensucheObjekt> getSupererden() {
        try {
            double d = 0.0034540000000000005;
            double d2 = 0.0314;
            double d3 = 0.1115;
            double d4 = 0.1784;
            List list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qDaten).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.masse.between(d, d2)).and(this.qDaten.durchmesser.between(d3, d4)).and(this.qDaten.entdeckungbestaetigt.isTrue()))).fetch();
            ArrayList<PlanetensucheObjekt> arrayList = new ArrayList<PlanetensucheObjekt>();
            for (Daten daten : list) {
                PlanetensucheObjekt planetensucheObjekt = new PlanetensucheObjekt();
                planetensucheObjekt.setCategory(ObjektKategorie.PLANETEN);
                planetensucheObjekt.setDatenid(daten.getId());
                planetensucheObjekt.setMasse(daten.getMasse());
                planetensucheObjekt.setDurchmesser(daten.getDurchmesser());
                arrayList.add(planetensucheObjekt);
            }
            return arrayList;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getSupererden()", runtimeException);
            return new ArrayList<PlanetensucheObjekt>();
        }
    }

    @Override
    public List<PlanetensucheObjekt> getSupererdenInGruenerZone(double d) {
        try {
            ArrayList<PlanetensucheObjekt> arrayList = new ArrayList<PlanetensucheObjekt>();
            double d2 = 0.0034540000000000005;
            double d3 = d * 0.00314;
            double d4 = 0.1115;
            double d5 = 0.1784;
            QHabitableZone qHabitableZone = QHabitableZone.habitableZone;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.zugehoerigkeit).distinct()).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.masse.between(d2, d3).or(this.qDaten.durchmesser.between(d4, d5).and(this.qDaten.masse.lt(d3)))).and(this.qDaten.zugehoerigkeit.isNotNull()).and(this.qDaten.entdeckungbestaetigt.isTrue()))).fetch();
            for (Integer n : list) {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.temperatur, qHabitableZone.innerHz, qHabitableZone.outerHz}).from((Expression<?>)qHabitableZone)).innerJoin((EntityPath)this.qDaten)).on((Predicate)qHabitableZone.datenid.eq(this.qDaten.id))).where(qHabitableZone.datenid.eq(n))).fetchOne();
                if (tuple == null) continue;
                Double d6 = tuple.get(this.qDaten.temperatur);
                Double d7 = tuple.get(qHabitableZone.innerHz);
                Double d8 = tuple.get(qHabitableZone.outerHz);
                if (d7 == null || d8 == null || d6 == null) continue;
                List list2 = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qDaten).where(this.qDaten.zugehoerigkeit.eq(n).and(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten())).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.masse.between(d2, d3).or(this.qDaten.durchmesser.between(d4, d5).and(this.qDaten.masse.lt(d3)))).and(this.qDaten.entfernung.gt(0.0)))).fetch();
                for (Daten daten : list2) {
                    double d9;
                    double d10 = daten.getEntfernung();
                    boolean bl = HabitableZoneUtil.isInHabitableZone(d10, d9 = daten.getExzentritaet().doubleValue(), d7, d8);
                    if (!bl) continue;
                    PlanetensucheObjekt planetensucheObjekt = new PlanetensucheObjekt();
                    planetensucheObjekt.setDatenid(daten.getId());
                    planetensucheObjekt.setEntfernung(daten.getEntfernung());
                    planetensucheObjekt.setUmlaufszeit(daten.getUmlaufszeit());
                    planetensucheObjekt.setTemperatur(d6);
                    if (daten.getEntfernung() == 0.0) {
                        double d11 = Math.pow(daten.getUmlaufszeit() / 365.25, 0.6666666666666666);
                        planetensucheObjekt.setEntfernung(d11);
                    }
                    if (daten.getMasse() > 0.0) {
                        planetensucheObjekt.setMasse(daten.getMasse() / 0.00314);
                    }
                    if (daten.getDurchmesser() > 0.0) {
                        planetensucheObjekt.setDurchmesser(daten.getDurchmesser() / 0.0892);
                    }
                    List<String> list3 = this.objektnamenRepository.getNamenByDatenId(daten.getId(), ObjektnamenSortierung.BEKANNTHEIT);
                    planetensucheObjekt.setObjektNamen(new HashSet<String>(list3));
                    arrayList.add(planetensucheObjekt);
                }
            }
            return arrayList;
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            this.logger.error("getSupererdenInGruenerZone(" + d + ")", nonUniqueResultException);
            return new ArrayList<PlanetensucheObjekt>();
        }
    }

    @Override
    public List<PlanetDto> getPlanetsInHabitableZone(double d, double d2) {
        try {
            ArrayList<PlanetDto> arrayList = new ArrayList<PlanetDto>();
            QHabitableZone qHabitableZone = QHabitableZone.habitableZone;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.zugehoerigkeit).distinct()).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.masse.between(1.0E-7, d).or(this.qDaten.durchmesser.between(1.0E-6, d2))).and(this.qDaten.zugehoerigkeit.isNotNull()).and(this.qDaten.entdeckungbestaetigt.isTrue()))).fetch();
            for (Integer n : list) {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.temperatur, qHabitableZone.innerHz, qHabitableZone.outerHz}).from((Expression<?>)qHabitableZone)).innerJoin((EntityPath)this.qDaten)).on((Predicate)qHabitableZone.datenid.eq(this.qDaten.id))).where(qHabitableZone.datenid.eq(n).and(this.qDaten.temperatur.gt(0.0)))).fetchOne();
                if (tuple == null) continue;
                Double d3 = tuple.get(this.qDaten.temperatur);
                Double d4 = tuple.get(qHabitableZone.innerHz);
                Double d5 = tuple.get(qHabitableZone.outerHz);
                if (d4 == null || d5 == null || d3 == null) continue;
                List list2 = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qDaten).where(this.qDaten.zugehoerigkeit.eq(n).and(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten())).and(this.qDaten.masse.between(1.0E-7, d).or(this.qDaten.durchmesser.between(1.0E-6, d2))).and(this.qDaten.entfernung.gt(0.0)).and(this.qDaten.exzentritaet.gt(-100.0)).and(this.qDaten.entdeckungbestaetigt.isTrue()))).fetch();
                for (Daten daten : list2) {
                    double d6;
                    double d7 = daten.getEntfernung();
                    boolean bl = HabitableZoneUtil.isInHabitableZone(d7, d6 = daten.getExzentritaet().doubleValue(), d4, d5);
                    if (!bl || !RockyPlanetUtil.isRockyPlanet(daten.getDurchmesser(), daten.getMasse())) continue;
                    PlanetDto planetDto = new PlanetDto();
                    planetDto.setPlanetDJup(daten.getDurchmesser());
                    planetDto.setPlanetMJup(daten.getMasse());
                    planetDto.setPlanetOrbitInDays(daten.getUmlaufszeit());
                    planetDto.setStarTemperature(d3);
                    List<String> list3 = this.objektnamenRepository.getNamenByDatenId(daten.getId(), ObjektnamenSortierung.BEKANNTHEIT);
                    planetDto.setPlanetNames(list3);
                    arrayList.add(planetDto);
                }
            }
            return arrayList;
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            this.logger.error("getPlanetsInHabitableZone(" + d + "," + d2 + ")", nonUniqueResultException);
            return new ArrayList<PlanetDto>();
        }
    }

    private IDatenbankService getDatenbankService() {
        return this.datenbankService;
    }

    @Override
    public int zaehleAnzahlSterneMitExoplaneten(int n) {
        try {
            return (int)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)this.qDaten.zugehoerigkeit).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).groupBy((Expression<?>)this.qDaten.zugehoerigkeit)).having(this.qDaten.zugehoerigkeit.count().eq(Long.valueOf(n)))).fetchCount();
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return 0;
        }
    }

    @Override
    public List<ErgebnisXYDto> getStarDistanceAndPlanetMass() {
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        try {
            Serializable serializable;
            Integer n;
            Object object;
            Object object22;
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.masse, this.qDaten.zugehoerigkeit}).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.masse.gt(0.0)).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.isNotNull()))).fetch();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            HashMap<Integer, ArrayList<Double>> hashMap = new HashMap<Integer, ArrayList<Double>>();
            for (Object object22 : list) {
                object = object22.get(this.qDaten.masse);
                n = object22.get(this.qDaten.zugehoerigkeit);
                hashSet.add(n);
                serializable = (ArrayList<Double>)hashMap.get(n);
                if (serializable == null) {
                    serializable = new ArrayList<Double>();
                }
                serializable.add(object);
                hashMap.put(n, (ArrayList<Double>)serializable);
            }
            List list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.id, this.qDaten.entfernung}).from((Expression<?>)this.qDaten)).where(this.qDaten.id.in((Collection<Integer>)hashSet).and(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(this.qDaten.entfernung.gt(0.0)))).fetch();
            object22 = list2.iterator();
            while (object22.hasNext()) {
                object = (Tuple)object22.next();
                n = object.get(this.qDaten.id);
                serializable = object.get(this.qDaten.entfernung);
                List list3 = (List)hashMap.get(n);
                if (list3 == null || serializable == null) continue;
                for (Double d : list3) {
                    arrayList.add(new ErgebnisXYDto((Double)serializable, d));
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getStarDistanceAndPlanetMass()", runtimeException);
        }
        return arrayList;
    }

    @Override
    public List<ErgebnisXYDto> getStarDistanceAndPlanetDiameter() {
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        try {
            Serializable serializable;
            Integer n;
            Object object;
            Object object22;
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.durchmesser, this.qDaten.zugehoerigkeit}).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.durchmesser.gt(0.0)).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.isNotNull()))).fetch();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            HashMap<Integer, ArrayList<Double>> hashMap = new HashMap<Integer, ArrayList<Double>>();
            for (Object object22 : list) {
                object = object22.get(this.qDaten.durchmesser);
                n = object22.get(this.qDaten.zugehoerigkeit);
                hashSet.add(n);
                serializable = (ArrayList<Double>)hashMap.get(n);
                if (serializable == null) {
                    serializable = new ArrayList<Double>();
                }
                serializable.add(object);
                hashMap.put(n, (ArrayList<Double>)serializable);
            }
            List list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.id, this.qDaten.entfernung}).from((Expression<?>)this.qDaten)).where(this.qDaten.id.in((Collection<Integer>)hashSet).and(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(this.qDaten.entfernung.gt(0.0)))).fetch();
            object22 = list2.iterator();
            while (object22.hasNext()) {
                object = (Tuple)object22.next();
                n = object.get(this.qDaten.id);
                serializable = object.get(this.qDaten.entfernung);
                List list3 = (List)hashMap.get(n);
                if (list3 == null || serializable == null) continue;
                for (Double d : list3) {
                    arrayList.add(new ErgebnisXYDto((Double)serializable, d));
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getStarDistanceAndPlanetDiameter()", runtimeException);
        }
        return arrayList;
    }

    @Override
    public List<ErgebnisXYDto> getStarsWithPlanetMassAndRvError(List<StarObjectType> list) {
        QDaten qDaten = new QDaten("stars");
        QDaten qDaten2 = new QDaten("planets");
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QGaiaStars qGaiaStars = QGaiaStars.gaiaStars;
        List<String> list2 = list.stream().map(starObjectType -> starObjectType.getTypeName()).toList();
        List list3 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten2.masse, qDaten.id, qGaiaStars.rvError}).from((Expression<?>)qDaten2)).join((EntityPath)qDaten)).on((Predicate)qDaten2.zugehoerigkeit.eq(qDaten.id))).join((EntityPath)qGaiaStars)).on((Predicate)qGaiaStars.datenid.eq(qDaten.id))).join((EntityPath)qObjekttypen)).on((Predicate)qDaten.objektid.eq(qObjekttypen.id))).where(qDaten2.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten2.entdeckungbestaetigt.isTrue()).and(qDaten2.masse.gt(0.0)).and(qObjekttypen.typ.in(list2)).and(qGaiaStars.rvError.isNotNull()))).fetch();
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        for (Tuple tuple : list3) {
            Double d = tuple.get(qGaiaStars.rvError);
            ErgebnisXYDto ergebnisXYDto = new ErgebnisXYDto(tuple.get(qDaten2.masse), d);
            arrayList.add(ergebnisXYDto);
        }
        return arrayList;
    }

    @Override
    public List<ErgebnisXYDto> getEsiAndDistanceInLy() {
        QDaten qDaten = new QDaten("stars");
        QDaten qDaten2 = new QDaten("planets");
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten2.id, qDaten2.durchmesser, qDaten2.entfernung, qDaten2.umlaufszeit, qDaten.entfernung, qDaten.ah, qDaten.temperatur, qDaten.durchmesser}).from((Expression<?>)qDaten2)).join((EntityPath)qDaten)).on((Predicate)qDaten2.zugehoerigkeit.eq(qDaten.id))).where(qDaten2.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten2.entdeckungbestaetigt.isTrue()).and(qDaten2.durchmesser.between(1.0E-4, 0.3)).and(qDaten2.umlaufszeit.gt(5.0)).and(qDaten2.entfernung.gt(0.0)).and(qDaten.ah.gt(-100.0)).and(qDaten.entfernung.gt(0.0)).and(qDaten.temperatur.gt(0.0)).and(qDaten.durchmesser.gt(0.0)))).fetch();
        this.logger.debug("found " + list.size() + " exoplanets for ESI calculation");
        EarthSimilarityIndexExoplanetCalculator earthSimilarityIndexExoplanetCalculator = new EarthSimilarityIndexExoplanetCalculator();
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        for (Tuple tuple : list) {
            Integer n = tuple.get(qDaten2.id);
            Double d = tuple.get(qDaten2.durchmesser);
            Double d2 = tuple.get(qDaten2.entfernung);
            Double d3 = tuple.get(qDaten2.umlaufszeit);
            Double d4 = tuple.get(qDaten.entfernung);
            Double d5 = tuple.get(qDaten.ah);
            Double d6 = tuple.get(qDaten.temperatur);
            Double d7 = tuple.get(qDaten.durchmesser);
            Optional<Double> optional = earthSimilarityIndexExoplanetCalculator.calcESI(d, d2, d3, d5, d6, d7);
            if (!optional.isPresent() || !(optional.get() > 0.75)) continue;
            ErgebnisXYDto ergebnisXYDto = new ErgebnisXYDto(d4, optional.get(), n);
            arrayList.add(ergebnisXYDto);
        }
        return arrayList;
    }
}

