/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.api.repos.IEntdeckerRepository;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.kategorien.api.EntdeckerResult;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IEntdeckerBasicDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenEntdeckerDAO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlanetenEntdeckerDAO
implements IPlanetenEntdeckerDAO {
    private final QDaten qDaten = QDaten.daten;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder datenbankverbinder;
    private final IEntdeckerRepository entdeckerRepository;
    private final IEntdeckerBasicDAO entdeckerBasicDAO;
    private final IIdCacheDAO idCache;

    @Inject
    public PlanetenEntdeckerDAO(IDatenbankverbinder iDatenbankverbinder, IEntdeckerRepository iEntdeckerRepository, IEntdeckerBasicDAO iEntdeckerBasicDAO, IIdCacheDAO iIdCacheDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.entdeckerRepository = iEntdeckerRepository;
        this.entdeckerBasicDAO = iEntdeckerBasicDAO;
        this.idCache = iIdCacheDAO;
    }

    @Override
    public List<EntdeckerResult> getEntdeckerVonPlaneten(int n) {
        try {
            QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
            QEntdecker qEntdecker = QEntdecker.entdecker;
            List<EntdeckerResult> list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)Projections.constructor(EntdeckerResult.class, qEntdecker, qZtentdecker.datenid.count())).from((Expression<?>)qEntdecker)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).leftJoin((EntityPath)this.qDaten)).on((Predicate)qZtentdecker.datenid.eq(this.qDaten.id))).where(this.qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(qEntdecker.typ.isNull().or(qEntdecker.typ.eq(EntdeckerTyp.PERSON.getType()))))).groupBy((Expression<?>)qEntdecker.id)).having(qZtentdecker.datenid.count().goe(n))).orderBy((OrderSpecifier<?>)qZtentdecker.datenid.count().desc())).fetch();
            return list;
        }
        catch (Exception exception) {
            this.logger.error("getEntdeckerMitPlaneten()", exception);
            return null;
        }
    }

    @Override
    public Map<String, Integer> getEntdeckerteamsUndAnzahlEntdeckungen() {
        Map<String, Integer> map = new HashMap<String, Integer>();
        try {
            List<Entdecker> list = this.entdeckerRepository.findAllDiscovererTeams();
            map = this.entdeckerBasicDAO.getEntdeckerUndAnzahl(list);
        }
        catch (Exception exception) {
            this.logger.error("Fehler beim Laden der Exoplaneten-Teams und Planetenanzahl", exception);
        }
        return map;
    }
}

