/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdeckungsmethode;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenEntdeckungsmethodeDAO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlanetenEntdeckungsmethodeDAO
implements IPlanetenEntdeckungsmethodeDAO {
    private final QDaten qDaten = QDaten.daten;
    private final QEntdeckungsmethode qEntdeckungsmethode = QEntdeckungsmethode.entdeckungsmethode;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCache;
    private final IEntdeckungsmethodenRepository entdeckungsmethodenRepository;
    private final IDatenbankService datenbankService;

    @Inject
    public PlanetenEntdeckungsmethodeDAO(IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO, IEntdeckungsmethodenRepository iEntdeckungsmethodenRepository, IDatenbankService iDatenbankService) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCache = iIdCacheDAO;
        this.entdeckungsmethodenRepository = iEntdeckungsmethodenRepository;
        this.datenbankService = iDatenbankService;
    }

    @Override
    public List<String> getAnzahlObjekteProEntdeckungsmethode(List<Integer> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            List<String> list2 = this.entdeckungsmethodenRepository.getEntdeckungsmethoden();
            int n = 0;
            for (String string : list2) {
                for (int n2 : list) {
                    long l = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.id).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)this.qEntdeckungsmethode)).on((Predicate)this.qDaten.entdeckungsmethode.eq(this.qEntdeckungsmethode.id))).where(this.qDaten.objektid.in((Collection<Integer>)list).and(this.qEntdeckungsmethode.methode.eq(string)).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).fetchCount();
                    n = (int)((long)n + l);
                }
                arrayList.add(n + ";" + string);
                n = 0;
            }
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
        }
        return arrayList;
    }

    @Override
    public List<String> getAnzahlPlanetenProEntdeckungsmethode() {
        try {
            return this.getAnzahlObjekteProEntdeckungsmethode(this.datenbankService.getObjekttypenidsPlaneten());
        }
        catch (Exception exception) {
            this.logger.error(exception);
            return new ArrayList<String>();
        }
    }

    @Override
    public List<ErgebnisXYDto> getMasseUndBahnabstand(double d, boolean bl, String string) {
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        try {
            if (bl) {
                List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.masse, this.qDaten.entfernung}).from((Expression<?>)this.qDaten)).where(this.qDaten.zugehoerigkeit.eq(this.idCache.getDatenIdSonne()).and(this.qDaten.entfernung.loe(d)))).fetch();
                for (Tuple tuple : list) {
                    Double d2 = tuple.get(0, Double.class);
                    Double d3 = tuple.get(1, Double.class);
                    arrayList.add(new ErgebnisXYDto(d3, d2));
                }
            } else {
                List<Integer> list = this.datenbankService.getObjekttypenidsPlaneten();
                SQLQuery sQLQuery = (SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.masse, this.qDaten.entfernung}).from((Expression<?>)this.qDaten)).leftJoin((ForeignKey)this.qDaten.entdeckungsmethodeFk, (RelationalPath)this.qEntdeckungsmethode)).where(this.qDaten.objektid.in((Collection<Integer>)list).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.entfernung.loe(d)).and(this.qEntdeckungsmethode.methode.eq(string)).and(this.qDaten.masse.gt(0.0)).and(this.qDaten.entfernung.gt(0.0)));
                List list2 = sQLQuery.fetch();
                for (Tuple tuple : list2) {
                    Double d4 = tuple.get(0, Double.class);
                    Double d5 = tuple.get(1, Double.class);
                    arrayList.add(new ErgebnisXYDto(d5, d4));
                }
            }
        }
        catch (Exception exception) {
            this.logger.error("getMasseUndBahnabstand(" + d + "," + bl + "," + string + ")", exception);
        }
        return arrayList;
    }

    @Override
    public List<ErgebnisXYDto> getScheinbareHelligkeitUndEntfernungSterneMitPlaneten(double d, String string) {
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        try {
            List<Integer> list = this.datenbankService.getObjekttypenidsPlaneten();
            List list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.entfernung, this.qDaten.sh}).from((Expression<?>)this.qDaten)).where(this.qDaten.id.in((SubQueryExpression)((SQLQuery)((SQLQuery)SQLExpressions.select(this.qDaten.zugehoerigkeit).from((Expression<?>)this.qDaten)).leftJoin((ForeignKey)this.qDaten.entdeckungsmethodeFk, (RelationalPath)this.qEntdeckungsmethode)).where(this.qDaten.objektid.in((Collection<Integer>)list).and(this.qEntdeckungsmethode.methode.eq(string)).and(this.qDaten.entdeckungbestaetigt.isTrue()))).and(this.qDaten.entfernung.loe(d)).and(this.qDaten.entfernung.gt(0.0)).and(this.qDaten.sh.gt(-5.0)))).fetch();
            for (Tuple tuple : list2) {
                Double d2 = tuple.get(0, Double.class);
                Double d3 = tuple.get(1, Double.class);
                arrayList.add(new ErgebnisXYDto(d2, d3));
            }
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error("getScheinbareHelligkeitUndEntfernungSterneMitPlaneten(" + d + "," + string + ")", exception);
        }
        return arrayList;
    }

    @Override
    public Map<String, Integer> getEntdeckungsmethodeInMehrfachsternsystemenUndProzentPlaneten() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        QDaten qDaten = new QDaten("planeten");
        try {
            ArrayList arrayList;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, this.qEntdeckungsmethode.methode, qDaten.zugehoerigkeit}).from((Expression<?>)qDaten)).join((EntityPath)this.qEntdeckungsmethode)).on((Predicate)qDaten.entdeckungsmethode.eq(this.qEntdeckungsmethode.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.zugehoerigkeit.isNotNull()))).fetch();
            HashMap hashMap2 = new HashMap();
            for (Object object : list) {
                Object object2 = object.get(qDaten.zugehoerigkeit);
                arrayList = (ArrayList)hashMap2.get(object2);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap2.put(object2, arrayList);
                }
                arrayList.add(object);
            }
            int n = 0;
            for (Object object2 : hashMap2.values()) {
                if (object2.size() <= 1) continue;
                n += object2.size();
                arrayList = object2.iterator();
                while (arrayList.hasNext()) {
                    Tuple tuple = (Tuple)arrayList.next();
                    String string = tuple.get(this.qEntdeckungsmethode.methode);
                    hashMap.merge(string, 1, Integer::sum);
                }
            }
            if (n > 0) {
                for (Object object2 : hashMap.keySet()) {
                    hashMap.put((String)object2, (int)Math.round((double)((Integer)hashMap.get(object2)).intValue() * 100.0 / (double)n));
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return hashMap;
    }

    @Override
    public Map<String, Integer> getEntdeckungsmethodeUndProzentPlaneten() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        QDaten qDaten = new QDaten("planeten");
        try {
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, this.qEntdeckungsmethode.methode}).from((Expression<?>)qDaten)).join((EntityPath)this.qEntdeckungsmethode)).on((Predicate)qDaten.entdeckungsmethode.eq(this.qEntdeckungsmethode.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()))).fetch();
            int n = list.size();
            for (Object object : list) {
                String string = object.get(this.qEntdeckungsmethode.methode);
                hashMap.merge(string, 1, Integer::sum);
            }
            for (Object object : hashMap.keySet()) {
                hashMap.put((String)object, (int)Math.round((double)((Integer)hashMap.get(object)).intValue() * 100.0 / (double)n));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return hashMap;
    }

    @Override
    public Map<String, Integer> getEntdeckungsmethodeUndProzentEntferntestePlaneten() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        QDaten qDaten = new QDaten("sterne");
        QDaten qDaten2 = new QDaten("planeten");
        try {
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten2.id, this.qEntdeckungsmethode.methode}).from((Expression<?>)qDaten2)).join((EntityPath)qDaten)).on((Predicate)qDaten2.zugehoerigkeit.eq(qDaten.id))).join((EntityPath)this.qEntdeckungsmethode)).on((Predicate)qDaten2.entdeckungsmethode.eq(this.qEntdeckungsmethode.id))).where(qDaten2.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten2.entdeckungbestaetigt.isTrue()).and(qDaten.entfernung.goe(5000.0)))).fetch();
            int n = list.size();
            for (Object object : list) {
                String string = object.get(this.qEntdeckungsmethode.methode);
                hashMap.merge(string, 1, Integer::sum);
            }
            for (Object object : hashMap.keySet()) {
                hashMap.put((String)object, (int)Math.round((double)((Integer)hashMap.get(object)).intValue() * 100.0 / (double)n));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return hashMap;
    }

    @Override
    public Map<String, Integer> getEntdeckungsmethodeUndProzentKleinePlaneten() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        QDaten qDaten = new QDaten("planeten");
        try {
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, this.qEntdeckungsmethode.methode}).from((Expression<?>)qDaten)).join((EntityPath)this.qEntdeckungsmethode)).on((Predicate)qDaten.entdeckungsmethode.eq(this.qEntdeckungsmethode.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.masse.between(1.0E-7, 0.00628).or(qDaten.durchmesser.between(1.0E-7, 0.1784))))).fetch();
            int n = list.size();
            for (Object object : list) {
                String string = object.get(this.qEntdeckungsmethode.methode);
                hashMap.merge(string, 1, Integer::sum);
            }
            for (Object object : hashMap.keySet()) {
                hashMap.put((String)object, (int)Math.round((double)((Integer)hashMap.get(object)).intValue() * 100.0 / (double)n));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return hashMap;
    }

    @Override
    public Map<String, Integer> getEntdeckungsmethodeUndProzentLanglaufendePlaneten() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        QDaten qDaten = new QDaten("planeten");
        try {
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, this.qEntdeckungsmethode.methode}).from((Expression<?>)qDaten)).join((EntityPath)this.qEntdeckungsmethode)).on((Predicate)qDaten.entdeckungsmethode.eq(this.qEntdeckungsmethode.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.umlaufszeit.goe(365.0)))).fetch();
            int n = list.size();
            for (Object object : list) {
                String string = object.get(this.qEntdeckungsmethode.methode);
                hashMap.merge(string, 1, Integer::sum);
            }
            for (Object object : hashMap.keySet()) {
                hashMap.put((String)object, (int)Math.round((double)((Integer)hashMap.get(object)).intValue() * 100.0 / (double)n));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return hashMap;
    }

    @Override
    public Map<String, List<ErgebnisXYDto>> findPlanetRadiusAndPeriodByDiscoveryMethods() {
        HashMap<String, List<ErgebnisXYDto>> hashMap = new HashMap<String, List<ErgebnisXYDto>>();
        QDaten qDaten = new QDaten("planeten");
        try {
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qDaten.umlaufszeit, this.qEntdeckungsmethode.methode}).from((Expression<?>)qDaten)).join((EntityPath)this.qEntdeckungsmethode)).on((Predicate)this.qEntdeckungsmethode.id.eq(qDaten.entdeckungsmethode))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.durchmesser.gt(0.0).and(qDaten.durchmesser.lt(2.0))).and(qDaten.umlaufszeit.gt(0.0).and(qDaten.umlaufszeit.lt(1500.0))))).fetch();
            for (Tuple tuple : list) {
                String string = tuple.get(this.qEntdeckungsmethode.methode);
                ArrayList<ErgebnisXYDto> arrayList = (ArrayList<ErgebnisXYDto>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<ErgebnisXYDto>();
                    hashMap.put(string, arrayList);
                }
                double d = tuple.get(qDaten.durchmesser) * 11.194418312950768;
                arrayList.add(new ErgebnisXYDto(tuple.get(qDaten.umlaufszeit), d));
            }
        }
        catch (Exception exception) {
            this.logger.error(exception);
        }
        return hashMap;
    }

    @Override
    public Map<String, List<ErgebnisXYDto>> findPlanetRadiusAndMassByDiscoveryMethods() {
        HashMap<String, List<ErgebnisXYDto>> hashMap = new HashMap<String, List<ErgebnisXYDto>>();
        QDaten qDaten = new QDaten("planeten");
        try {
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qDaten.masse, this.qEntdeckungsmethode.methode}).from((Expression<?>)qDaten)).join((EntityPath)this.qEntdeckungsmethode)).on((Predicate)this.qEntdeckungsmethode.id.eq(qDaten.entdeckungsmethode))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.durchmesser.gt(0.0)).and(qDaten.masse.gt(0.0)))).fetch();
            for (Tuple tuple : list) {
                String string = tuple.get(this.qEntdeckungsmethode.methode);
                ArrayList<ErgebnisXYDto> arrayList = (ArrayList<ErgebnisXYDto>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<ErgebnisXYDto>();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(new ErgebnisXYDto(tuple.get(qDaten.masse), tuple.get(qDaten.durchmesser)));
            }
        }
        catch (Exception exception) {
            this.logger.error(exception);
        }
        return hashMap;
    }
}

