/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenPhtDAO;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PlanetenPhtDAO
implements IPlanetenPhtDAO {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IIdCacheDAO idCache;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public PlanetenPhtDAO(IIdCacheDAO iIdCacheDAO, IDatenbankverbinder iDatenbankverbinder) {
        this.idCache = iIdCacheDAO;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public Map<String, List<ErgebnisXYDto>> findPlanetRadiusByPhtCandidates() {
        HashMap<String, List<ErgebnisXYDto>> hashMap = new HashMap<String, List<ErgebnisXYDto>>();
        QDaten qDaten = new QDaten("planeten");
        QDaten qDaten2 = new QDaten("sterne");
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        try {
            Object object;
            Object object22;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.durchmesser, qDaten2.temperatur}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isFalse()).and(qEntdecker.nachname.eq("G\u00fchne")).and(qDaten.durchmesser.gt(0.0).and(qDaten.durchmesser.lt(2.0))).and(qDaten2.temperatur.gt(0.0)))).fetch();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<ErgebnisXYDto> arrayList2 = new ArrayList<ErgebnisXYDto>();
            for (Object object22 : list) {
                double d = object22.get(qDaten.durchmesser) * 11.194418312950768;
                arrayList2.add(new ErgebnisXYDto(object22.get(qDaten2.temperatur), d));
                arrayList.add(object22.get(qDaten.id));
            }
            hashMap.put(SprachcontainerFabrik.getSprachcontainer().getString("sim_gui187"), arrayList2);
            ArrayList arrayList3 = new ArrayList(arrayList);
            object22 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.durchmesser, qDaten2.temperatur}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isFalse()).and(qDaten.id.notIn((Collection<Integer>)arrayList)).and(qEntdecker.nachname.eq(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase())).and(qDaten.durchmesser.gt(0.0).and(qDaten.durchmesser.lt(2.0))).and(qDaten2.temperatur.gt(0.0)))).fetch();
            ArrayList<ErgebnisXYDto> arrayList4 = new ArrayList<ErgebnisXYDto>();
            Object object3 = object22.iterator();
            while (object3.hasNext()) {
                object = (Tuple)object3.next();
                double d = object.get(qDaten.durchmesser) * 11.194418312950768;
                arrayList4.add(new ErgebnisXYDto(object.get(qDaten2.temperatur), d));
                arrayList3.add(object.get(qDaten.id));
            }
            hashMap.put(SprachcontainerFabrik.getSprachcontainer().getString("sim_gui188"), arrayList4);
            object3 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qDaten2.temperatur}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isFalse()).and(qEntdecker.nachname.eq(EntdeckerWeltraumteleskope.TESS.getNameInDatabase())).and(qDaten.id.notIn(arrayList3)).and(qDaten.durchmesser.gt(0.0).and(qDaten.durchmesser.lt(2.0))).and(qDaten2.temperatur.gt(0.0)))).fetch();
            object = new ArrayList();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                Tuple tuple = (Tuple)iterator.next();
                double d = tuple.get(qDaten.durchmesser) * 11.194418312950768;
                object.add(new ErgebnisXYDto(tuple.get(qDaten2.temperatur), d));
            }
            hashMap.put(SprachcontainerFabrik.getSprachcontainer().getString("sim_gui191"), (List<ErgebnisXYDto>)object);
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return hashMap;
    }

    @Override
    public Map<String, List<ErgebnisXYDto>> findPlanetRadiusAndPeriodForPht() {
        HashMap<String, List<ErgebnisXYDto>> hashMap = new HashMap<String, List<ErgebnisXYDto>>();
        QDaten qDaten = new QDaten("planeten");
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        try {
            Object object;
            Object object22;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.durchmesser, qDaten.umlaufszeit}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isFalse()).and(qEntdecker.nachname.eq("G\u00fchne")).and(qDaten.durchmesser.gt(0.0).and(qDaten.durchmesser.lt(2.0))).and(qDaten.umlaufszeit.gt(0.0)))).fetch();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<ErgebnisXYDto> arrayList2 = new ArrayList<ErgebnisXYDto>();
            for (Object object22 : list) {
                double d = object22.get(qDaten.durchmesser) * 11.194418312950768;
                arrayList2.add(new ErgebnisXYDto(object22.get(qDaten.umlaufszeit), d));
                arrayList.add(object22.get(qDaten.id));
            }
            hashMap.put(SprachcontainerFabrik.getSprachcontainer().getString("sim_gui187"), arrayList2);
            ArrayList arrayList3 = new ArrayList(arrayList);
            object22 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.durchmesser, qDaten.umlaufszeit}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isFalse()).and(qDaten.id.notIn((Collection<Integer>)arrayList)).and(qEntdecker.nachname.eq(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase())).and(qDaten.durchmesser.gt(0.0).and(qDaten.durchmesser.lt(2.0))).and(qDaten.umlaufszeit.gt(0.0)))).fetch();
            ArrayList<ErgebnisXYDto> arrayList4 = new ArrayList<ErgebnisXYDto>();
            Object object3 = object22.iterator();
            while (object3.hasNext()) {
                object = (Tuple)object3.next();
                double d = object.get(qDaten.durchmesser) * 11.194418312950768;
                arrayList4.add(new ErgebnisXYDto(object.get(qDaten.umlaufszeit), d));
                arrayList3.add(object.get(qDaten.id));
            }
            hashMap.put(SprachcontainerFabrik.getSprachcontainer().getString("sim_gui188"), arrayList4);
            object3 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.durchmesser, qDaten.umlaufszeit}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isFalse()).and(qEntdecker.nachname.eq(EntdeckerWeltraumteleskope.TESS.getNameInDatabase())).and(qDaten.id.notIn(arrayList3)).and(qDaten.durchmesser.gt(0.0).and(qDaten.durchmesser.lt(2.0))).and(qDaten.umlaufszeit.gt(0.0)))).fetch();
            object = new ArrayList();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                Tuple tuple = (Tuple)iterator.next();
                double d = tuple.get(qDaten.durchmesser) * 11.194418312950768;
                object.add(new ErgebnisXYDto(tuple.get(qDaten.umlaufszeit), d));
            }
            hashMap.put(SprachcontainerFabrik.getSprachcontainer().getString("sim_gui191"), (List<ErgebnisXYDto>)object);
        }
        catch (Exception exception) {
            this.logger.error(exception);
        }
        return hashMap;
    }

    @Override
    public Map<String, List<ErgebnisXYDto>> findPlanetRadiusTemperatureForPht() {
        HashMap<String, List<ErgebnisXYDto>> hashMap = new HashMap<String, List<ErgebnisXYDto>>();
        QDaten qDaten = new QDaten("planeten");
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        try {
            Object object;
            Object object22;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.durchmesser, qDaten.temperatur}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isFalse()).and(qEntdecker.nachname.eq("G\u00fchne")).and(qDaten.durchmesser.gt(0.0).and(qDaten.durchmesser.lt(2.0))).and(qDaten.temperatur.gt(-273.0)))).fetch();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<ErgebnisXYDto> arrayList2 = new ArrayList<ErgebnisXYDto>();
            for (Object object22 : list) {
                double d = object22.get(qDaten.durchmesser) * 11.194418312950768;
                arrayList2.add(new ErgebnisXYDto(object22.get(qDaten.temperatur) - 273.15, d));
                arrayList.add(object22.get(qDaten.id));
            }
            hashMap.put(SprachcontainerFabrik.getSprachcontainer().getString("sim_gui187"), arrayList2);
            ArrayList arrayList3 = new ArrayList(arrayList);
            object22 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.durchmesser, qDaten.temperatur}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isFalse()).and(qDaten.id.notIn((Collection<Integer>)arrayList)).and(qEntdecker.nachname.eq(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase())).and(qDaten.durchmesser.gt(0.0).and(qDaten.durchmesser.lt(2.0))).and(qDaten.temperatur.gt(-273.0)))).fetch();
            ArrayList<ErgebnisXYDto> arrayList4 = new ArrayList<ErgebnisXYDto>();
            Object object3 = object22.iterator();
            while (object3.hasNext()) {
                object = (Tuple)object3.next();
                double d = object.get(qDaten.durchmesser) * 11.194418312950768;
                arrayList4.add(new ErgebnisXYDto(object.get(qDaten.temperatur) - 273.15, d));
                arrayList3.add(object.get(qDaten.id));
            }
            hashMap.put(SprachcontainerFabrik.getSprachcontainer().getString("sim_gui188"), arrayList4);
            object3 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.durchmesser, qDaten.temperatur}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isFalse()).and(qEntdecker.nachname.eq(EntdeckerWeltraumteleskope.TESS.getNameInDatabase())).and(qDaten.id.notIn(arrayList3)).and(qDaten.durchmesser.gt(0.0).and(qDaten.durchmesser.lt(2.0))).and(qDaten.temperatur.gt(-273.0)))).fetch();
            object = new ArrayList();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                Tuple tuple = (Tuple)iterator.next();
                double d = tuple.get(qDaten.durchmesser) * 11.194418312950768;
                object.add(new ErgebnisXYDto(tuple.get(qDaten.temperatur) - 273.15, d));
            }
            hashMap.put(SprachcontainerFabrik.getSprachcontainer().getString("sim_gui191"), (List<ErgebnisXYDto>)object);
        }
        catch (Exception exception) {
            this.logger.error(exception);
        }
        return hashMap;
    }
}

