/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.datenbankkern.api.repos.IEntdeckerRepository;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IEntdeckerBasicDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenTeleskopeDAO;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PlanetenTeleskopeDAO
implements IPlanetenTeleskopeDAO {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCache;
    private final IEntdeckerRepository entdeckerRepository;
    private final IEntdeckerBasicDAO entdeckerBasicDAO;

    @Inject
    public PlanetenTeleskopeDAO(IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO, IEntdeckerRepository iEntdeckerRepository, IEntdeckerBasicDAO iEntdeckerBasicDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCache = iIdCacheDAO;
        this.entdeckerRepository = iEntdeckerRepository;
        this.entdeckerBasicDAO = iEntdeckerBasicDAO;
    }

    @Override
    public Map<String, Integer> getWeltraumteleskopeUndAnzahlEntdeckungen() {
        Map<String, Integer> map = new HashMap<String, Integer>();
        try {
            List<Entdecker> list = this.entdeckerRepository.findAllSpaceTelescopes();
            map = this.entdeckerBasicDAO.getEntdeckerUndAnzahl(list);
        }
        catch (Exception exception) {
            this.logger.error("Fehler beim Laden der Weltraumteleskope und Planetenanzahl", exception);
        }
        return map;
    }

    @Override
    public Map<String, Integer> getTeleskopeUndProzentPlaneten() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        QDaten qDaten = new QDaten("planeten");
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        try {
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.typ.eq(EntdeckerTyp.SPACE_TELESCOPE.getType()))).fetch();
            List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qZtentdecker.entdeckerid}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid).and(qZtentdecker.entdeckerid.in(list)))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()))).fetch();
            int n = list2.size();
            for (Object object : list2) {
                Integer n2 = object.get(qZtentdecker.entdeckerid);
                String string = n2 != null ? EntdeckerTyp.TeleskopTyp.SPACE.name().toLowerCase() : EntdeckerTyp.TeleskopTyp.GROUND.name().toLowerCase();
                hashMap.merge(string, 1, Integer::sum);
            }
            for (Object object : hashMap.keySet()) {
                hashMap.put((String)object, (int)Math.round((double)((Integer)hashMap.get(object)).intValue() * 100.0 / (double)n));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return hashMap;
    }

    @Override
    public Map<String, Integer> getTeleskopeInMehrfachsternsystemenUndProzentPlaneten() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        QDaten qDaten = new QDaten("planeten");
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        try {
            ArrayList arrayList;
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.typ.eq(EntdeckerTyp.SPACE_TELESCOPE.getType()))).fetch();
            List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qZtentdecker.entdeckerid, qDaten.zugehoerigkeit}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid).and(qZtentdecker.entdeckerid.in(list)))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.zugehoerigkeit.isNotNull()))).fetch();
            HashMap hashMap2 = new HashMap();
            for (Object object : list2) {
                Object object2 = object.get(qDaten.zugehoerigkeit);
                arrayList = (ArrayList)hashMap2.get(object2);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap2.put(object2, arrayList);
                }
                arrayList.add(object);
            }
            int n = 0;
            for (Object object2 : hashMap2.values()) {
                if (object2.size() <= 1) continue;
                n += object2.size();
                arrayList = object2.iterator();
                while (arrayList.hasNext()) {
                    Tuple tuple = (Tuple)arrayList.next();
                    Integer n2 = tuple.get(qZtentdecker.entdeckerid);
                    String string = n2 != null ? EntdeckerTyp.TeleskopTyp.SPACE.name().toLowerCase() : EntdeckerTyp.TeleskopTyp.GROUND.name().toLowerCase();
                    hashMap.merge(string, 1, Integer::sum);
                }
            }
            for (Object object2 : hashMap.keySet()) {
                hashMap.put((String)object2, (int)Math.round((double)((Integer)hashMap.get(object2)).intValue() * 100.0 / (double)n));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return hashMap;
    }

    @Override
    public Map<String, Integer> getTeleskopeUndProzentKleinePlaneten() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        QDaten qDaten = new QDaten("planeten");
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        try {
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.typ.eq(EntdeckerTyp.SPACE_TELESCOPE.getType()))).fetch();
            List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qZtentdecker.entdeckerid}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid).and(qZtentdecker.entdeckerid.in(list)))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.masse.between(1.0E-7, 0.00628).or(qDaten.durchmesser.between(1.0E-7, 0.1784))))).fetch();
            int n = list2.size();
            for (Object object : list2) {
                Integer n2 = object.get(qZtentdecker.entdeckerid);
                String string = n2 != null ? EntdeckerTyp.TeleskopTyp.SPACE.name().toLowerCase() : EntdeckerTyp.TeleskopTyp.GROUND.name().toLowerCase();
                hashMap.merge(string, 1, Integer::sum);
            }
            for (Object object : hashMap.keySet()) {
                hashMap.put((String)object, (int)Math.round((double)((Integer)hashMap.get(object)).intValue() * 100.0 / (double)n));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return hashMap;
    }

    @Override
    public Map<String, Integer> getTeleskopeUndProzentLanglaufendePlaneten() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        QDaten qDaten = new QDaten("planeten");
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        try {
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.typ.eq(EntdeckerTyp.SPACE_TELESCOPE.getType()))).fetch();
            List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qZtentdecker.entdeckerid}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid).and(qZtentdecker.entdeckerid.in(list)))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.umlaufszeit.goe(365.0)))).fetch();
            int n = list2.size();
            for (Object object : list2) {
                Integer n2 = object.get(qZtentdecker.entdeckerid);
                String string = n2 != null ? EntdeckerTyp.TeleskopTyp.SPACE.name().toLowerCase() : EntdeckerTyp.TeleskopTyp.GROUND.name().toLowerCase();
                hashMap.merge(string, 1, Integer::sum);
            }
            for (Object object : hashMap.keySet()) {
                hashMap.put((String)object, (int)Math.round((double)((Integer)hashMap.get(object)).intValue() * 100.0 / (double)n));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return hashMap;
    }

    @Override
    public Map<String, Integer> getTeleskopeUndProzentEntferntestePlaneten() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        QDaten qDaten = new QDaten("planeten");
        QDaten qDaten2 = new QDaten("sterne");
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        try {
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.typ.eq(EntdeckerTyp.SPACE_TELESCOPE.getType()))).fetch();
            List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qZtentdecker.entdeckerid}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid).and(qZtentdecker.entdeckerid.in(list)))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten2.entfernung.goe(5000.0)))).fetch();
            int n = list2.size();
            for (Object object : list2) {
                Integer n2 = object.get(qZtentdecker.entdeckerid);
                String string = n2 != null ? EntdeckerTyp.TeleskopTyp.SPACE.name().toLowerCase() : EntdeckerTyp.TeleskopTyp.GROUND.name().toLowerCase();
                hashMap.merge(string, 1, Integer::sum);
            }
            for (Object object : hashMap.keySet()) {
                hashMap.put((String)object, (int)Math.round((double)((Integer)hashMap.get(object)).intValue() * 100.0 / (double)n));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return hashMap;
    }

    @Override
    public List<ErgebnisXYDto> findPlanetRadiusBySpaceTelescope(EntdeckerWeltraumteleskope entdeckerWeltraumteleskope) {
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        QDaten qDaten = new QDaten("planeten");
        QDaten qDaten2 = new QDaten("sterne");
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        try {
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qDaten2.temperatur}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qEntdecker.nachname.eq(entdeckerWeltraumteleskope.getNameInDatabase())).and(qDaten.durchmesser.gt(0.0)).and(qDaten2.temperatur.gt(0.0)))).fetch();
            for (Tuple tuple : list) {
                double d = tuple.get(qDaten.durchmesser) * 11.194418312950768;
                arrayList.add(new ErgebnisXYDto(tuple.get(qDaten2.temperatur), d));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return arrayList;
    }

    @Override
    public Map<String, List<ErgebnisXYDto>> findPlanetRadiusByTess() {
        HashMap<String, List<ErgebnisXYDto>> hashMap = new HashMap<String, List<ErgebnisXYDto>>();
        QDaten qDaten = new QDaten("planeten");
        QDaten qDaten2 = new QDaten("sterne");
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        try {
            Object object;
            Object object22;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qDaten2.temperatur}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qEntdecker.nachname.eq(EntdeckerWeltraumteleskope.TESS.getNameInDatabase())).and(qEntdecker.nachname.ne(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase())).and(qDaten.durchmesser.gt(0.0)).and(qDaten2.temperatur.gt(0.0)))).fetch();
            ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
            for (Object object22 : list) {
                double d = object22.get(qDaten.durchmesser) * 11.194418312950768;
                arrayList.add(new ErgebnisXYDto(object22.get(qDaten2.temperatur), d));
            }
            hashMap.put(EntdeckerWeltraumteleskope.TESS.getNameInDatabase(), arrayList);
            List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qDaten2.temperatur}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qEntdecker.nachname.eq(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase())).and(qEntdecker.nachname.ne("G\u00fchne")).and(qDaten.durchmesser.gt(0.0)).and(qDaten2.temperatur.gt(0.0)))).fetch();
            object22 = new ArrayList();
            Object object3 = list2.iterator();
            while (object3.hasNext()) {
                object = (Tuple)object3.next();
                double d = object.get(qDaten.durchmesser) * 11.194418312950768;
                object22.add(new ErgebnisXYDto(object.get(qDaten2.temperatur), d));
            }
            hashMap.put(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase(), (List<ErgebnisXYDto>)object22);
            object3 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qDaten2.temperatur}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qEntdecker.nachname.eq("G\u00fchne")).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.durchmesser.gt(0.0)).and(qDaten2.temperatur.gt(0.0)))).fetch();
            if (!object3.isEmpty()) {
                object = new ArrayList();
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    Tuple tuple = (Tuple)iterator.next();
                    double d = tuple.get(qDaten.durchmesser) * 11.194418312950768;
                    object.add(new ErgebnisXYDto(tuple.get(qDaten2.temperatur), d));
                }
                hashMap.put(SprachcontainerFabrik.getSprachcontainer().getString("sim_gui196"), (List<ErgebnisXYDto>)object);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return hashMap;
    }
}

