/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.impl.tabellenmanipulation.Tabellenstruktur;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QObjektalter;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.IDAOlowAllgemein;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISonnenaehnlicheSterneDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.SonnenaehnlicheSterneDto;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class SonnenaehnlicheSterneDAO
extends Tabellenstruktur
implements ISonnenaehnlicheSterneDAO {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IIdCacheDAO idCache;
    private final IDatenbankService datenbankService;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public SonnenaehnlicheSterneDAO(IIdCacheDAO iIdCacheDAO, IDAOlowAllgemein iDAOlowAllgemein, IDatenbankService iDatenbankService, IKategorienRepository iKategorienRepository, IDatenbankverbinder iDatenbankverbinder) {
        this.idCache = iIdCacheDAO;
        this.datenbankService = iDatenbankService;
        this.kategorienRepository = iKategorienRepository;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public List<Integer> getMasseSonnenaehnlicherSterne(double d, double d2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        QDaten qDaten = QDaten.daten;
        try {
            long l = System.currentTimeMillis();
            long l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.masse.eq(0.0).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetchCount();
            arrayList.add((int)l2);
            l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.masse.goe(d).or(qDaten.masse.loe(d2))).and(qDaten.masse.ne(0.0)))).fetchCount();
            arrayList.add((int)l2);
            l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.masse.lt(d).and(qDaten.masse.gt(d2))).and(qDaten.id.ne(this.idCache.getDatenIdSonne())))).fetchCount();
            arrayList.add((int)l2);
            this.logger.debug("getMasseSonnenaehnlicherSterne dauerte " + (System.currentTimeMillis() - l) + " ms");
            return arrayList;
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Integer> getMetalSonnenaehnlicherSterne(double d, double d2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        QDaten qDaten = QDaten.daten;
        try {
            long l = System.currentTimeMillis();
            long l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.metallizitaet.eq(-100.0)))).fetchCount();
            arrayList.add((int)l2);
            l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.metallizitaet.goe(d).or(qDaten.metallizitaet.loe(d2))).and(qDaten.metallizitaet.ne(-100.0)))).fetchCount();
            arrayList.add((int)l2);
            l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.metallizitaet.lt(d).and(qDaten.metallizitaet.gt(d2))).and(qDaten.id.ne(this.idCache.getDatenIdSonne())))).fetchCount();
            arrayList.add((int)l2);
            this.logger.debug("getMetalSonnenaehnlicherSterne dauerte " + (System.currentTimeMillis() - l) + " ms");
            return arrayList;
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Integer> getAHSonnenaehnlicherSterne(double d, double d2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        QDaten qDaten = QDaten.daten;
        try {
            long l = System.currentTimeMillis();
            long l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.ah.eq(-100.0)))).fetchCount();
            arrayList.add((int)l2);
            l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.ah.goe(d).or(qDaten.ah.loe(d2))).and(qDaten.ah.ne(-100.0)))).fetchCount();
            arrayList.add((int)l2);
            l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.ah.lt(d).and(qDaten.ah.gt(d2))).and(qDaten.id.ne(this.idCache.getDatenIdSonne())))).fetchCount();
            arrayList.add((int)l2);
            this.logger.debug("getAHSonnenaehnlicherSterne dauerte " + (System.currentTimeMillis() - l) + " ms");
            return arrayList;
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Integer> getBVSonnenaehnlicherSterne(double d, double d2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        QDaten qDaten = QDaten.daten;
        try {
            long l = System.currentTimeMillis();
            long l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.bv.eq(-100.0)))).fetchCount();
            arrayList.add((int)l2);
            l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.bv.goe(d).or(qDaten.bv.loe(d2))).and(qDaten.bv.ne(-100.0)))).fetchCount();
            arrayList.add((int)l2);
            l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.bv.lt(d).and(qDaten.bv.gt(d2))).and(qDaten.id.ne(this.idCache.getDatenIdSonne())))).fetchCount();
            arrayList.add((int)l2);
            this.logger.debug("getBVSonnenaehnlicherSterne dauerte " + (System.currentTimeMillis() - l) + " ms");
            return arrayList;
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return Collections.emptyList();
        }
    }

    @Override
    public List<Integer> getAlterSonnenaehnlicherSterne(double d, double d2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            QDaten qDaten = QDaten.daten;
            QObjektalter qObjektalter = QObjektalter.objektalter;
            long l = System.currentTimeMillis();
            long l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.id.notIn((SubQueryExpression<Integer>)SQLExpressions.select(qObjektalter.datenid).from((Expression<?>)qObjektalter)).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetchCount();
            arrayList.add((int)l2);
            l2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjektalter.count()).from((Expression<?>)qObjektalter)).leftJoin((EntityPath)qDaten)).on((Predicate)qObjektalter.datenid.eq(qDaten.id))).where(qObjektalter.alter.loe(d).or(qObjektalter.alter.goe(d2)).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetchCount();
            arrayList.add((int)l2);
            l2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjektalter.count()).from((Expression<?>)qObjektalter)).leftJoin((EntityPath)qDaten)).on((Predicate)qObjektalter.datenid.eq(qDaten.id))).where(qObjektalter.alter.gt(d).and(qObjektalter.alter.lt(d2)).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.id.ne(this.idCache.getDatenIdSonne())))).fetchCount();
            arrayList.add((int)l2);
            this.logger.debug("getAlterSonnenaehnlicherSterne dauerte " + (System.currentTimeMillis() - l) + " ms");
        }
        catch (SQLException sQLException) {
            this.logger.error("getAlterSonnenaehnlicherSterne(" + d + "," + d2 + ")", sQLException);
        }
        return arrayList;
    }

    @Override
    public List<Integer> getSpektraltypSonnenaehnlicherSterne() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            long l = System.currentTimeMillis();
            int n = this.getDatenbankService().getIDFuerSpektraltyp("unbekannt", ObjektKategorie.STERNE.getKategorienName());
            int n2 = this.getDatenbankService().getIDFuerSpektraltyp("G", ObjektKategorie.STERNE.getKategorienName());
            this.logger.debug("getSpektraltypSonnenaehnlicherSterne (ids ermitteln) dauerte " + (System.currentTimeMillis() - l) + " ms");
            QDaten qDaten = QDaten.daten;
            l = System.currentTimeMillis();
            long l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.spektralklasse.eq(n).or(qDaten.spektralklasse.isNull()).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetchCount();
            arrayList.add((int)l2);
            this.logger.debug("getSpektraltypSonnenaehnlicherSterne (unbekannte werte ermitteln) dauerte " + (System.currentTimeMillis() - l) + " ms");
            l = System.currentTimeMillis();
            l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.spektralklasse.notIn((Object[])new Integer[]{n2, n}).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetchCount();
            arrayList.add((int)l2);
            this.logger.debug("getSpektraltypSonnenaehnlicherSterne (un\u00e4hnliche werte ermitteln) dauerte " + (System.currentTimeMillis() - l) + " ms");
            l = System.currentTimeMillis();
            l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.spektralklasse.eq(n2).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.id.ne(this.idCache.getDatenIdSonne())))).fetchCount();
            arrayList.add((int)l2);
            this.logger.debug("getSpektraltypSonnenaehnlicherSterne (sonnen\u00e4hnliche werte ermitteln) dauerte " + (System.currentTimeMillis() - l) + " ms");
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error(exception);
        }
        return arrayList;
    }

    @Override
    public List<Integer> getLeuchtkraftklasseSonnenaehnlicherSterne() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            long l = System.currentTimeMillis();
            QDaten qDaten = QDaten.daten;
            int n = this.getLeuchtkraftklassenID("unbekannt");
            int n2 = this.getLeuchtkraftklassenID("V");
            long l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.lumin.eq(n).or(qDaten.lumin.isNull()).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetchCount();
            arrayList.add((int)l2);
            l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.lumin.notIn((Object[])new Integer[]{n, n2}).and(qDaten.lumin.isNotNull()).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetchCount();
            arrayList.add((int)l2);
            l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.lumin.eq(n2).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.id.ne(this.idCache.getDatenIdSonne())))).fetchCount();
            arrayList.add((int)l2);
            this.logger.debug("getLeuchtkraftklasseSonnenaehnlicherSterne dauerte " + (System.currentTimeMillis() - l) + " ms");
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
        }
        return arrayList;
    }

    @Override
    public List<Integer> getSonnenaehnlicheSterne2(SonnenaehnlicheSterneDto sonnenaehnlicheSterneDto) {
        double d = sonnenaehnlicheSterneDto.getMasseMinimal();
        double d2 = sonnenaehnlicheSterneDto.getMasseMaximal();
        double d3 = sonnenaehnlicheSterneDto.getBvMinimal();
        double d4 = sonnenaehnlicheSterneDto.getBvMaximal();
        double d5 = sonnenaehnlicheSterneDto.getAbsoluteHelligkeitMinimal();
        double d6 = sonnenaehnlicheSterneDto.getAbsoluteHelligkeitMaximal();
        double d7 = sonnenaehnlicheSterneDto.getMetalMinimal();
        double d8 = sonnenaehnlicheSterneDto.getMetalMaximal();
        double d9 = sonnenaehnlicheSterneDto.getAlterMaximal();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n = 0;
        try {
            long l = System.currentTimeMillis();
            long l2 = System.currentTimeMillis();
            Integer n2 = this.getDatenbankService().getIDFuerSpektraltyp("unbekannt", ObjektKategorie.STERNE.getKategorienName());
            int n3 = this.getLeuchtkraftklassenID("unbekannt");
            int n4 = this.idCache.getDatenIdSonne();
            this.logger.debug("ids ermitteln dauerte " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            arrayList.add(this.getDatenbankService().getInt("SELECT COUNT(id) AS c FROM daten WHERE objektid IN (SELECT id FROM objekttypen WHERE kategorieid=(SELECT id FROM kategorie WHERE Name='" + ObjektKategorie.STERNE.getKategorienName() + "')) AND (SPEKTRALKLASSE=" + n2 + " OR LUMIN=" + n3 + " OR masse=0.0 OR BV=-100.0 OR metallizitaet=-100.0 OR AH=-100.0 OR id NOT IN (SELECT datenid FROM objektalter)) AND id!=" + n4 + ";", "c"));
            this.logger.debug("sterne mit unbekannten werten ermitteln dauerte " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            Integer n5 = this.getDatenbankService().getIDFuerSpektraltyp("G", ObjektKategorie.STERNE.getKategorienName());
            int n6 = this.getLeuchtkraftklassenID("V");
            List<Integer> list = this.getDatenbankService().getListeMitInt("SELECT id FROM daten WHERE objektid IN (SELECT id FROM objekttypen WHERE kategorieid=(SELECT id FROM kategorie WHERE Name='" + ObjektKategorie.STERNE.getKategorienName() + "')) AND SPEKTRALKLASSE=" + n5 + " AND LUMIN=" + n6 + " AND masse<" + d2 + " AND masse>" + d + " AND BV<" + d4 + " AND bv>" + d3 + " AND metallizitaet<" + d8 + " AND metallizitaet>" + d7 + " AND AH<" + d6 + " AND ah>" + d5 + " AND id!=" + n4 + ";", "id");
            for (int n7 : list) {
                Integer n8 = this.getDatenbankService().getInt("SELECT COUNT(id) AS c FROM objektalter WHERE datenid=" + n7 + " AND alter>" + d5 + " AND alter<" + d9 + ";", "c");
                if (n8 == null) continue;
                ++n;
                arrayList2.add(n7);
            }
            this.logger.debug("sonnen\u00e4hnliche werte ermitteln dauerte " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            arrayList.add(this.kategorienRepository.getAnzahl(ObjektKategorie.STERNE.getKategorienName()) - ((Integer)arrayList.get(0) + n + 1));
            arrayList.add(n);
            arrayList.addAll(arrayList2);
            this.logger.debug("un\u00e4hnliche werte ermitteln dauerte " + (System.currentTimeMillis() - l2) + " ms");
            this.logger.debug("getSonnenaehnlicheSterne2 dauerte " + (System.currentTimeMillis() - l) + " ms");
        }
        catch (SQLException sQLException) {
            this.logger.error("getSonnenaehnlicheSterne2(" + d + "," + d2 + "," + d3 + "," + d4 + "," + d5 + "," + d6 + "," + d7 + "," + d8 + ")", sQLException);
        }
        return arrayList;
    }

    private int getLeuchtkraftklassenID(String string) {
        try {
            return this.getDatenbankService().getInt("SELECT id FROM lumin WHERE Typ='" + string + "';", "id");
        }
        catch (SQLException sQLException) {
            this.logger.error("getLeuchtkraftklassenID(" + string + ")", sQLException);
            throw new IllegalArgumentException("keine Leuchtkraftklasse f\u00fcr '" + string + "' gefunden!");
        }
    }

    private IDatenbankService getDatenbankService() {
        return this.datenbankService;
    }
}

