/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public final class SptypTemperaturUtil {
    private static final Set<String> SUPPORTED_SPTYPES = Set.of("O", "B", "A", "F", "G", "K", "M", "L");

    private SptypTemperaturUtil() {
    }

    public static boolean supportsSptype(String string) {
        return SUPPORTED_SPTYPES.contains(string);
    }

    public static Pair<Double, Double> getTemperatureForSptyp(String string) {
        switch (string) {
            case "O": {
                return Pair.of(25000.0, 50000.0);
            }
            case "B": {
                return Pair.of(10000.0, 25000.0);
            }
            case "A": {
                return Pair.of(7600.0, 10000.0);
            }
            case "F": {
                return Pair.of(6000.0, 7600.0);
            }
            case "G": {
                return Pair.of(5100.0, 6000.0);
            }
            case "K": {
                return Pair.of(3600.0, 5100.0);
            }
            case "M": {
                return Pair.of(2300.0, 3600.0);
            }
            case "L": {
                return Pair.of(1900.0, 2300.0);
            }
        }
        throw new IllegalArgumentException("Stern mit Sptyp " + string + " au\u00dferhalb der Erwartung!");
    }

    public static String getSptypForTemperature(double d) {
        if (d > 25000.0 && d >= 50000.0) {
            return "O";
        }
        if (d >= 10000.0) {
            return "B";
        }
        if (d >= 7600.0) {
            return "A";
        }
        if (d >= 6000.0) {
            return "F";
        }
        if (d >= 5100.0) {
            return "G";
        }
        if (d >= 3600.0) {
            return "K";
        }
        if (d >= 2300.0) {
            return "M";
        }
        if (d >= 1900.0) {
            return "L";
        }
        throw new IllegalArgumentException("Stern mit Temperatur " + d + " au\u00dferhalb der Erwartung!");
    }
}

