/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.helfer.Konverter;
import de.planetensuche.datenbankkern.helfer.Listen;
import de.planetensuche.datenbankkern.impl.tabellenmanipulation.Tabellenstruktur;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QLumin;
import de.planetensuche.datenbankkern.querydsl5.QObjektalter;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp2;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.kategorien.SptypTemperaturUtil;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public final class SterneDAO
extends Tabellenstruktur
implements ISterneDAO {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IIdCacheDAO idCache;
    private final IDatenbankService datenbankService;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public SterneDAO(IIdCacheDAO iIdCacheDAO, IDatenbankService iDatenbankService, IDatenbankverbinder iDatenbankverbinder) {
        this.idCache = iIdCacheDAO;
        this.datenbankService = iDatenbankService;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public boolean hasSternBrauneZwerge(int n) {
        try {
            QDaten qDaten = QDaten.daten;
            long l = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.zugehoerigkeit.eq(n).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge())).and(qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
            return l > 0L;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("hasSternBrauneZwerge(" + n + ")", runtimeException);
            return false;
        }
    }

    @Override
    public double[][] getAlterUndMasse(double d, boolean bl) {
        return this.getAlterUndSpalte("masse", d, 0.0, bl);
    }

    @Override
    public double[][] getAlterUndMetal(boolean bl) {
        return this.getAlterUndSpalte("metallizitaet", 10.0, -100.0, bl);
    }

    @Override
    public double[][] getAlterUndAbsH(boolean bl) {
        return this.getAlterUndSpalte("ah", 30.0, -100.0, bl);
    }

    @Override
    public double[][] getAlterUndEntfernung(double d, boolean bl) {
        return this.getAlterUndSpalte("entfernung", d, 0.0, bl);
    }

    @Override
    public double[][] getAlterUndTemperatur(double d, boolean bl) {
        return this.getAlterUndSpalte("temperatur", d, 100.0, bl);
    }

    @Override
    public boolean isStern(int n) {
        try {
            QDaten qDaten = QDaten.daten;
            Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.objektid).from((Expression<?>)qDaten)).where(qDaten.id.eq(n))).fetchOne();
            return this.idCache.getObjekttypenidsSterne().contains(n2);
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("Fehler in isStern(" + n + ")", runtimeException);
            return false;
        }
    }

    @Override
    public double[][] getAlterUndSpalte(String string, double d, double d2, boolean bl) {
        try {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            String[] stringArray = new String[]{};
            String[] stringArray2 = new String[]{string, "alter"};
            String[] stringArray3 = new String[]{"id"};
            for (Integer n : this.idCache.getObjekttypenidsSterne()) {
                Listen listen = this.getDatenbankService().getListeMitStringsUndListeMitDoublesUndListeMitInts("SELECT D.id, D." + string + ", A.alter FROM daten AS D, objektalter AS A WHERE objektid=" + n + " AND " + string + ">" + d2 + " AND " + string + "<" + d + " AND A.datenid=D.id;", stringArray, stringArray2, stringArray3);
                arrayList.addAll(this.getBestimmteSterneAusListe(listen.getListInteger(), bl, listen.getListDouble()));
            }
            return Konverter.convertListToArray(arrayList);
        }
        catch (SQLException sQLException) {
            this.logger.error("getAlterUndSpalte(" + string + "," + bl + ")", sQLException);
            return new double[0][0];
        }
    }

    @Override
    public int getNumberOfSptypesForDoubleAndMultipleStarsIn34ly(String string) {
        try {
            QDaten qDaten = QDaten.daten;
            QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
            QKategorie qKategorie = QKategorie.kategorie;
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(StarObjectType.DOUBLE_STAR_REAL.getTypeName()).or(qObjekttypen.typ.eq(StarObjectType.ECLIPSING_BINARY.getTypeName())).or(qObjekttypen.typ.eq(StarObjectType.MULTI_STAR_SYSTEM.getTypeName())))).fetch();
            Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qSpektraltyp.id).from((Expression<?>)qSpektraltyp)).where(qSpektraltyp.typ.eq(string).and(qSpektraltyp.kid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.STERNE.getKategorienName())))))).fetchOne();
            BooleanExpression booleanExpression = qDaten.spektralklasse.eq(n);
            if (SptypTemperaturUtil.supportsSptype(string)) {
                Pair<Double, Double> pair = SptypTemperaturUtil.getTemperatureForSptyp(string);
                booleanExpression = booleanExpression.or(qDaten.temperatur.between(pair.getLeft(), pair.getRight()));
            }
            long l = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in(list).and(qDaten.entfernung.between(1.0, 34.0)).and(booleanExpression))).fetchCount();
            return (int)l;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getNumberOfSptypesForDoubleAndMultipleStarsIn34ly(" + string + ")", runtimeException);
            return 0;
        }
    }

    @Override
    public int getAnzahlSpektraltypenIn34Ly(String string) {
        try {
            QDaten qDaten = QDaten.daten;
            QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
            QKategorie qKategorie = QKategorie.kategorie;
            long l = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.entfernung.between(1.0, 34.0)).and(qDaten.spektralklasse.eq((Expression)((SQLQuery)SQLExpressions.select(qSpektraltyp.id).from((Expression<?>)qSpektraltyp)).where(qSpektraltyp.typ.eq(string).and(qSpektraltyp.kid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.STERNE.getKategorienName()))))))))).fetchCount();
            return (int)l;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getAnzahlSpektraltypenIn34Ly(" + string + ")", runtimeException);
            return 0;
        }
    }

    @Override
    public double[][] getHelligkeitUndMasse(double d, boolean bl) {
        try {
            List<Integer> list = this.findeSternIdsMitPlaneten();
            QDaten qDaten = QDaten.daten;
            long l = System.currentTimeMillis();
            List list2 = bl ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.ah, qDaten.masse}).from((Expression<?>)qDaten)).where(qDaten.id.in((Collection<Integer>)list).and(qDaten.masse.loe(d)).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.masse.ne(0.0)).and(qDaten.ah.gt(-100.0)))).fetch() : ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.ah, qDaten.masse}).from((Expression<?>)qDaten)).where(qDaten.masse.loe(d).and(qDaten.masse.ne(0.0)).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.id.notIn((Collection<Integer>)list)).and(qDaten.ah.gt(-100.0)))).fetch();
            this.logger.debug("query masse und abs. helligkeit ben\u00f6tigte " + (System.currentTimeMillis() - l) + " ms; sterneMitPlaneten? " + bl);
            double[][] dArray = new double[list2.size()][2];
            int n = 0;
            for (Tuple tuple : list2) {
                dArray[n][0] = tuple.get(qDaten.masse);
                dArray[n][1] = tuple.get(qDaten.ah);
                ++n;
            }
            return dArray;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getHelligkeitUndMasse(" + d + "," + bl + ")", runtimeException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getHelligkeitUndDurchmesser(double d, boolean bl) {
        try {
            QDaten qDaten = QDaten.daten;
            List<Integer> list = this.findeSternIdsMitPlaneten();
            long l = System.currentTimeMillis();
            List list2 = bl ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qDaten.ah}).from((Expression<?>)qDaten)).where(qDaten.id.in((Collection<Integer>)list).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.durchmesser.gt(0.0).and(qDaten.durchmesser.lt(d))).and(qDaten.ah.gt(-100.0)))).fetch() : ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qDaten.ah}).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.id.notIn((Collection<Integer>)list)).and(qDaten.durchmesser.gt(0.0).and(qDaten.durchmesser.lt(d))).and(qDaten.ah.gt(-100.0)))).fetch();
            this.logger.debug("sterne mit durchmesser (sterneMitPlaneten? " + bl + ") ermitteln dauerte " + (System.currentTimeMillis() - l) + " ms");
            double[][] dArray = new double[list2.size()][2];
            int n = 0;
            for (Tuple tuple : list2) {
                dArray[n][0] = tuple.get(qDaten.durchmesser);
                dArray[n][1] = tuple.get(qDaten.ah);
                ++n;
            }
            return dArray;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getHelligkeitUndDurchmesser(" + d + "," + bl + ")", runtimeException);
            return new double[0][0];
        }
    }

    private List<Integer> findeSternIdsMitPlaneten() {
        QDaten qDaten = new QDaten("planeten");
        QDaten qDaten2 = new QDaten("sterne");
        long l = System.currentTimeMillis();
        List<Integer> list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)qDaten2.id).from((Expression<?>)qDaten2)).join((EntityPath)qDaten)).on((Predicate)qDaten2.id.eq(qDaten.zugehoerigkeit))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten2.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.zugehoerigkeit.isNotNull()).and(qDaten.entdeckungbestaetigt.isTrue()))).fetch();
        this.logger.debug("sterne mit exoplaneten ermitteln dauerte " + (System.currentTimeMillis() - l) + " ms");
        return list;
    }

    private List<Integer> findeSternUndBrZwergeIdsMitPlaneten() {
        QDaten qDaten = QDaten.daten;
        long l = System.currentTimeMillis();
        List<Integer> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.zugehoerigkeit.isNotNull()).and(qDaten.entdeckungbestaetigt.isTrue()))).fetch();
        this.logger.debug("sterne+br zwerge mit exoplaneten ermitteln dauerte " + (System.currentTimeMillis() - l) + " ms");
        return list;
    }

    @Override
    public double[][] getEntfernungUndMetallizitaet(double d, boolean bl) {
        try {
            QDaten qDaten = QDaten.daten;
            List<Integer> list = this.findeSternIdsMitPlaneten();
            List list2 = bl ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qDaten.metallizitaet}).from((Expression<?>)qDaten)).where(qDaten.id.in((Collection<Integer>)list).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.entfernung.lt(d).and(qDaten.entfernung.gt(0.0))).and(qDaten.metallizitaet.gt(-100.0)))).fetch() : ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qDaten.metallizitaet}).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.id.notIn((Collection<Integer>)list)).and(qDaten.entfernung.lt(d).and(qDaten.entfernung.gt(0.0))).and(qDaten.metallizitaet.gt(-100.0)))).fetch();
            double[][] dArray = new double[list2.size()][2];
            int n = 0;
            for (Tuple tuple : list2) {
                dArray[n][0] = tuple.get(qDaten.entfernung);
                dArray[n][1] = tuple.get(qDaten.metallizitaet);
                ++n;
            }
            return dArray;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getMetalUndEntfernung(" + d + "," + bl + ")", runtimeException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getMetalUndMasse(double d, boolean bl) {
        try {
            List<Integer> list = this.findeSternIdsMitPlaneten();
            long l = System.currentTimeMillis();
            QDaten qDaten = QDaten.daten;
            List list2 = bl ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.metallizitaet, qDaten.masse}).from((Expression<?>)qDaten)).where(qDaten.id.in((Collection<Integer>)list).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.masse.lt(d)).and(qDaten.masse.gt(0.0)).and(qDaten.metallizitaet.gt(-100.0)))).fetch() : ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.metallizitaet, qDaten.masse}).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.id.notIn((Collection<Integer>)list)).and(qDaten.masse.lt(d)).and(qDaten.masse.gt(0.0)).and(qDaten.metallizitaet.gt(-100.0)))).fetch();
            this.logger.debug("query masse und metal ben\u00f6tigte " + (System.currentTimeMillis() - l) + " ms; sterneMitPlaneten? " + bl);
            double[][] dArray = new double[list2.size()][2];
            int n = 0;
            for (Tuple tuple : list2) {
                dArray[n][0] = tuple.get(qDaten.masse);
                dArray[n][1] = tuple.get(qDaten.metallizitaet);
                ++n;
            }
            return dArray;
        }
        catch (Exception exception) {
            this.logger.error("getMetalUndMasse(" + d + "," + bl + ")", exception);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getMasseUndEntfernung(double d, boolean bl) {
        try {
            QDaten qDaten = QDaten.daten;
            List<Integer> list = this.findeSternIdsMitPlaneten();
            long l = System.currentTimeMillis();
            List list2 = bl ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qDaten.masse}).from((Expression<?>)qDaten)).where(qDaten.id.in((Collection<Integer>)list).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.entfernung.lt(d).and(qDaten.entfernung.gt(0.0))).and(qDaten.masse.gt(0.0)))).fetch() : ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qDaten.masse}).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.id.notIn((Collection<Integer>)list)).and(qDaten.entfernung.lt(d).and(qDaten.entfernung.gt(0.0))).and(qDaten.masse.gt(0.0)))).fetch();
            this.logger.debug("sterne mit masse und entfernung (sterneMitPlaneten? " + bl + ") ermitteln dauerte " + (System.currentTimeMillis() - l) + " ms");
            double[][] dArray = new double[list2.size()][2];
            int n = 0;
            for (Tuple tuple : list2) {
                dArray[n][0] = tuple.get(qDaten.entfernung);
                dArray[n][1] = tuple.get(qDaten.masse);
                ++n;
            }
            return dArray;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getMasseUndEntfernung(" + d + "," + bl + ")", runtimeException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getMetalUndAH(boolean bl) {
        try {
            QDaten qDaten = QDaten.daten;
            List<Integer> list = this.findeSternIdsMitPlaneten();
            long l = System.currentTimeMillis();
            List list2 = bl ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.metallizitaet, qDaten.ah}).from((Expression<?>)qDaten)).where(qDaten.id.in((Collection<Integer>)list).and(qDaten.metallizitaet.gt(-100.0)).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.ah.gt(-100.0)))).fetch() : ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.metallizitaet, qDaten.ah}).from((Expression<?>)qDaten)).where(qDaten.metallizitaet.gt(-100.0).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.id.notIn((Collection<Integer>)list)).and(qDaten.ah.gt(-100.0)))).fetch();
            this.logger.debug("sterne mit metalizit\u00e4t und AH (sterneMitPlaneten? " + bl + ") ermitteln dauerte " + (System.currentTimeMillis() - l) + " ms");
            double[][] dArray = new double[list2.size()][2];
            int n = 0;
            for (Tuple tuple : list2) {
                dArray[n][0] = tuple.get(qDaten.metallizitaet);
                dArray[n][1] = tuple.get(qDaten.ah);
                ++n;
            }
            return dArray;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getMetalUndAH(" + bl + ")", runtimeException);
            return new double[0][0];
        }
    }

    private List<Double> getBestimmteSterneAusListe(List<Integer> list, boolean bl, List<Double> list2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 0;
        for (Integer n2 : list) {
            boolean bl2 = this.hasSternPlaneten(n2);
            if (bl == bl2 || !bl == !bl2) {
                arrayList.add(list2.get(n));
                arrayList.add(list2.get(n + 1));
            }
            n += 2;
        }
        return arrayList;
    }

    @Override
    public double[][] getMetalUndBV(boolean bl) {
        try {
            QDaten qDaten = QDaten.daten;
            List<Integer> list = this.findeSternIdsMitPlaneten();
            long l = System.currentTimeMillis();
            List list2 = bl ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.metallizitaet, qDaten.bv}).from((Expression<?>)qDaten)).where(qDaten.id.in((Collection<Integer>)list).and(qDaten.metallizitaet.gt(-100.0)).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.bv.gt(-100.0)))).fetch() : ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.metallizitaet, qDaten.bv}).from((Expression<?>)qDaten)).where(qDaten.metallizitaet.gt(-100.0).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.id.notIn((Collection<Integer>)list)).and(qDaten.bv.gt(-100.0)))).fetch();
            this.logger.debug("sterne mit metalizit\u00e4t und b-v (sterneMitPlaneten? " + bl + ") ermitteln dauerte " + (System.currentTimeMillis() - l) + " ms");
            double[][] dArray = new double[list2.size()][2];
            int n = 0;
            for (Tuple tuple : list2) {
                dArray[n][0] = tuple.get(qDaten.metallizitaet);
                dArray[n][1] = tuple.get(qDaten.bv);
                ++n;
            }
            return dArray;
        }
        catch (Exception exception) {
            this.logger.error("getMetalUndBV(" + bl + ")", exception);
            return new double[0][0];
        }
    }

    @Override
    public Map<String, List<Pair<Double, Double>>> getMasseUndDurchmesser(double d) {
        try {
            long l = System.currentTimeMillis();
            QDaten qDaten = QDaten.daten;
            QLumin qLumin = QLumin.lumin;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.masse, qDaten.durchmesser, qLumin.typ}).from((Expression<?>)qDaten)).join((EntityPath)qLumin)).on((Predicate)qDaten.lumin.eq(qLumin.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.durchmesser.lt(d)).and(qDaten.masse.lt(d)).and(qDaten.masse.gt(0.0)).and(qDaten.durchmesser.gt(0.0)))).orderBy((OrderSpecifier<?>)qLumin.typ.asc())).fetch();
            this.logger.debug("query masse und durchmesser pro leuchtkraftklasse ben\u00f6tigte " + (System.currentTimeMillis() - l) + " ms");
            LinkedHashMap<String, List<Pair<Double, Double>>> linkedHashMap = new LinkedHashMap<String, List<Pair<Double, Double>>>();
            for (Tuple tuple : list) {
                String string = tuple.get(qLumin.typ);
                ArrayList<Pair<Double, Double>> arrayList = (ArrayList<Pair<Double, Double>>)linkedHashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Pair<Double, Double>>();
                    linkedHashMap.put(string, arrayList);
                }
                arrayList.add(Pair.of(tuple.get(qDaten.masse), tuple.get(qDaten.durchmesser)));
            }
            return linkedHashMap;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getMasseUndDurchmesser(" + d + ")", runtimeException);
            return Collections.emptyMap();
        }
    }

    @Override
    public List<String> getSterneMitEntfernung(double d) {
        try {
            QDaten qDaten = QDaten.daten;
            QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
            QSpektraltyp2 qSpektraltyp2 = QSpektraltyp2.spektraltyp2;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qSpektraltyp.typ, qSpektraltyp2.typ}).from((Expression<?>)qDaten)).join((EntityPath)qSpektraltyp)).on((Predicate)qDaten.spektralklasse.eq(qSpektraltyp.id))).join((EntityPath)qSpektraltyp2)).on((Predicate)qDaten.spektralklasse2.eq(qSpektraltyp2.id))).where(qDaten.entfernung.loe(d).and(qDaten.entfernung.gt(0.0)).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetch();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Tuple tuple : list) {
                String string = tuple.get(qSpektraltyp.typ) + ";" + String.valueOf(tuple.get(qSpektraltyp2.typ)) + ";" + String.valueOf(tuple.get(qDaten.entfernung));
                arrayList.add(string);
            }
            return arrayList;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getSterneMitEntfernung(" + d + ")", runtimeException);
            return Collections.emptyList();
        }
    }

    @Override
    public double[][] getBvUndMasse(double d, boolean bl) {
        try {
            List<Integer> list = this.findeSternIdsMitPlaneten();
            long l = System.currentTimeMillis();
            QDaten qDaten = QDaten.daten;
            List list2 = bl ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.bv, qDaten.masse}).from((Expression<?>)qDaten)).where(qDaten.id.in((Collection<Integer>)list).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.masse.lt(d)).and(qDaten.masse.gt(0.0)).and(qDaten.bv.gt(-100.0)))).fetch() : ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.bv, qDaten.masse}).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.id.notIn((Collection<Integer>)list)).and(qDaten.masse.lt(d)).and(qDaten.masse.gt(0.0)).and(qDaten.bv.gt(-100.0)))).fetch();
            this.logger.debug("query masse und b-v ben\u00f6tigte " + (System.currentTimeMillis() - l) + " ms; sterneMitPlaneten? " + bl);
            double[][] dArray = new double[list2.size()][2];
            int n = 0;
            for (Tuple tuple : list2) {
                dArray[n][0] = tuple.get(qDaten.bv);
                dArray[n][1] = tuple.get(qDaten.masse);
                ++n;
            }
            return dArray;
        }
        catch (Exception exception) {
            this.logger.error("getMasseUndBV(" + d + "," + bl + ")", exception);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getEntfernungUndHelligkeit(String string, double d) {
        try {
            QDaten qDaten = QDaten.daten;
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qDaten.ah}).from((Expression<?>)qDaten)).where(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(string))).and(qDaten.entfernung.lt(d).and(qDaten.entfernung.gt(0.0))).and(qDaten.ah.gt(-100.0)))).fetch();
            double[][] dArray = new double[list.size()][2];
            int n = 0;
            for (Tuple tuple : list) {
                dArray[n][0] = tuple.get(qDaten.entfernung);
                dArray[n][1] = tuple.get(qDaten.ah);
                ++n;
            }
            return dArray;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getEntfernungUndHelligkeit(" + string + "," + d + ")", runtimeException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getTemperaturUndHelligkeit2(String string) {
        try {
            QDaten qDaten = QDaten.daten;
            QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
            QKategorie qKategorie = QKategorie.kategorie;
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.temperatur, qDaten.ah}).from((Expression<?>)qDaten)).where(qDaten.temperatur.gt(0.0).and(qDaten.ah.gt(-100.0)).and(qDaten.spektralklasse.eq((Expression)((SQLQuery)SQLExpressions.select(qSpektraltyp.id).from((Expression<?>)qSpektraltyp)).where(qSpektraltyp.typ.eq(string).and(qSpektraltyp.kid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.STERNE.getKategorienName()))))))).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetch();
            double[][] dArray = new double[list.size()][2];
            int n = 0;
            for (Tuple tuple : list) {
                dArray[n][0] = tuple.get(qDaten.temperatur);
                dArray[n][1] = tuple.get(qDaten.ah);
                ++n;
            }
            return dArray;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getTemperaturUndHelligkeit2(" + string + ")", runtimeException);
            return new double[0][0];
        }
    }

    @Override
    public int getAnzahlSterneMitSpektraltyp(String string) {
        try {
            QDaten qDaten = QDaten.daten;
            QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
            QKategorie qKategorie = QKategorie.kategorie;
            return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.spektralklasse.eq((Expression)((SQLQuery)SQLExpressions.select(qSpektraltyp.id).from((Expression<?>)qSpektraltyp)).where(qSpektraltyp.typ.eq(string).and(qSpektraltyp.kid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.STERNE.getKategorienName())))))))).fetchCount();
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getAnzahlSpektraltypen(" + string + ")", runtimeException);
            return 0;
        }
    }

    @Override
    public int getAnzahlSterntypen(String string) {
        try {
            QDaten qDaten = QDaten.daten;
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            QKategorie qKategorie = QKategorie.kategorie;
            return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(string).and(qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.STERNE.getKategorienName())))))))).fetchCount();
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getAnzahlSterntypen(" + string + ")", runtimeException);
            return 0;
        }
    }

    @Override
    public int getAnzahlSterntypenIn34Ly(String string) {
        try {
            QDaten qDaten = QDaten.daten;
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            QKategorie qKategorie = QKategorie.kategorie;
            return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(string).and(qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.STERNE.getKategorienName())))))).and(qDaten.entfernung.between(1.0, 34.0)))).fetchCount();
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getAnzahlSterntypenIn34Ly(" + string + ")", runtimeException);
            return 0;
        }
    }

    @Override
    public int getAnzahlLeuchtkraftklasse(String string) {
        try {
            QDaten qDaten = QDaten.daten;
            QLumin qLumin = QLumin.lumin;
            return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.lumin.eq((Expression)((SQLQuery)SQLExpressions.select(qLumin.id).from((Expression<?>)qLumin)).where(qLumin.typ.eq(string))))).fetchCount();
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getAnzahlLeuchtkraftklassen(" + string + ")", runtimeException);
            return 0;
        }
    }

    @Override
    public List<String> getAnzahlPlanetenProMetallizitaet(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            List<Integer> list = bl ? this.getDatenbankService().getListeMitInt("SELECT id FROM daten WHERE metallizitaet>=0.0 AND id!=" + this.idCache.getDatenIdSonne(), "id") : this.getDatenbankService().getListeMitInt("SELECT id FROM daten WHERE metallizitaet>-100.0 AND metallizitaet<0.0 AND id!=" + this.idCache.getDatenIdSonne(), "id");
            for (int i = 0; i < list.size(); ++i) {
                if (!this.hasSternPlaneten(list.get(i))) continue;
                int n = this.getDatenbankService().getInt("SELECT COUNT(id) AS c FROM daten WHERE zugehoerigkeit=" + String.valueOf(list.get(i)) + ";", "c");
                double d = this.getDatenbankService().getDouble("SELECT metallizitaet FROM daten WHERE id=" + String.valueOf(list.get(i)), "metallizitaet");
                arrayList.add(d + ";;" + n);
            }
        }
        catch (SQLException sQLException) {
            this.logger.error("getAnzahlPlanetenProMetallizitaet(" + bl + ")", sQLException);
        }
        return arrayList;
    }

    @Override
    public int getAnzahlSpektraltypenMitPlaneten(String string, boolean bl) {
        try {
            List<Integer> list = this.findeSternUndBrZwergeIdsMitPlaneten();
            QDaten qDaten = QDaten.daten;
            QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
            QKategorie qKategorie = QKategorie.kategorie;
            if (bl) {
                Pair<Double, Double> pair = SptypTemperaturUtil.getTemperatureForSptyp(string);
                return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id.count()).from((Expression<?>)qDaten)).where(qDaten.id.in((Collection<Integer>)list).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.id.ne(this.idCache.getDatenIdSonne())).and(qDaten.spektralklasse.eq((Expression)((SQLQuery)SQLExpressions.select(qSpektraltyp.id).from((Expression<?>)qSpektraltyp)).where(qSpektraltyp.typ.eq(string).and(qSpektraltyp.kid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.STERNE.getKategorienName())))))).or(qDaten.temperatur.between(pair.getLeft(), pair.getRight()))))).fetchCount();
            }
            return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id.count()).from((Expression<?>)qDaten)).where(qDaten.id.in((Collection<Integer>)list).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge())).and(qDaten.spektralklasse.eq((Expression)((SQLQuery)SQLExpressions.select(qSpektraltyp.id).from((Expression<?>)qSpektraltyp)).where(qSpektraltyp.typ.eq(string).and(qSpektraltyp.kid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.BR_ZWERGE.getKategorienName()))))))))).fetchCount();
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error("getAnzahlSpektraltypenMitPlaneten(" + string + ")", exception);
            return 0;
        }
    }

    @Override
    public double getHoehstAlter(String string) {
        try {
            QDaten qDaten = QDaten.daten;
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            QKategorie qKategorie = QKategorie.kategorie;
            QObjektalter qObjektalter = QObjektalter.objektalter;
            Double d = (Double)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjektalter.alter.max()).from((Expression<?>)qObjektalter)).leftJoin((EntityPath)qDaten)).on((Predicate)qObjektalter.datenid.eq(qDaten.id))).where(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(string).and(qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.STERNE.getKategorienName())))))))).fetchOne();
            return d == null ? 0.0 : d;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getHoehstAlter(" + string + ")", runtimeException);
            return 0.0;
        }
    }

    @Override
    public double[][] getRadialUndMetal(boolean bl) {
        try {
            List<Integer> list = this.findeSternIdsMitPlaneten();
            QDaten qDaten = QDaten.daten;
            List list2 = bl ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.geschwindigkeit, qDaten.metallizitaet}).from((Expression<?>)qDaten)).where(qDaten.id.in((Collection<Integer>)list).and(qDaten.id.ne(this.idCache.getDatenIdSonne())).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.metallizitaet.gt(-100.0)).and(qDaten.geschwindigkeit.ne(0.0)))).fetch() : ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.geschwindigkeit, qDaten.metallizitaet}).from((Expression<?>)qDaten)).where(qDaten.metallizitaet.gt(-100.0).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.id.notIn((Collection<Integer>)list)).and(qDaten.geschwindigkeit.ne(0.0)))).fetch();
            double[][] dArray = new double[list2.size()][2];
            int n = 0;
            for (Tuple tuple : list2) {
                dArray[n][0] = tuple.get(qDaten.geschwindigkeit);
                dArray[n][1] = tuple.get(qDaten.metallizitaet);
                ++n;
            }
            return dArray;
        }
        catch (SQLException sQLException) {
            this.logger.error("getRadialUndMetal(" + bl + ")", sQLException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getEntfernungUndRadialgeschwindigkeit(double d, boolean bl) {
        try {
            List<Integer> list = this.findeSternIdsMitPlaneten();
            QDaten qDaten = QDaten.daten;
            long l = System.currentTimeMillis();
            List list2 = bl ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qDaten.geschwindigkeit}).from((Expression<?>)qDaten)).where(qDaten.id.in((Collection<Integer>)list).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.entfernung.lt(d)).and(qDaten.entfernung.gt(0.0)).and(qDaten.geschwindigkeit.ne(0.0)))).fetch() : ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qDaten.geschwindigkeit}).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.id.notIn((Collection<Integer>)list)).and(qDaten.geschwindigkeit.ne(0.0)).and(qDaten.entfernung.lt(d)).and(qDaten.entfernung.gt(0.0)))).fetch();
            this.logger.debug("query entfernung und radialgeschwindigkeit ben\u00f6tigte " + (System.currentTimeMillis() - l) + " ms; sterneMitPlaneten? " + bl);
            double[][] dArray = new double[list2.size()][2];
            int n = 0;
            for (Tuple tuple : list2) {
                dArray[n][0] = tuple.get(qDaten.entfernung);
                dArray[n][1] = tuple.get(qDaten.geschwindigkeit);
                ++n;
            }
            return dArray;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getRadialUndEntfernung(" + d + "," + bl + ")", runtimeException);
            return new double[0][0];
        }
    }

    @Override
    public boolean hasSternPlaneten(int n) {
        try {
            QDaten qDaten = QDaten.daten;
            long l = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.zugehoerigkeit.eq(n).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten())).and(qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
            return l > 0L;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("hasSternPlaneten(" + n + ")", runtimeException);
            return false;
        }
    }

    @Deprecated
    private IDatenbankService getDatenbankService() {
        return this.datenbankService;
    }

    @Override
    public long getNumberOfStarsPerBrightness(double d, double d2) {
        QDaten qDaten = QDaten.daten;
        long l = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).where(qDaten.sh.goe(d).and(qDaten.sh.lt(d2)).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetchCount();
        return l;
    }

    @Override
    public Map<String, Integer> getUnbekannteSpektraltypenNachTemperatur(double d) {
        QDaten qDaten = QDaten.daten;
        QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.temperatur).from((Expression<?>)qDaten)).join((EntityPath)qSpektraltyp)).on((Predicate)qDaten.spektralklasse.eq(qSpektraltyp.id))).where(qSpektraltyp.typ.eq("unbekannt").and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.entfernung.between(1.0, d)).and(qDaten.temperatur.gt(0.0)))).fetch();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("O", 0);
        hashMap.put("B", 0);
        hashMap.put("A", 0);
        hashMap.put("F", 0);
        hashMap.put("G", 0);
        hashMap.put("K", 0);
        hashMap.put("M", 0);
        hashMap.put("L", 0);
        for (Double d2 : list) {
            try {
                this.erhoeheZaehler(hashMap, SptypTemperaturUtil.getSptypForTemperature(d2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.warn("Stern mit Temperatur " + d2 + " au\u00dferhalb der Erwartung!", illegalArgumentException);
            }
        }
        return hashMap;
    }

    private void erhoeheZaehler(Map<String, Integer> map, String string) {
        if (map.get(string) == null) {
            map.put(string, 1);
        } else {
            map.put(string, map.get(string) + 1);
        }
    }

    @Override
    public List<ErgebnisXYDto> getTemperaturAndRadiusForEbs() {
        QDaten qDaten = QDaten.daten;
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.temperatur, qDaten.durchmesser}).from((Expression<?>)qDaten)).where(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(StarObjectType.ECLIPSING_BINARY.getTypeName()))).and(qDaten.temperatur.gt(0.0)).and(qDaten.durchmesser.gt(0.0)))).fetch();
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        for (Tuple tuple : list) {
            arrayList.add(new ErgebnisXYDto(tuple.get(qDaten.temperatur), tuple.get(qDaten.durchmesser)));
        }
        return arrayList;
    }
}

