/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QGaiaStars;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneGaiaDataDAO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SterneGaiaDataDAO
implements ISterneGaiaDataDAO {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCache;

    @Inject
    public SterneGaiaDataDAO(IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCache = iIdCacheDAO;
    }

    @Override
    public List<ErgebnisXYDto> getRvErrorAndVmagForExoplanets(List<StarObjectType> list) {
        QDaten qDaten = new QDaten("stars");
        QDaten qDaten2 = new QDaten("planets");
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QGaiaStars qGaiaStars = QGaiaStars.gaiaStars;
        List<String> list2 = list.stream().map(starObjectType -> starObjectType.getTypeName()).toList();
        List list3 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.sh, qGaiaStars.rvError, qDaten2.zugehoerigkeit}).from((Expression<?>)qDaten2)).join((EntityPath)qDaten)).on((Predicate)qDaten2.zugehoerigkeit.eq(qDaten.id))).join((EntityPath)qGaiaStars)).on((Predicate)qGaiaStars.datenid.eq(qDaten.id))).join((EntityPath)qObjekttypen)).on((Predicate)qDaten.objektid.eq(qObjekttypen.id))).where(qDaten2.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten2.entdeckungbestaetigt.isTrue()).and(qObjekttypen.typ.in(list2)).and(qGaiaStars.rvError.isNotNull()))).fetch();
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        for (Tuple tuple : list3) {
            Double d = tuple.get(qGaiaStars.rvError);
            ErgebnisXYDto ergebnisXYDto = new ErgebnisXYDto(tuple.get(qDaten.sh), d);
            arrayList.add(ergebnisXYDto);
        }
        return arrayList;
    }

    @Override
    public List<ErgebnisXYDto> getRuweAndAstroExNoiseSigForExoplanets(List<StarObjectType> list) {
        QDaten qDaten = new QDaten("stars");
        QDaten qDaten2 = new QDaten("planets");
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QGaiaStars qGaiaStars = QGaiaStars.gaiaStars;
        List<String> list2 = list.stream().map(starObjectType -> starObjectType.getTypeName()).toList();
        List list3 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qGaiaStars.ruwe, qGaiaStars.astroExNoiseSig, qDaten2.zugehoerigkeit}).from((Expression<?>)qDaten2)).join((EntityPath)qDaten)).on((Predicate)qDaten2.zugehoerigkeit.eq(qDaten.id))).join((EntityPath)qGaiaStars)).on((Predicate)qGaiaStars.datenid.eq(qDaten.id))).join((EntityPath)qObjekttypen)).on((Predicate)qDaten.objektid.eq(qObjekttypen.id))).where(qDaten2.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten2.entdeckungbestaetigt.isTrue()).and(qObjekttypen.typ.in(list2)).and(qGaiaStars.ruwe.isNotNull()).and(qGaiaStars.astroExNoiseSig.isNotNull()))).fetch();
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        for (Tuple tuple : list3) {
            ErgebnisXYDto ergebnisXYDto = new ErgebnisXYDto(tuple.get(qGaiaStars.ruwe), tuple.get(qGaiaStars.astroExNoiseSig));
            arrayList.add(ergebnisXYDto);
        }
        return arrayList;
    }

    @Override
    public List<ErgebnisXYDto> getRuweAndAstroExNoiseSigForAll(StarObjectType starObjectType) {
        QDaten qDaten = new QDaten("stars");
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QGaiaStars qGaiaStars = QGaiaStars.gaiaStars;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qGaiaStars.ruwe, qGaiaStars.astroExNoiseSig}).from((Expression<?>)qDaten)).join((EntityPath)qGaiaStars)).on((Predicate)qGaiaStars.datenid.eq(qDaten.id))).join((EntityPath)qObjekttypen)).on((Predicate)qDaten.objektid.eq(qObjekttypen.id))).where(qObjekttypen.typ.eq(starObjectType.getTypeName()).and(qGaiaStars.ruwe.isNotNull()).and(qGaiaStars.astroExNoiseSig.isNotNull()))).fetch();
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        for (Tuple tuple : list) {
            ErgebnisXYDto ergebnisXYDto = new ErgebnisXYDto(tuple.get(qGaiaStars.ruwe), tuple.get(qGaiaStars.astroExNoiseSig));
            arrayList.add(ergebnisXYDto);
        }
        return arrayList;
    }

    @Override
    public List<ErgebnisXYDto> getRvErrorAndVmagForAll(StarObjectType starObjectType) {
        QDaten qDaten = new QDaten("stars");
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QGaiaStars qGaiaStars = QGaiaStars.gaiaStars;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.sh, qGaiaStars.rvError}).from((Expression<?>)qDaten)).join((EntityPath)qGaiaStars)).on((Predicate)qGaiaStars.datenid.eq(qDaten.id))).join((EntityPath)qObjekttypen)).on((Predicate)qDaten.objektid.eq(qObjekttypen.id))).where(qObjekttypen.typ.eq(starObjectType.getTypeName()).and(qGaiaStars.rvError.isNotNull()).and(qDaten.sh.gt(-100.0)))).fetch();
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        for (Tuple tuple : list) {
            Double d = tuple.get(qGaiaStars.rvError);
            ErgebnisXYDto ergebnisXYDto = new ErgebnisXYDto(tuple.get(qDaten.sh), d);
            arrayList.add(ergebnisXYDto);
        }
        return arrayList;
    }

    @Override
    public List<ErgebnisXYDto> getAstroExNoiseSigAndVmagForAll(StarObjectType starObjectType) {
        QDaten qDaten = new QDaten("stars");
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QGaiaStars qGaiaStars = QGaiaStars.gaiaStars;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qGaiaStars.astroExNoiseSig, qDaten.sh}).from((Expression<?>)qDaten)).join((EntityPath)qGaiaStars)).on((Predicate)qGaiaStars.datenid.eq(qDaten.id))).join((EntityPath)qObjekttypen)).on((Predicate)qDaten.objektid.eq(qObjekttypen.id))).where(qObjekttypen.typ.eq(starObjectType.getTypeName()).and(qGaiaStars.astroExNoiseSig.isNotNull()).and(qDaten.sh.gt(-100.0)))).fetch();
        ArrayList<ErgebnisXYDto> arrayList = new ArrayList<ErgebnisXYDto>();
        for (Tuple tuple : list) {
            ErgebnisXYDto ergebnisXYDto = new ErgebnisXYDto(tuple.get(qDaten.sh), tuple.get(qGaiaStars.astroExNoiseSig));
            arrayList.add(ergebnisXYDto);
        }
        return arrayList;
    }
}

