/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IZwischentabellenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.api.tabellenspalten.Daten;
import de.planetensuche.datenbankkern.api.tabellenspalten.ITabellenspalten;
import de.planetensuche.datenbankkern.helfer.Konverter;
import de.planetensuche.datenbankkern.impl.tabellenmanipulation.Tabellenstruktur;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QSternhaufenform;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISternhaufenDAO;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class SternhaufenDAO
extends Tabellenstruktur
implements ISternhaufenDAO {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final IIdCacheDAO idCache;
    private final IZwischentabellenRepository zwischentabellenRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final IDatenbankService datenbankService;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public SternhaufenDAO(IIdCacheDAO iIdCacheDAO, IZwischentabellenRepository iZwischentabellenRepository, IObjektnamenRepository iObjektnamenRepository, IDatenbankService iDatenbankService, IDatenbankverbinder iDatenbankverbinder) {
        this.idCache = iIdCacheDAO;
        this.zwischentabellenRepository = iZwischentabellenRepository;
        this.objektnamenRepository = iObjektnamenRepository;
        this.datenbankService = iDatenbankService;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public double[][] getBVundAHSternhaufen(boolean bl) {
        try {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            if (bl) {
                for (Integer n : this.idCache.getObjekttypenidsSternhaufen()) {
                    List<Integer> list = this.getDatenbankService().getListeMitInt("SELECT id FROM daten WHERE objektid=" + n + ";", "id");
                    for (Integer n2 : list) {
                        Double d;
                        Double d2 = this.getDatenbankService().getDouble("SELECT AVG(bv) AS a FROM daten WHERE zugehoerigkeit=" + n2 + " AND bv>-100.0;", "a");
                        if (d2 == null || (d = this.getDatenbankService().getDouble("SELECT AVG(ah) AS m FROM daten WHERE zugehoerigkeit=" + n2 + " AND ah>-100.0;", "m")) == null) continue;
                        arrayList.add(d2);
                        arrayList.add(d);
                    }
                }
            } else {
                ArrayList<ITabellenspalten> arrayList2 = new ArrayList<ITabellenspalten>(2);
                arrayList2.add(Daten.BV);
                arrayList2.add(Daten.ABSOLUTE_HELLIGKEIT);
                for (Integer n : this.idCache.getObjekttypenidsSternhaufen()) {
                    String string = "SELECT bv, ah FROM daten WHERE objektid=" + n + " AND bv>-100.0 AND ah>-100.0;";
                    List<Map<ITabellenspalten, Double>> list = this.getDatenbankService().getListeMitDouble(string, arrayList2);
                    for (Map<ITabellenspalten, Double> map : list) {
                        double d = map.get(Daten.BV);
                        double d3 = map.get(Daten.ABSOLUTE_HELLIGKEIT);
                        arrayList.add(d);
                        arrayList.add(d3);
                    }
                }
            }
            return Konverter.convertListToArray(arrayList);
        }
        catch (SQLException sQLException) {
            this.logging.error("getBVundAH(" + bl + ")", sQLException);
            return new double[0][0];
        }
    }

    @Override
    public double[][] getAlterUndMetalSternhaufen(boolean bl) {
        try {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            if (bl) {
                for (Integer n : this.idCache.getObjekttypenidsSternhaufen()) {
                    List<Integer> list = this.getDatenbankService().getListeMitInt("SELECT id FROM daten WHERE objektid=" + n + ";", "id");
                    for (Integer n2 : list) {
                        double d;
                        double d2 = this.getDatenbankService().getDouble("SELECT AVG(alter) AS a FROM objektalter WHERE datenid IN (SELECT id FROM daten WHERE zugehoerigkeit=" + n2 + ");", "a");
                        if (!(d2 > 0.0) || (d = this.getDatenbankService().getDouble("SELECT AVG(metallizitaet) AS m FROM daten WHERE zugehoerigkeit=" + n2 + " AND metallizitaet>-100.0;", "m").doubleValue()) == -1.0) continue;
                        arrayList.add(d);
                        arrayList.add(d2);
                    }
                }
            } else {
                String[] stringArray = new String[]{"metallizitaet", "alter"};
                for (Integer n : this.idCache.getObjekttypenidsSternhaufen()) {
                    String string = "SELECT D.metallizitaet, A.alter FROM daten AS D, objektalter AS A WHERE D.objektid=" + n + " AND A.datenid=D.id AND D.metallizitaet>-100.0;";
                    arrayList.addAll(this.getDatenbankService().getListeMitDoubleOld(string, stringArray));
                }
            }
            return Konverter.convertListToArray(arrayList);
        }
        catch (SQLException sQLException) {
            this.logging.error("getAlterUndMetal(" + bl + ")", sQLException);
            return new double[0][0];
        }
    }

    @Override
    public int getAnzahlSternhaufen(String string, int n) {
        try {
            QDaten qDaten = QDaten.daten;
            QSternhaufenform qSternhaufenform = QSternhaufenform.sternhaufenform;
            long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.sternhaufenform.eq((Expression)((SQLQuery)SQLExpressions.select(qSternhaufenform.id).from((Expression<?>)qSternhaufenform)).where(qSternhaufenform.form.eq(string).and(qSternhaufenform.oid.eq(n)))))).fetchCount();
            return (int)l;
        }
        catch (Exception exception) {
            this.logging.error("getAnzahlSternhaufen(" + string + "," + n + ")", exception);
            return 0;
        }
    }

    @Override
    public String[] getSternhaufenMitSternen(String string) {
        String[] stringArray = new String[]{};
        if (string == null) {
            return stringArray;
        }
        try {
            String string2 = this.getObjekttypenIdsVonSternen();
            String string3 = this.getObjekttypenIdsVonSternhaufen();
            Object object = "";
            if ("FHD".equals(string)) {
                object = "bv>-100.0 AND ";
            } else if ("HRD".equals(string)) {
                object = "spektralklasse!=(SELECT id FROM spektraltyp WHERE kid=(SELECT id FROM kategorie WHERE name='" + ObjektKategorie.STERNE.getKategorienName() + "') AND typ='unbekannt') AND spektralklasse2>-1.0 AND ";
            }
            String string4 = "SELECT id FROM daten WHERE objektid IN (" + string3 + ");";
            List<Integer> list = this.getDatenbankService().getListeMitInt(string4, "id");
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
            for (Integer n : list) {
                String string5 = "SELECT COUNT(id) AS c FROM daten WHERE Zugehoerigkeit=" + n + " AND AH>-100.0 AND " + (String)object + "objektid IN (" + string2 + ");";
                Integer n2 = this.getDatenbankService().getInt(string5, "c");
                if (n2 == null || n2 <= 0) continue;
                String string6 = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.ALPHABETISCH).get(0);
                arrayList.add((CallSite)((Object)(string6 + " (" + n2 + " " + SprachcontainerFabrik.getSprachcontainer().getString("ps_sterne") + ")")));
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        catch (SQLException sQLException) {
            this.logging.error("getSternhaufenMitSternen(" + string + ")", sQLException);
        }
        return stringArray;
    }

    private String getObjekttypenIdsVonSternhaufen() {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.idCache.getObjekttypenidsSternhaufen().iterator();
        while (object.hasNext()) {
            int n = object.next();
            stringBuilder.append(n).append(", ");
        }
        object = stringBuilder.substring(0, stringBuilder.length() - 2);
        return object;
    }

    private String getObjekttypenIdsVonSternen() {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.idCache.getObjekttypenidsSterne().iterator();
        while (object.hasNext()) {
            int n = object.next();
            stringBuilder.append(n).append(", ");
        }
        object = stringBuilder.substring(0, stringBuilder.length() - 2);
        return object;
    }

    @Override
    public double[][] getHelligkeitUndEntfernungSternhaufen(String string, double d) {
        try {
            String[] stringArray = new String[]{"entfernung", "sh"};
            List<Double> list = this.getDatenbankService().getListeMitDoubleOld("SELECT Entfernung, sh FROM daten WHERE objektid IN (SELECT id FROM objekttypen WHERE Typ='" + string + "') AND Entfernung>0.0 AND Entfernung<" + d + " AND sh>-100.0;", stringArray);
            return Konverter.convertListToArray(list);
        }
        catch (SQLException sQLException) {
            this.logging.error("getHelligkeitUndEntfernungSternhaufen(" + string + "," + d + ")", sQLException);
            return new double[0][0];
        }
    }

    @Override
    public void getEntdeckerVonSternhaufen(List<String> list, List<Integer> list2) {
        try {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Integer n : this.idCache.getObjekttypenidsSternhaufen()) {
                String string = "SELECT id FROM daten WHERE objektid=" + n + ";";
                arrayList.addAll(this.getDatenbankService().getListeMitInt(string, "id"));
            }
            this.zwischentabellenRepository.getEntdeckerFuerObjektIds(arrayList, list, list2);
        }
        catch (SQLException sQLException) {
            this.logging.error(sQLException);
        }
    }

    private IDatenbankService getDatenbankService() {
        return this.datenbankService;
    }
}

