/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.planeten;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QEntdeckungsmethode;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.simulationen.dbmodel.planeten.IEntdeckungsjahrRepository;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class EntdeckungsjahrRepository
implements IEntdeckungsjahrRepository {
    private final IDatenbankService datenbankService;
    private final IEntdeckungsmethodenRepository entdeckungsmethodenRepository;
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCacheDAO;

    @Inject
    public EntdeckungsjahrRepository(IDatenbankService iDatenbankService, IEntdeckungsmethodenRepository iEntdeckungsmethodenRepository, IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.datenbankService = iDatenbankService;
        this.entdeckungsmethodenRepository = iEntdeckungsmethodenRepository;
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCacheDAO = iIdCacheDAO;
    }

    @Override
    public List<String> getAlleEntdeckungsmethoden() throws SQLException {
        return this.entdeckungsmethodenRepository.getEntdeckungsmethoden();
    }

    @Override
    public int countPlanetenProJahr(int n) throws SQLException {
        QDaten qDaten = QDaten.daten;
        return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.entdeckungsjahr.eq(n)))).fetchCount();
    }

    @Override
    public int countPlanetenNachMethode(int n, String string) throws SQLException {
        QDaten qDaten = QDaten.daten;
        QEntdeckungsmethode qEntdeckungsmethode = QEntdeckungsmethode.entdeckungsmethode;
        return (int)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).leftJoin((EntityPath)qEntdeckungsmethode)).on((Predicate)qDaten.entdeckungsmethode.eq(qEntdeckungsmethode.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.entdeckungsjahr.eq(n)).and(qEntdeckungsmethode.methode.eq(string)))).fetchCount();
    }

    @Override
    public Map<String, Integer> getEntdeckerUndAnzahl(int n) throws SQLException {
        List list;
        Serializable serializable2;
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        QDaten qDaten = QDaten.daten;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        QEntdecker qEntdecker = QEntdecker.entdecker;
        List<Integer> list2 = this.datenbankService.getObjekttypenidsPlaneten();
        List list3 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)list2).and(qDaten.entdeckungsjahr.eq(n)).and(qDaten.entdeckungbestaetigt.isTrue()))).fetch();
        for (Serializable serializable2 : list3) {
            list = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qZtentdecker.datenid.eq((Integer)serializable2).and(qEntdecker.typ.isNull().or(qEntdecker.typ.eq(EntdeckerTyp.PERSON.getType()))))).fetch();
            if (list == null) continue;
            for (Entdecker entdecker : list) {
                Integer n2 = (Integer)linkedHashMap.get(entdecker.getNachname());
                if (n2 == null) {
                    linkedHashMap.put(entdecker.getNachname(), 1);
                    continue;
                }
                linkedHashMap.put(entdecker.getNachname(), n2 + 1);
            }
        }
        ArrayList arrayList = new ArrayList(linkedHashMap.entrySet());
        Collections.sort(arrayList, (entry, entry2) -> ((Integer)entry.getValue()).compareTo((Integer)entry2.getValue()) * -1);
        serializable2 = new LinkedHashMap();
        list = arrayList.iterator();
        while (list.hasNext()) {
            Map.Entry entry3 = (Map.Entry)list.next();
            serializable2.put((String)entry3.getKey(), (Integer)entry3.getValue());
        }
        return serializable2;
    }

    private int getAnzahl(String string) throws SQLException {
        Integer n = this.datenbankService.getInt(string, "c");
        if (n != null) {
            return n;
        }
        return 0;
    }

    @Override
    public Map<String, Integer> getEntdeckerUndAnzahl(List<Entdecker> list, int n) throws SQLException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        QDaten qDaten = QDaten.daten;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        List<Integer> list2 = this.idCacheDAO.getObjekttypenidsPlaneten();
        Map<Integer, Entdecker> map = list.stream().collect(Collectors.toMap(entdecker -> entdecker.getId(), entdecker -> entdecker));
        List list3 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qZtentdecker.entdeckerid}).from((Expression<?>)qDaten)).join((EntityPath)qZtentdecker)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).where(qDaten.objektid.in((Collection<Integer>)list2).and(qDaten.entdeckungsjahr.eq(n)).and(qDaten.entdeckungbestaetigt.isTrue()).and(qZtentdecker.entdeckerid.in((Collection<Integer>)map.keySet())))).fetch();
        for (Tuple tuple : list3) {
            Entdecker entdecker2 = map.get(tuple.get(qZtentdecker.entdeckerid));
            if (entdecker2 == null) continue;
            Object object = Check.isEmpty(entdecker2.getTyp()) || EntdeckerTyp.PERSON.getType().intValue() == entdecker2.getTyp().intValue() ? entdecker2.getVorname() + " " + entdecker2.getNachname() : entdecker2.getNachname();
            Integer n2 = (Integer)hashMap.get(object);
            if (n2 == null) {
                n2 = 1;
            } else {
                Integer n3 = n2;
                n2 = n2 + 1;
            }
            hashMap.put((String)object, (int)n2);
        }
        return hashMap;
    }
}

