/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.planeten;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.formeln.PlanetSystemTypeCalculator;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExoplanetSystemTypesRepository {
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCacheDAO;
    private final PlanetSystemTypeCalculator calculator;

    @Inject
    public ExoplanetSystemTypesRepository(IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCacheDAO = iIdCacheDAO;
        this.calculator = new PlanetSystemTypeCalculator();
    }

    public Map<PlanetSystemTypeCalculator.PlanetSystemType, Integer> getNumberOfPlanetSystemsPerType() {
        QDaten qDaten = QDaten.daten;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.masse, qDaten.zugehoerigkeit}).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.masse.gt(0.0)).and(qDaten.zugehoerigkeit.isNotNull()))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{qDaten.zugehoerigkeit.asc(), qDaten.umlaufszeit.asc()})).fetch();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Tuple tuple : list) {
            if (n5 == 0) {
                n5 = tuple.get(qDaten.zugehoerigkeit);
            }
            if (n5 == tuple.get(qDaten.zugehoerigkeit)) {
                arrayList.add(tuple.get(qDaten.masse));
                continue;
            }
            if (arrayList.size() >= 3) {
                PlanetSystemTypeCalculator.PlanetSystemType planetSystemType = this.calculator.determineType(arrayList);
                switch (planetSystemType) {
                    case ANTI_ORDERED: {
                        ++n2;
                        break;
                    }
                    case ORDERED: {
                        ++n;
                        break;
                    }
                    case SIMILAR: {
                        ++n3;
                        break;
                    }
                    default: {
                        ++n4;
                    }
                }
            }
            arrayList.clear();
            n5 = tuple.get(qDaten.zugehoerigkeit);
            arrayList.add(tuple.get(qDaten.masse));
        }
        HashMap hashMap = new HashMap();
        hashMap.put(PlanetSystemTypeCalculator.PlanetSystemType.ORDERED, n);
        hashMap.put(PlanetSystemTypeCalculator.PlanetSystemType.ANTI_ORDERED, n2);
        hashMap.put(PlanetSystemTypeCalculator.PlanetSystemType.SIMILAR, n3);
        hashMap.put(PlanetSystemTypeCalculator.PlanetSystemType.MIXED, n4);
        return hashMap;
    }
}

