/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.statistik;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IHabitableZoneRepository;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QHabitableZone;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.basis.HabitableZoneUtil;
import de.planetensuche.simulationen.dbmodel.basis.RockyPlanetUtil;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public class MilchstrassenRepository {
    private static final long ANZAHL_STERNE = 100000000000L;
    private final ILogging logger;
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCacheDAO;
    private final IHabitableZoneRepository habitableZoneRepository;
    private final ISterneDAO sterneDAO;
    private final QDaten qDaten = QDaten.daten;
    private final QHabitableZone qHabitableZone = QHabitableZone.habitableZone;
    private final QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;

    @Inject
    public MilchstrassenRepository(IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO, IHabitableZoneRepository iHabitableZoneRepository, ISterneDAO iSterneDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCacheDAO = iIdCacheDAO;
        this.habitableZoneRepository = iHabitableZoneRepository;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.sterneDAO = iSterneDAO;
    }

    public long getAnzahlPlaneten() {
        long l = this.zaehleAnzahlPlanetenAktuell();
        this.logger.debug("anzahl bekannte planeten: " + l);
        long l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.id.count()).from((Expression<?>)this.qDaten)).where(this.qDaten.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(this.qDaten.zugehoerigkeit).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue()))).and(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsSterne())))).fetchCount();
        this.logger.debug("anzahl sterne mit planeten: " + l2);
        double d = 1.0 * (double)l / (double)l2;
        this.logger.debug("durchschnittliche planetenanzahl je stern: " + d);
        return Math.round(1.0E11 * d);
    }

    private long zaehleAnzahlPlanetenAktuell() {
        long l = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.id.count()).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
        return l;
    }

    public long getAnzahlPlanetenUmSonnenaehnlicheSterne() {
        long l = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.id.count()).from((Expression<?>)this.qDaten)).where(this.qDaten.entfernung.between(1.0, 34.0).and(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsSterne())))).fetchCount();
        Map<String, Integer> map = this.sterneDAO.getUnbekannteSpektraltypenNachTemperatur(34.0);
        Integer n = map.get("G");
        int n2 = this.sterneDAO.getAnzahlSpektraltypenIn34Ly("G");
        double d = (double)(++n2 + n) * 100.0 / (double)(++l);
        this.logger.debug("Anzahl G-Sterne: " + n2 + " + Anzahl G-Sterne nach Temperatur: " + n + " zu Gesamtanzahl Sterne: " + l + " ergibt " + d + "%");
        return Math.round((double)this.getAnzahlPlaneten() / 100.0 * d);
    }

    public long getAnzahlPlanetenInHabitablerZone() {
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)this.qDaten.zugehoerigkeit).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten()).and(this.qDaten.entfernung.gt(0.0)).and(this.qDaten.exzentritaet.between(1.0E-6, 0.5)).and(this.qDaten.zugehoerigkeit.isNotNull()).and(this.qDaten.entdeckungbestaetigt.isTrue()))).fetch();
        this.logger.debug("anzahl sterne f\u00fcr getAnzahlPlanetenInHabitablerZone: " + list.size());
        int n = 0;
        for (Integer n2 : list) {
            Optional<Pair<Double, Double>> optional = this.habitableZoneRepository.getInnerAndOuterHZ(n2);
            if (optional.isPresent()) {
                double d = optional.get().getLeft();
                double d2 = optional.get().getRight();
                n += this.getAnzahlExoplaneten(n2, d, d2);
                continue;
            }
            this.logger.debug("Kann keine HZ berechnen f\u00fcr Stern mit id " + n2);
        }
        long l = this.zaehleAnzahlPlanetenAktuell();
        double d = 1.0 * (double)n / (double)l;
        return Math.round(d * (double)this.getAnzahlPlaneten());
    }

    public long getAnzahlPlanetenInHabitablerZoneUmSonnenaehnlicheSterne() {
        double d;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qHabitableZone.datenid, this.qHabitableZone.innerHz, this.qHabitableZone.outerHz}).from((Expression<?>)this.qHabitableZone)).innerJoin((EntityPath)this.qDaten)).on((Predicate)this.qHabitableZone.datenid.eq(this.qDaten.id))).innerJoin((EntityPath)this.qSpektraltyp)).on((Predicate)this.qDaten.spektralklasse.eq(this.qSpektraltyp.id))).where(this.qHabitableZone.datenid.in((SubQueryExpression)((SQLQuery)SQLExpressions.selectDistinct(this.qDaten.zugehoerigkeit).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten()).and(this.qDaten.entfernung.gt(0.0)).and(this.qDaten.exzentritaet.between(1.0E-6, 0.5)).and(this.qDaten.zugehoerigkeit.isNotNull()).and(this.qDaten.entdeckungbestaetigt.isTrue()))).and(this.qSpektraltyp.typ.eq("G").or(this.qDaten.temperatur.between(5100.0, 6000.0))))).fetch();
        this.logger.debug("anzahl sterne f\u00fcr getAnzahlPlanetenInHabitablerZoneUmSonnenaehnlicheSterne: " + list.size());
        int n = 0;
        for (Tuple tuple : list) {
            d = tuple.get(this.qHabitableZone.innerHz);
            double d2 = tuple.get(this.qHabitableZone.outerHz);
            n += this.getAnzahlExoplaneten(tuple.get(this.qHabitableZone.datenid), d, d2);
        }
        long l = this.zaehleAnzahlPlanetenAktuell();
        d = 1.0 * (double)n / (double)l;
        return Math.round(d * (double)this.getAnzahlPlaneten());
    }

    public long getAnzahlFelsplaneten() {
        List<Tuple> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.masse, this.qDaten.durchmesser}).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten()).and(this.qDaten.masse.between(1.0E-7, 0.5)).and(this.qDaten.durchmesser.between(1.0E-6, 0.5)).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.isNotNull()))).fetch();
        this.logger.debug(list.size() + " exoplaneten f\u00fcr getAnzahlFelsplaneten gefunden");
        long l = this.getAnzahlFelsplanetenAktuell(list);
        long l2 = this.zaehleAnzahlPlanetenAktuell();
        double d = 1.0 * (double)l / (double)l2;
        return Math.round(d * (double)this.getAnzahlPlaneten());
    }

    private long getAnzahlFelsplanetenAktuell(List<Tuple> list) {
        long l = 0L;
        for (Tuple tuple : list) {
            Double d;
            Double d2 = tuple.get(this.qDaten.durchmesser);
            boolean bl = RockyPlanetUtil.isRockyPlanet(d2, d = tuple.get(this.qDaten.masse));
            if (!bl) continue;
            ++l;
        }
        return l;
    }

    public long getAnzahlFelsplanetenUmSonnenaehnlicheSterne() {
        List<Tuple> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.masse, this.qDaten.durchmesser}).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten()).and(this.qDaten.masse.between(1.0E-7, 0.5)).and(this.qDaten.durchmesser.between(1.0E-6, 0.5)).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.isNotNull()).and(this.qDaten.zugehoerigkeit.in((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(this.qDaten.id).from((Expression<?>)this.qDaten)).join((EntityPath)this.qSpektraltyp)).on((Predicate)this.qDaten.spektralklasse.eq(this.qSpektraltyp.id))).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsSterne()).and(this.qSpektraltyp.typ.eq("G").or(this.qDaten.temperatur.between(5100.0, 6000.0)))))))).fetch();
        this.logger.debug(list.size() + " exoplaneten f\u00fcr getAnzahlFelsplaneten gefunden");
        long l = this.getAnzahlFelsplanetenAktuell(list);
        double d = 1.0 * (double)l / (double)this.zaehleAnzahlPlanetenAktuell();
        return Math.round(d * (double)this.getAnzahlPlaneten());
    }

    public long getAnzahlFelsplanetenInHabitablerZone() {
        QDaten qDaten = new QDaten("sterne");
        QDaten qDaten2 = new QDaten("planeten");
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qHabitableZone.innerHz, this.qHabitableZone.outerHz, qDaten2.masse, qDaten2.durchmesser, qDaten2.entfernung, qDaten2.exzentritaet}).from((Expression<?>)qDaten2)).innerJoin((EntityPath)qDaten)).on((Predicate)qDaten2.zugehoerigkeit.eq(qDaten.id))).innerJoin((EntityPath)this.qHabitableZone)).on((Predicate)qDaten.id.eq(this.qHabitableZone.datenid))).where(qDaten2.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten()).and(qDaten2.masse.between(1.0E-7, 0.5)).and(qDaten2.durchmesser.between(1.0E-6, 0.5)).and(qDaten2.entfernung.gt(0.0)).and(qDaten2.exzentritaet.between(1.0E-6, 0.5)).and(qDaten2.entdeckungbestaetigt.isTrue()).and(qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsSterne())))).fetch();
        this.logger.debug(list.size() + " exoplaneten f\u00fcr getAnzahlFelsplanetenInHabitablerZone gefunden");
        long l = 0L;
        for (Tuple tuple : list) {
            Double d = tuple.get(qDaten2.masse);
            Double d2 = tuple.get(qDaten2.durchmesser);
            Double d3 = tuple.get(qDaten2.entfernung);
            Double d4 = tuple.get(qDaten2.exzentritaet);
            Double d5 = tuple.get(this.qHabitableZone.innerHz);
            Double d6 = tuple.get(this.qHabitableZone.outerHz);
            if (!HabitableZoneUtil.isInHabitableZone(d3, d4, d5, d6) || !RockyPlanetUtil.isRockyPlanet(d2, d)) continue;
            ++l;
        }
        long l2 = this.zaehleAnzahlPlanetenAktuell();
        double d = 1.0 * (double)l / (double)l2;
        return Math.round(d * (double)this.getAnzahlPlaneten());
    }

    public long getAnzahlFelsplanetenInHabitablerZoneUmSonnenaehnlicheSterne() {
        QDaten qDaten = new QDaten("sterne");
        QDaten qDaten2 = new QDaten("planeten");
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qHabitableZone.innerHz, this.qHabitableZone.outerHz, qDaten2.masse, qDaten2.durchmesser, qDaten2.entfernung, qDaten2.exzentritaet}).from((Expression<?>)qDaten2)).innerJoin((EntityPath)qDaten)).on((Predicate)qDaten2.zugehoerigkeit.eq(qDaten.id))).innerJoin((EntityPath)this.qHabitableZone)).on((Predicate)qDaten.id.eq(this.qHabitableZone.datenid))).innerJoin((EntityPath)this.qSpektraltyp)).on((Predicate)qDaten.spektralklasse.eq(this.qSpektraltyp.id))).where(qDaten2.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten()).and(qDaten2.masse.between(1.0E-7, 0.5)).and(qDaten2.durchmesser.between(1.0E-6, 0.5)).and(qDaten2.entfernung.gt(0.0)).and(qDaten2.exzentritaet.between(1.0E-6, 0.5)).and(qDaten2.entdeckungbestaetigt.isTrue()).and(this.qSpektraltyp.typ.eq("G").or(qDaten.temperatur.between(5100.0, 6000.0))).and(qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsSterne())))).fetch();
        this.logger.debug(list.size() + " exoplaneten f\u00fcr getAnzahlFelsplanetenInHabitablerZoneUmSonnenaehnlicheSterne gefunden");
        long l = 0L;
        for (Tuple tuple : list) {
            Double d = tuple.get(qDaten2.masse);
            Double d2 = tuple.get(qDaten2.durchmesser);
            Double d3 = tuple.get(qDaten2.entfernung);
            Double d4 = tuple.get(qDaten2.exzentritaet);
            Double d5 = tuple.get(this.qHabitableZone.innerHz);
            Double d6 = tuple.get(this.qHabitableZone.outerHz);
            if (!HabitableZoneUtil.isInHabitableZone(d3, d4, d5, d6) || !RockyPlanetUtil.isRockyPlanet(d2, d)) continue;
            ++l;
        }
        long l2 = this.zaehleAnzahlPlanetenAktuell();
        double d = 1.0 * (double)l / (double)l2;
        return Math.round(d * (double)this.getAnzahlPlaneten());
    }

    private int getAnzahlExoplaneten(int n, double d, double d2) {
        int n2 = 0;
        List list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qDaten).where(this.qDaten.zugehoerigkeit.eq(n).and(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten())).and(this.qDaten.entfernung.gt(0.0)).and(this.qDaten.exzentritaet.between(1.0E-6, 0.5)).and(this.qDaten.entdeckungbestaetigt.isTrue()))).fetch();
        for (Daten daten : list) {
            double d3;
            double d4 = daten.getEntfernung();
            boolean bl = HabitableZoneUtil.isInHabitableZone(d4, d3 = daten.getExzentritaet().doubleValue(), d, d2);
            if (!bl) continue;
            ++n2;
        }
        return n2;
    }
}

