/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.dbmodel.statistik;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IHabitableZoneRepository;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.impl.tabellenmanipulation.Tabellenstruktur;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QHabitableZone;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.statistik.ISonnensystemeRepository;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public final class SonnensystemeRepository
extends Tabellenstruktur
implements ISonnensystemeRepository {
    private final ILogging logger;
    private final IIdCacheDAO idCache;
    private final IDatenbankService datenbankService;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public SonnensystemeRepository(IIdCacheDAO iIdCacheDAO, IDatenbankService iDatenbankService, IKategorienRepository iKategorienRepository, IDatenbankverbinder iDatenbankverbinder, IHabitableZoneRepository iHabitableZoneRepository) {
        this.idCache = iIdCacheDAO;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.datenbankService = iDatenbankService;
        this.kategorienRepository = iKategorienRepository;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public int getAnzahl(ObjektKategorie objektKategorie) throws SQLException {
        long l = System.currentTimeMillis();
        int n = this.kategorienRepository.getAnzahl(objektKategorie.getKategorienName());
        this.logger.debug(objektKategorie.getKategorienName() + ": " + (System.currentTimeMillis() - l) + " ms");
        return n;
    }

    @Override
    public int getAnzahlSterneMitVielenPlaneten() {
        long l = System.currentTimeMillis();
        int n = this.getAnzahlSterneMitExoPlaneten(true);
        this.logger.debug("getAnzahlSterneMitVielenPlaneten: " + (System.currentTimeMillis() - l) + " ms");
        return n;
    }

    @Override
    public int getAnzahlSterneMitGasriesenInnen() {
        long l = System.currentTimeMillis();
        int n = this.getAnzahlSterneMitPlaneten(0.03, 25.0, 0.0, 3.0);
        this.logger.debug("getAnzahlSterneMitGasriesenInnen: " + (System.currentTimeMillis() - l) + " ms");
        return n;
    }

    @Override
    public int getAnzahlSterneMitGasriesenAussen() {
        long l = System.currentTimeMillis();
        int n = this.getAnzahlSterneMitPlaneten(0.03, 25.0, 2.999, 400.0);
        this.logger.debug("getAnzahlSterneMitGasriesenAussen: " + (System.currentTimeMillis() - l) + " ms");
        return n;
    }

    @Override
    public int getAnzahlSterneMitErdenInnen() {
        long l = System.currentTimeMillis();
        int n = this.getAnzahlSterneMitPlaneten(1.0E-5, 0.03, 0.0, 3.0);
        this.logger.debug("getAnzahlSterneMitErdenInnen: " + (System.currentTimeMillis() - l) + " ms");
        return n;
    }

    @Override
    public int getAnzahlSterneMitErdenAussen() {
        long l = System.currentTimeMillis();
        int n = this.getAnzahlSterneMitPlaneten(1.0E-5, 0.03, 2.999, 400.0);
        this.logger.debug("getAnzahlSterneMitErdenAussen: " + (System.currentTimeMillis() - l) + " ms");
        return n;
    }

    @Override
    public int getAnzahlSterneMitExoPlaneten(boolean bl) {
        try {
            QDaten qDaten = new QDaten("planeten");
            if (bl) {
                return (int)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).groupBy((Expression<?>)qDaten.zugehoerigkeit)).having(qDaten.zugehoerigkeit.count().gt(1))).fetchCount();
            }
            return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).fetchCount();
        }
        catch (SQLException sQLException) {
            this.logger.error("getAnzahlSterneMitExoPlaneten(" + bl + ")", sQLException);
            return 0;
        }
    }

    private int getAnzahlSterneMitPlaneten(double d, double d2, double d3, double d4) {
        try {
            double d5 = Math.pow(d4, 1.5) * 365.25;
            double d6 = Math.pow(d3, 1.5) * 365.25;
            QDaten qDaten = new QDaten("planeten");
            return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.masse.between(d, d2)).and(qDaten.entfernung.between(d3, d4).or(qDaten.umlaufszeit.between(d6, d5))).and(qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).fetchCount();
        }
        catch (SQLException sQLException) {
            this.logger.error("getAnzahlSterneMitPlaneten(" + d + "," + d2 + "," + d3 + "," + d4 + ")", sQLException);
            return 0;
        }
    }

    @Override
    public int getAnzahlEinzelsterneMitExoPlaneten() {
        try {
            long l = System.currentTimeMillis();
            QDaten qDaten = new QDaten("sterne");
            QDaten qDaten2 = new QDaten("planeten");
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            Integer n = (int)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)qDaten2.zugehoerigkeit).from((Expression<?>)qDaten2)).leftJoin((EntityPath)qDaten)).on((Predicate)qDaten2.zugehoerigkeit.eq(qDaten.id))).where(qDaten2.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Einzelstern")))).and(qDaten.id.ne(this.idCache.getDatenIdSonne())).and(qDaten2.entdeckungbestaetigt.isTrue()))).fetchCount();
            this.logger.debug("getAnzahlEinzelsterneMitExoPlaneten: " + (System.currentTimeMillis() - l) + " ms");
            return n;
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return 0;
        }
    }

    @Override
    public int getAnzahlMehrfachsterneMitExoplaneten() {
        try {
            long l = System.currentTimeMillis();
            QDaten qDaten = new QDaten("sterne");
            QDaten qDaten2 = new QDaten("planeten");
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            Integer n = (int)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)qDaten2.zugehoerigkeit).from((Expression<?>)qDaten2)).leftJoin((EntityPath)qDaten)).on((Predicate)qDaten2.zugehoerigkeit.eq(qDaten.id))).where(qDaten2.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.objektid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.in("Doppelstern physisch", "Mehrfachsternensystem")))).and(qDaten.id.ne(this.idCache.getDatenIdSonne())).and(qDaten2.entdeckungbestaetigt.isTrue()))).fetchCount();
            this.logger.debug("getAnzahlMehrfachsterneMitExoplaneten: " + (System.currentTimeMillis() - l) + " ms");
            return n;
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return 0;
        }
    }

    @Override
    public int getAnzahlSterneMetalUndExoPlaneten() {
        try {
            long l = System.currentTimeMillis();
            QDaten qDaten = QDaten.daten;
            long l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id.count()).from((Expression<?>)qDaten)).where(qDaten.metallizitaet.gt(0.0).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.selectDistinct(qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue())))))).fetchCount();
            this.logger.debug("getAnzahlSterneMetalUndExoPlaneten: " + (System.currentTimeMillis() - l) + " ms");
            return (int)l2;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
            return 0;
        }
    }

    @Override
    public int getAnzahlSterneMitPlanetenInGruenerZone() {
        try {
            long l = System.currentTimeMillis();
            QDaten qDaten = QDaten.daten;
            QHabitableZone qHabitableZone = QHabitableZone.habitableZone;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct(new Expression[]{qDaten.zugehoerigkeit, qHabitableZone.innerHz, qHabitableZone.outerHz}).from((Expression<?>)qDaten)).join((EntityPath)qHabitableZone)).on((Predicate)qDaten.zugehoerigkeit.eq(qHabitableZone.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()))).fetch();
            int n = 0;
            for (Tuple tuple : list) {
                int n2 = tuple.get(qDaten.zugehoerigkeit);
                double d = tuple.get(qHabitableZone.innerHz);
                double d2 = tuple.get(qHabitableZone.outerHz);
                double d3 = Math.pow(d, 1.5) * 365.25;
                double d4 = Math.pow(d2, 1.5) * 365.25;
                long l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.zugehoerigkeit.eq(n2).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten())).and(qDaten.entfernung.between(d, d2).or(qDaten.umlaufszeit.between(d3, d4))).and(qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
                n += (int)l2;
            }
            this.logger.debug("getAnzahlSterneMitPlanetenInGruenerZone: " + (System.currentTimeMillis() - l) + " ms");
            return n;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
            return -1;
        }
    }

    @Override
    public int getSterneMitErdaehnlichenPlaneten(double d) {
        try {
            QDaten qDaten = new QDaten("planeten");
            return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.masse.between(1.0E-6, d)).and(qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).fetchCount();
        }
        catch (SQLException sQLException) {
            this.logger.error("getSterneMitErdaehnlichenPlaneten(" + d + ")", sQLException);
            return -1;
        }
    }

    @Override
    public int getAnzahlSterneMitBraunenZwergen() {
        try {
            QDaten qDaten = QDaten.daten;
            long l = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id.count()).from((Expression<?>)qDaten)).where(qDaten.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.selectDistinct(qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.entdeckungbestaetigt.isTrue()))).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetchCount();
            return (int)l;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
            return 0;
        }
    }

    @Override
    public int getAnzahlSterneMitBraunenZwergenUndPlaneten() {
        try {
            QDaten qDaten = QDaten.daten;
            long l = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id.count()).from((Expression<?>)qDaten)).where(qDaten.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.selectDistinct(qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.entdeckungbestaetigt.isTrue()))).and(qDaten.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.selectDistinct(qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue())))).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetchCount();
            return (int)l;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
            return 0;
        }
    }

    @Override
    public int getAnzahlBrauneZwergeMitExoplaneten() {
        try {
            QDaten qDaten = QDaten.daten;
            long l = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.selectDistinct(qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue())))))).fetchCount();
            return (int)l;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
            return 0;
        }
    }

    @Override
    public Integer getNumberOfPlanemos() {
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QDaten qDaten = new QDaten("planeten");
        return (int)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).leftJoin((EntityPath)qObjekttypen)).on((Predicate)qObjekttypen.id.eq(qDaten.objektid))).where(qObjekttypen.typ.eq("Planemos").and(qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
    }

    @Override
    public int getAnzahlSterneMitHotJupitern() {
        long l = System.currentTimeMillis();
        QDaten qDaten = QDaten.daten;
        int n = (int)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.masse.goe(0.95)).and(qDaten.temperatur.goe(900.0)).and(qDaten.entdeckungbestaetigt.isTrue())))))).fetchCount();
        this.logger.debug("getAnzahlSterneMitHotJupitern: " + (System.currentTimeMillis() - l) + " ms");
        return n;
    }

    @Override
    public int getAnzahlSterneMitSupererden() {
        QDaten qDaten = QDaten.daten;
        double d = 0.0034540000000000005;
        double d2 = 0.0314;
        double d3 = 0.1115;
        double d4 = 0.1784;
        int n = (int)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(qDaten.zugehoerigkeit).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.masse.between(d, d2).or(qDaten.durchmesser.between(d3, d4))).and(qDaten.entdeckungbestaetigt.isTrue())))))).fetchCount();
        return n;
    }

    @Override
    public int getAnzahlHotJupiter() {
        QDaten qDaten = QDaten.daten;
        return (int)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.masse.goe(0.95)).and(qDaten.temperatur.goe(900.0)).and(qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
    }

    @Override
    public int getNumberOfSuperEarthsByRadius() {
        double d = 0.1115;
        double d2 = 0.1784;
        QDaten qDaten = QDaten.daten;
        return (int)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.durchmesser.between(d, d2)).and(qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
    }

    @Override
    public int getNumberOfSuperJupiterByMass() {
        QDaten qDaten = QDaten.daten;
        return (int)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.masse.goe(1.1)).and(qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
    }

    @Override
    public int getNumberOfJoviansByRadius() {
        QDaten qDaten = QDaten.daten;
        return (int)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.durchmesser.between(0.892, 1.5)).and(qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
    }

    @Override
    public int getNumberOfNeptunesByRadius() {
        QDaten qDaten = QDaten.daten;
        double d = 0.2676;
        double d2 = 0.34788;
        return (int)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.durchmesser.between(d, d2)).and(qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
    }

    @Override
    public int getNumberOfMiniEarthsByRadius() {
        QDaten qDaten = QDaten.daten;
        return (int)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.durchmesser.between(0.017481969269363438, 0.07136)).and(qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
    }

    @Override
    public int getNumberOfEarthsByRadius() {
        QDaten qDaten = QDaten.daten;
        double d = 0.07136;
        double d2 = 0.1115;
        return (int)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.durchmesser.between(d, d2)).and(qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
    }

    @Override
    public int getNumberOfMesoplanetsByRadius() {
        QDaten qDaten = QDaten.daten;
        double d = 0.0034963938538726874;
        double d2 = 0.017481969269363438;
        return (int)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.durchmesser.between(d, d2)).and(qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
    }

    @Override
    public int getNumberOfMiniNeptunesByRadius() {
        QDaten qDaten = QDaten.daten;
        double d = 0.1784;
        double d2 = 0.346096;
        return (int)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.durchmesser.between(d, d2)).and(qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
    }

    @Override
    public int getAnzahlBestaetigterExoplaneten() {
        try {
            QDaten qDaten = QDaten.daten;
            return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).fetchCount();
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return 0;
        }
    }

    @Override
    public int getNumberOfExoplanetsWithUnknownRadius() {
        try {
            QDaten qDaten = QDaten.daten;
            return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())).and(qDaten.durchmesser.eq(0.0)))).fetchCount();
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return 0;
        }
    }
}

