/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme;

import com.google.common.io.Files;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ChartRepository
implements IChartRepository {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final Map<String, Set<IChart>> registeredCharts = new LinkedHashMap<String, Set<IChart>>();

    @Override
    public synchronized void register(IChart iChart) {
        Set<IChart> set = this.registeredCharts.get(iChart.getCategoryName());
        if (set == null) {
            set = new LinkedHashSet<IChart>();
        }
        set.add(iChart);
        this.registeredCharts.put(iChart.getCategoryName(), set);
    }

    @Override
    public Map<String, Set<IChart>> getRegisteredCharts() {
        return this.registeredCharts;
    }

    @Override
    public String getChartDescription(IChart iChart) {
        StringBuilder stringBuilder = new StringBuilder(" ");
        String string = "de";
        if (!SprachcontainerFabrik.getSprachcontainer().isAktuelleSpracheDeutsch()) {
            string = "en";
        }
        String string2 = iChart.getChartKey() + "_" + string + ".html";
        try {
            File file = new File("sprachen" + File.separator + "charts" + File.separator + string2);
            if (!file.exists()) {
                this.logger.warn("Keine Beschreibung fuer Diagramm '" + iChart.getChartKey() + "' gefunden!");
                this.logger.warn("Dateiname: " + string2);
                return stringBuilder.toString();
            }
            List<String> list = Files.readLines(file, Charset.forName("UTF-8"));
            for (String string3 : list) {
                stringBuilder.append(string3).append(" ");
            }
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
        return stringBuilder.toString();
    }
}

