/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.tuple.Pair;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class DiagrammHelfer {
    private final ISprachcontainer i18n;
    private final ILogging logging;

    public DiagrammHelfer(ISprachcontainer iSprachcontainer) {
        this.i18n = iSprachcontainer;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
    }

    public double zeigeEingabeDialog(JFrame jFrame, String string, String string2, double d, String string3, double d2, double ... dArray) {
        String string4 = this.i18n.getString("sim_m17") + " " + string + " (" + this.i18n.getString("sim_m18") + " " + string3 + ") " + this.i18n.getString("sim_m19") + " " + string2 + " " + this.i18n.getString("sim_m20") + " " + this.i18n.toLocalisedDouble(d) + ")?";
        String string5 = string + " " + this.i18n.getString("sim_m21");
        String string6 = (String)JOptionPane.showInputDialog(jFrame, string4, string5, 3, null, null, d);
        double d3 = d;
        if (string6 != null && !"".equals(string6)) {
            try {
                d3 = this.i18n.parseDouble(string6);
                if (d3 < d2) {
                    d3 = d2;
                } else if (dArray != null && dArray.length == 1 && d3 > dArray[0]) {
                    d3 = dArray[0];
                }
            }
            catch (NumberFormatException numberFormatException) {
                d3 = d;
                String string7 = this.i18n.getString("sim_f3_1") + " " + string + " " + this.i18n.getString("sim_f3_2") + " " + d + " " + string3 + " " + this.i18n.getString("sim_f3_3");
                this.logging.showErrorMessageBox(null, string7, this.i18n.getString("sim_f3_titel"));
            }
        }
        return d3;
    }

    public void fuelleCollection(XYSeriesCollection xYSeriesCollection, String string, double[][] dArray) {
        try {
            XYSeries xYSeries = new XYSeries((Comparable)((Object)(string + " (" + this.i18n.toLocalisedInt(dArray.length) + ")")));
            for (int i = 0; i < dArray.length; ++i) {
                xYSeries.add(dArray[i][0], dArray[i][1]);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.logging.error("fuelleCollection(" + string + "," + dArray.length + ")", arrayIndexOutOfBoundsException);
        }
    }

    public void fuelleXYSeriesCollection(XYSeriesCollection xYSeriesCollection, String string, List<ErgebnisXYDto> list) {
        try {
            XYSeries xYSeries = new XYSeries((Comparable)((Object)(string + " (" + this.i18n.toLocalisedInt(list.size()) + ")")));
            for (ErgebnisXYDto ergebnisXYDto : list) {
                xYSeries.add(ergebnisXYDto.getX(), ergebnisXYDto.getY());
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.logging.error("fuelleCollection(" + string + "," + list.size() + ")", arrayIndexOutOfBoundsException);
        }
    }

    public void fuelleCollection(XYSeriesCollection xYSeriesCollection, String string, List<Pair<Double, Double>> list) {
        try {
            XYSeries xYSeries = new XYSeries((Comparable)((Object)(string + " (" + this.i18n.toLocalisedInt(list.size()) + ")")));
            for (Pair<Double, Double> pair : list) {
                xYSeries.add((double)pair.getKey(), pair.getValue());
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.logging.error("fuelleCollection(" + string + "," + list.size() + ")", arrayIndexOutOfBoundsException);
        }
    }
}

