/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.asteroiden;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.IEntdeckungsdatumDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class DiscoveryYearAsteroidsChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IEntdeckungsdatumDAO entdeckungsdatumDAO;
    private DefaultCategoryDataset dataset;
    private String ueberschriftBarchart;

    @Inject
    public DiscoveryYearAsteroidsChart(IChartRepository iChartRepository, IEntdeckungsdatumDAO iEntdeckungsdatumDAO) {
        this.entdeckungsdatumDAO = iEntdeckungsdatumDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = 0;
        for (int i = 1600; i <= gregorianCalendar.get(1); ++i) {
            int n2 = this.entdeckungsdatumDAO.getAnzahlProEntdeckungsjahr(i, ObjektKategorie.ASTEROIDEN);
            if (n2 <= 0) continue;
            n += n2;
            this.dataset.addValue(n2, (Comparable)((Object)Integer.toString(i)), (Comparable)((Object)""));
        }
        this.ueberschriftBarchart = this.i18n.toLocalisedInt(n) + " " + this.i18n.getString("ps_asteroiden");
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.ueberschriftBarchart, this.i18n.getString("sim_gui12"), this.i18n.getString("sim_m82"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui12");
    }

    @Override
    public String getChartKey() {
        return "sim_gui12A";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_asteroiden");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_ASTEROIDEN_DISCOVERY_YEAR;
    }
}

