/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.asteroiden;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IAsteroidenDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeriesCollection;

public final class DistanceAndExcentrityChart
implements IChart {
    private final ISprachcontainer sprache;
    private final DiagrammHelfer helfer;
    private final IAsteroidenDAO asteroidenDAO;
    private XYSeriesCollection collection;
    private double maxEntfernung;

    @Inject
    public DistanceAndExcentrityChart(IChartRepository iChartRepository, IAsteroidenDAO iAsteroidenDAO) {
        this.asteroidenDAO = iAsteroidenDAO;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.sprache);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
        this.maxEntfernung = this.helfer.zeigeEingabeDialog(null, this.sprache.getString("sim_m13"), this.sprache.getString("ps_asteroiden"), 100.0, "AE", 50.0, new double[0]);
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        this.helfer.fuelleCollection(this.collection, this.sprache.getString("ps_asteroiden"), this.asteroidenDAO.getBahnabstandUndExzentrizitaet(this.maxEntfernung));
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("sim_m75"), this.sprache.getString("db_m111"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui11");
    }

    @Override
    public String getChartKey() {
        return "sim_gui11";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_asteroiden");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_ASTEROIDEN_ENTFERNUNG_EXCENTRITAET;
    }
}

