/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.braunezwerge;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IBrauneZwergeDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class DiscoveryMethodsChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IBrauneZwergeDAO brauneZwergeDAO;
    private DefaultCategoryDataset dataset;
    private String ueberschrift;

    @Inject
    public DiscoveryMethodsChart(IChartRepository iChartRepository, IBrauneZwergeDAO iBrauneZwergeDAO) {
        this.brauneZwergeDAO = iBrauneZwergeDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        String[] stringArray;
        int n;
        this.dataset = new DefaultCategoryDataset();
        List<String> list = this.brauneZwergeDAO.getAnzahlBrauneZwergeProEntdeckungsmethode();
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            stringArray = list.get(n).split(";");
            n2 += Integer.parseInt(stringArray[0]);
        }
        if (n2 == 0) {
            return;
        }
        for (n = 0; n < list.size(); ++n) {
            stringArray = list.get(n).split(";");
            if (stringArray.length != 2) continue;
            int n3 = Integer.parseInt(stringArray[0]);
            String string = this.i18n.getUebersetzungFuerAktuelleSprache(stringArray[1]);
            this.dataset.addValue(n3, (Comparable)((Object)(string + " (" + (double)Math.round((double)n3 * 1000.0 / (double)n2) / 10.0 + "%)")), (Comparable)((Object)""));
        }
        this.ueberschrift = this.i18n.toLocalisedInt(list.size()) + " " + this.i18n.getString("sim_gui108");
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.ueberschrift, this.i18n.getString("db_m126"), this.i18n.getString("sim_m84"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui108");
    }

    @Override
    public String getChartKey() {
        return "sim_gui108B";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_br_zwerge");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_BRAUNE_ZWERGE_ENTDECKUNGSMETHODEN;
    }
}

