/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.braunezwerge;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IBrauneZwergeDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.lang3.tuple.Pair;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class DistanceAndTemperatureChart
implements IChart {
    private final ISprachcontainer sprache;
    private final IBrauneZwergeDAO brauneZwergeDAO;
    private XYSeriesCollection collection;

    @Inject
    public DistanceAndTemperatureChart(IChartRepository iChartRepository, IBrauneZwergeDAO iBrauneZwergeDAO) {
        this.brauneZwergeDAO = iBrauneZwergeDAO;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        List<Pair<Double, Double>> list = this.brauneZwergeDAO.getDistanceAndTemperatureWithHostStar();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)(list.size() + " " + this.sprache.getString("ps_br_zwerge"))));
        for (Pair<Double, Double> serializable2 : list) {
            xYSeries.add(serializable2.getKey(), (Number)serializable2.getValue());
        }
        this.collection.addSeries(xYSeries);
        List<Pair<Double, Double>> list2 = this.brauneZwergeDAO.getDistanceAndTemperatureWithoutHostStar();
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)(list2.size() + " " + this.sprache.getString("ps_ot_brzwergohne"))));
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            xYSeries2.add((Number)pair.getKey(), (Number)pair.getValue());
        }
        this.collection.addSeries(xYSeries2);
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("sim_gui154"), this.sprache.getString("db_m53"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui168");
    }

    @Override
    public String getChartKey() {
        return "sim_gui168";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_br_zwerge");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_BRAUNE_ZWERGE_ENTFERNUNG_TEMPERATUR;
    }
}

