/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.braunezwerge;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IBrauneZwergeDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeriesCollection;

public final class MassAndSemiMajorAxisChart
implements IChart {
    private final ISprachcontainer sprache;
    private final IBrauneZwergeDAO brauneZwergeDAO;
    private final DiagrammHelfer helfer;
    private XYSeriesCollection collection;

    @Inject
    public MassAndSemiMajorAxisChart(IChartRepository iChartRepository, IBrauneZwergeDAO iBrauneZwergeDAO) {
        this.brauneZwergeDAO = iBrauneZwergeDAO;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.sprache);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        List<ErgebnisXYDto> list = this.brauneZwergeDAO.getMasseUndBahnabstand(3000.0);
        this.helfer.fuelleXYSeriesCollection(this.collection, ObjektKategorie.BR_ZWERGE.getKategorienName(), list);
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("sim_m75"), this.sprache.getString("sim_m76"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui22");
    }

    @Override
    public String getChartKey() {
        return "sim_gui22B";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_br_zwerge");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_BRAUNE_ZWERGE_MASSE_APHEL;
    }
}

