/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.glxneb;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IGalaxienNebelDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeriesCollection;

public final class DistanceAndBrightnessOfGalaxiesChart
implements IChart {
    private final ISprachcontainer sprache;
    private final DiagrammHelfer helfer;
    private final IGalaxienNebelDAO galaxienNebelDAO;
    private final IDatenbankService datenbankService;
    private XYSeriesCollection collection;
    private double maxEntfernung;

    @Inject
    public DistanceAndBrightnessOfGalaxiesChart(IChartRepository iChartRepository, IGalaxienNebelDAO iGalaxienNebelDAO, IDatenbankService iDatenbankService) {
        this.galaxienNebelDAO = iGalaxienNebelDAO;
        this.datenbankService = iDatenbankService;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.sprache);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
        this.maxEntfernung = this.helfer.zeigeEingabeDialog(null, this.sprache.getString("sim_m9"), this.sprache.getString("sim_m10"), 5.0E7, "ly", 100000.0, new double[0]);
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        List<String> list = this.datenbankService.getGalaxienformen();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).startsWith("E")) {
                this.helfer.fuelleCollection(this.collection, this.sprache.getString("sim_m28") + " " + list.get(i), this.galaxienNebelDAO.getGalaxienFEH(list.get(i), this.maxEntfernung));
                continue;
            }
            if (list.get(i).startsWith("SB")) {
                this.helfer.fuelleCollection(this.collection, this.sprache.getString("sim_m29") + " " + list.get(i), this.galaxienNebelDAO.getGalaxienFEH(list.get(i), this.maxEntfernung));
                continue;
            }
            if (list.get(i).startsWith("S")) {
                this.helfer.fuelleCollection(this.collection, this.sprache.getString("sim_m30") + " " + list.get(i), this.galaxienNebelDAO.getGalaxienFEH(list.get(i), this.maxEntfernung));
                continue;
            }
            String string = this.sprache.getUebersetzungFuerAktuelleSprache(list.get(i));
            this.helfer.fuelleCollection(this.collection, this.sprache.getString("sim_m15") + " " + string, this.galaxienNebelDAO.getGalaxienFEH(list.get(i), this.maxEntfernung));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("sim_m68"), this.sprache.getString("sim_m69"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui10");
    }

    @Override
    public String getChartKey() {
        return "sim_gui10G";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_glx_neb");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_GLX_NEB_ENTFERNUNG_HELLIGKEIT;
    }
}

