/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.glxneb;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IGalaxienNebelDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeriesCollection;

public final class DistanceAndRedshiftOfGalaxiesChart
implements IChart {
    private final ISprachcontainer sprache;
    private final DiagrammHelfer helfer;
    private final IGalaxienNebelDAO galaxienNebelDAO;
    private XYSeriesCollection collection;
    private double maxEntfernung;

    @Inject
    public DistanceAndRedshiftOfGalaxiesChart(IChartRepository iChartRepository, IGalaxienNebelDAO iGalaxienNebelDAO) {
        this.galaxienNebelDAO = iGalaxienNebelDAO;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.sprache);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
        this.maxEntfernung = this.helfer.zeigeEingabeDialog(null, this.sprache.getString("sim_gui79"), this.sprache.getString("db_m41"), 8.0E7, "ly", 1000000.0, new double[0]);
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        this.helfer.fuelleCollection(this.collection, this.sprache.getString("sim_m15"), this.galaxienNebelDAO.getEntfernungUndRotverschiebungGalaxienNebel(this.maxEntfernung));
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("sim_m68"), this.sprache.getString("db_m123"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui95");
    }

    @Override
    public String getChartKey() {
        return "sim_gui95";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_glx_neb");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_GLX_NEB_ENTFERNUNG_REDSHIFT;
    }
}

