/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.monde;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.IDAOlowAllgemein;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeriesCollection;

public final class DiameterAlbedoAndBrightnessChart
implements IChart {
    private final ISprachcontainer sprache;
    private final DiagrammHelfer helfer;
    private final IDAOlowAllgemein daoLowAllgemein;
    private XYSeriesCollection collection;

    @Inject
    public DiameterAlbedoAndBrightnessChart(IChartRepository iChartRepository, IDAOlowAllgemein iDAOlowAllgemein) {
        this.daoLowAllgemein = iDAOlowAllgemein;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.sprache);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        Double[] doubleArray = new Double[]{6000.0, 5000.0, 4000.0, 3000.0, 2000.0, 1000.0};
        for (int i = 0; i < doubleArray.length; ++i) {
            this.helfer.fuelleCollection(this.collection, this.sprache.getString("ps_monde") + " (" + this.sprache.getString("sim_m14") + " " + doubleArray[i] + "-" + (doubleArray[i] - 1000.0) + " km", this.daoLowAllgemein.getDurchmesserHelligkeitAlbedo(doubleArray[i], doubleArray[i] - 1000.0));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("db_m115"), this.sprache.getString("db_m107"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui35");
    }

    @Override
    public String getChartKey() {
        return "sim_gui35";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_monde");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_MONDE_DURCHMESSER_ALBEDO;
    }
}

