/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.monde;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IMondeDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class DiscovererOfMoonsChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IMondeDAO mondeDAO;
    private DefaultCategoryDataset dataset;
    private String ueberschrift;

    @Inject
    public DiscovererOfMoonsChart(IChartRepository iChartRepository, IMondeDAO iMondeDAO) {
        this.mondeDAO = iMondeDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        this.mondeDAO.getEntdeckerVonMonden(arrayList, arrayList2);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.dataset.addValue((Number)arrayList2.get(i), (Comparable)arrayList.get(i), (Comparable)((Object)""));
        }
        this.ueberschrift = this.i18n.toLocalisedInt(arrayList.size()) + " " + this.i18n.getString("sim_m38");
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.ueberschrift, this.i18n.getString("sim_m38"), this.i18n.getString("sim_m130"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui103");
    }

    @Override
    public String getChartKey() {
        return "sim_gui103";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_monde");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_MONDE_ENTDECKER;
    }
}

