/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.old;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.dbmodel.api.IDAOlowAllgemein;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.sql.SQLException;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYSeriesCollection;

public final class DiagrammeAllgemein {
    private final JFrame simulation;
    private final int diagrammnummer;
    private final ISprachcontainer i18n;
    private final ILogging logging;
    private XYSeriesCollection collection;
    private PieDataset pieSet;
    private String schrift;
    private String bezeichnung;
    private final JComboBox jcb;
    private final DiagrammHelfer helfer;
    private final IDAOlowAllgemein allgemeinDao;
    private final IKategorienRepository kategorienRepository;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;

    public DiagrammeAllgemein(int n, JComboBox jComboBox, JFrame jFrame, ISprachcontainer iSprachcontainer, IDAOlowAllgemein iDAOlowAllgemein, IKategorienRepository iKategorienRepository, IPlanetensucheObjektRepository iPlanetensucheObjektRepository, IObjektnamenRepository iObjektnamenRepository) {
        this.simulation = jFrame;
        this.i18n = iSprachcontainer;
        this.diagrammnummer = n;
        this.jcb = jComboBox;
        this.allgemeinDao = iDAOlowAllgemein;
        this.kategorienRepository = iKategorienRepository;
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.objektnamenRepository = iObjektnamenRepository;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.helfer = new DiagrammHelfer(iSprachcontainer);
    }

    public void showDiagramm() {
        try {
            switch (this.diagrammnummer) {
                case 11: {
                    this.schrift = this.i18n.getString("sim_gui3");
                    this.createDatasetPie();
                    break;
                }
                case 12: {
                    this.schrift = this.i18n.getString("sim_gui69");
                    this.createDatasetPie();
                    break;
                }
                case 15: {
                    double d = this.helfer.zeigeEingabeDialog(this.simulation, this.i18n.getString("sim_m9"), this.i18n.getString("sim_m10"), 1000.0, "ly", 5.0, new double[0]);
                    this.schrift = this.i18n.getString("sim_gui20");
                    this.createScatterPlotDataset(d);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Kein Diagramm fuer Kategorie '" + this.diagrammnummer + "' gefunden!");
                }
            }
            JFreeChart jFreeChart = this.createChart();
            ChartFrame chartFrame = new ChartFrame(this.schrift, jFreeChart);
            chartFrame.setIconImage(this.simulation.getIconImage());
            chartFrame.pack();
            chartFrame.setVisible(true);
        }
        catch (Exception exception) {
            this.logging.error(exception);
        }
    }

    private void createDatasetPie() throws SQLException {
        String string;
        int n;
        DefaultPieDataset<String> defaultPieDataset = new DefaultPieDataset<String>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.jcb.getItemCount(); ++n) {
            string = this.kategorienRepository.getKategorieFuerObjekt(this.jcb.getItemAt(n).toString());
            if (string.equals(ObjektKategorie.PLANETEN.getKategorienName()) || string.equals(ObjektKategorie.BR_ZWERGE.getKategorienName())) {
                ++n2;
                continue;
            }
            if (string.equals(ObjektKategorie.STERNE.getKategorienName())) {
                ++n3;
                continue;
            }
            if (!string.equals(ObjektKategorie.MONDE.getKategorienName()) && !string.equals(ObjektKategorie.ASTEROIDEN.getKategorienName()) && !string.equals(ObjektKategorie.KOMETEN.getKategorienName())) continue;
            ++n4;
        }
        this.bezeichnung = n2 > n3 && n2 > n4 ? (this.diagrammnummer == 11 ? this.i18n.getString("db_m99") : this.i18n.getString("db_m102")) : (n3 > n2 && n3 > n4 ? (this.diagrammnummer == 11 ? this.i18n.getString("db_m98") : this.i18n.getString("db_m101")) : (this.diagrammnummer == 11 ? "km" : "Kg"));
        if (this.diagrammnummer == 11) {
            for (n = 0; n < this.jcb.getItemCount(); ++n) {
                string = this.jcb.getItemAt(n).toString();
                try {
                    Integer n5 = this.objektnamenRepository.getIDFuerNamen(string, true);
                    IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(n5);
                    double d = iPlanetensucheObjekt.getDurchmesser();
                    defaultPieDataset.setValue(string, d * this.getRichtigeEinheit(n3, n2, n4, iPlanetensucheObjekt.getKategorie(), false));
                    continue;
                }
                catch (SQLException sQLException) {
                    this.logging.error(sQLException);
                }
            }
        } else if (this.diagrammnummer == 12) {
            for (n = 0; n < this.jcb.getItemCount(); ++n) {
                string = this.jcb.getItemAt(n).toString();
                try {
                    Integer n6 = this.objektnamenRepository.getIDFuerNamen(string, true);
                    IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(n6);
                    double d = iPlanetensucheObjekt.getMasse();
                    defaultPieDataset.setValue(string, d * this.getRichtigeEinheit(n3, n2, n4, iPlanetensucheObjekt.getKategorie(), true));
                    continue;
                }
                catch (SQLException sQLException) {
                    this.logging.error(sQLException);
                }
            }
        }
        this.pieSet = defaultPieDataset;
    }

    private void createScatterPlotDataset(double d) {
        block4: {
            try {
                this.collection = new XYSeriesCollection();
                if (this.diagrammnummer == 15) {
                    String[] stringArray = new String[]{ObjektKategorie.STERNE.getKategorienName(), ObjektKategorie.STERNHAUFEN.getKategorienName(), ObjektKategorie.GALAXIE_NEBEL.getKategorienName()};
                    for (int i = 0; i < stringArray.length; ++i) {
                        double[][] dArray = this.allgemeinDao.getHelligkeitUndEntfernung(stringArray[i], d);
                        String string = this.i18n.getUebersetzungFuerAktuelleSprache(stringArray[i]);
                        this.helfer.fuelleCollection(this.collection, string, dArray);
                    }
                    break block4;
                }
                throw new IllegalArgumentException("Kein Diagramm fuer Kategorie '" + this.diagrammnummer + "' gefunden!");
            }
            catch (Exception exception) {
                this.logging.error("Fehler createScatterPlotChart(" + d + " AE/ly)", exception);
            }
        }
    }

    private JFreeChart createChart() {
        JFreeChart jFreeChart = null;
        switch (this.diagrammnummer) {
            case 11: {
                Locale locale = this.i18n.getConfiguredLocale();
                jFreeChart = ChartFactory.createPieChart(this.i18n.getString("sim_gui9") + " " + this.bezeichnung, this.pieSet, true, true, locale);
                break;
            }
            case 12: {
                Locale locale = this.i18n.getConfiguredLocale();
                jFreeChart = ChartFactory.createPieChart(this.i18n.getString("sim_gui8") + " " + this.bezeichnung, this.pieSet, true, true, locale);
                break;
            }
            case 15: {
                jFreeChart = ChartFactory.createScatterPlot(this.schrift, this.i18n.getString("sim_m68"), this.i18n.getString("sim_m69"), this.collection, PlotOrientation.VERTICAL, true, true, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Kein Diagramm fuer Kategorie '" + this.diagrammnummer + "' gefunden!");
            }
        }
        return jFreeChart;
    }

    private double getRichtigeEinheit(int n, int n2, int n3, String string, boolean bl) {
        double d = 1.0;
        if (n2 > n && n2 > n3) {
            if (string.equals(ObjektKategorie.STERNE.getKategorienName())) {
                d = bl ? 1048.446550816219 : 9.748172217709179;
            } else if (string.equals(ObjektKategorie.MONDE.getKategorienName()) || string.equals(ObjektKategorie.ASTEROIDEN.getKategorienName()) || string.equals(ObjektKategorie.KOMETEN.getKategorienName())) {
                d = bl ? 5.26592943654555E-28 : 7.002997282837054E-6;
            }
        } else if (n > n2 && n > n3) {
            d = string.equals(ObjektKategorie.STERNE.getKategorienName()) ? 1.0 : (string.equals(ObjektKategorie.PLANETEN.getKategorienName()) || string.equals(ObjektKategorie.BR_ZWERGE.getKategorienName()) ? (bl ? 9.537920642893018E-4 : 0.10258333333333333) : (bl ? 1.991E30 : 1392000.0));
        } else if (string.equals(ObjektKategorie.STERNE.getKategorienName())) {
            d = bl ? 1.991E30 : 1392000.0;
        } else if (string.equals(ObjektKategorie.PLANETEN.getKategorienName()) || string.equals(ObjektKategorie.BR_ZWERGE.getKategorienName())) {
            d = bl ? 1.899E27 : 142796.0;
        }
        return d;
    }
}

