/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class BrightnessAndSemiMajorAxisChart
implements IChart {
    private final ISprachcontainer sprache;
    private final IPlanetenDAO planetenDAO;
    private final DiagrammHelfer helfer;
    private XYSeriesCollection collection;
    private double maxEntfernung;

    @Inject
    public BrightnessAndSemiMajorAxisChart(IChartRepository iChartRepository, IPlanetenDAO iPlanetenDAO) {
        this.planetenDAO = iPlanetenDAO;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.sprache);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
        this.maxEntfernung = this.helfer.zeigeEingabeDialog(null, this.sprache.getString("sim_m13"), this.sprache.getString("ps_planeten"), 6.0, "AE", 0.5, new double[0]);
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        this.helfer.fuelleCollection(this.collection, this.sprache.getString("sim_gui110"), this.planetenDAO.getBahnabstandUndAbsoluteHelligkeit(this.maxEntfernung));
        XYSeries xYSeries = new XYSeries((Comparable)((Object)this.sprache.getString("sim_m27")));
        this.fuegeUnserePlanetenHinzu(xYSeries);
        this.collection.addSeries(xYSeries);
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("sim_m75"), this.sprache.getString("sim_m71"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui26");
    }

    @Override
    public String getChartKey() {
        return "sim_gui26";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    private void fuegeUnserePlanetenHinzu(XYSeries xYSeries) {
        if (this.maxEntfernung >= 0.387) {
            xYSeries.add(0.387, 4.82);
        }
        if (this.maxEntfernung >= 0.723) {
            xYSeries.add(0.723, 4.82);
        }
        if (this.maxEntfernung >= 1.0) {
            xYSeries.add(1.0, 4.82);
        }
        if (this.maxEntfernung >= 1.524) {
            xYSeries.add(1.524, 4.82);
        }
        if (this.maxEntfernung >= 5.21) {
            xYSeries.add(5.21, 4.82);
        }
        if (this.maxEntfernung >= 9.5) {
            xYSeries.add(9.5, 4.82);
        }
        if (this.maxEntfernung >= 19.2) {
            xYSeries.add(19.2, 4.82);
        }
        if (this.maxEntfernung >= 30.05) {
            xYSeries.add(30.05, 4.82);
        }
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_VMAG_APHEL;
    }
}

