/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.EntdeckerResult;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenEntdeckerDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class DiscovererAndPlanetCount
implements IChart {
    private final ISprachcontainer i18n;
    private final IPlanetenEntdeckerDAO planetenDAO;
    private DefaultCategoryDataset dataset;
    private int anzahlMinimumEntdeckungen;
    private String ueberschrift;

    @Inject
    public DiscovererAndPlanetCount(IChartRepository iChartRepository, IPlanetenEntdeckerDAO iPlanetenEntdeckerDAO) {
        this.planetenDAO = iPlanetenEntdeckerDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
        Object[] objectArray = new Object[]{10, 20, 30, 40, 50, 60};
        Object object = JOptionPane.showInputDialog(null, this.i18n.getString("sim_m138"), this.i18n.getString("sim_m138_titel"), 3, null, objectArray, objectArray[2]);
        this.anzahlMinimumEntdeckungen = 60;
        if (object != null) {
            this.anzahlMinimumEntdeckungen = Integer.parseInt(object.toString());
        }
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        List<EntdeckerResult> list = this.planetenDAO.getEntdeckerVonPlaneten(this.anzahlMinimumEntdeckungen);
        int n = 0;
        for (EntdeckerResult entdeckerResult : list) {
            this.dataset.addValue(entdeckerResult.getZtEntdeckerCount(), (Comparable)((Object)(entdeckerResult.getEntdecker().getVorname() + " " + entdeckerResult.getEntdecker().getNachname())), (Comparable)((Object)""));
            ++n;
        }
        this.ueberschrift = this.i18n.toLocalisedInt(n) + " " + this.i18n.getString("sim_m148");
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.ueberschrift, this.i18n.getString("sim_m148"), this.i18n.getString("sim_gui195"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui119");
    }

    @Override
    public String getChartKey() {
        return "sim_gui119";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_ENTDECKER_ANZAHL;
    }
}

