/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenEntdeckungsmethodeDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class DiscovererMethodsAndExoplanetsChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IPlanetenEntdeckungsmethodeDAO planetenDAO;
    private DefaultCategoryDataset dataset;

    @Inject
    public DiscovererMethodsAndExoplanetsChart(IChartRepository iChartRepository, IPlanetenEntdeckungsmethodeDAO iPlanetenEntdeckungsmethodeDAO) {
        this.planetenDAO = iPlanetenEntdeckungsmethodeDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        String[] stringArray;
        int n;
        this.dataset = new DefaultCategoryDataset();
        List<String> list = this.planetenDAO.getAnzahlPlanetenProEntdeckungsmethode();
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            stringArray = list.get(n).split(";");
            n2 += Integer.parseInt(stringArray[0]);
        }
        if (n2 == 0) {
            return;
        }
        for (n = 0; n < list.size(); ++n) {
            stringArray = list.get(n).split(";");
            if (stringArray.length != 2) continue;
            int n3 = Integer.parseInt(stringArray[0]);
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getUebersetzungFuerAktuelleSprache(stringArray[1]) + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 1000.0 / (double)n2) / 10.0) + "%)")), (Comparable)((Object)""));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.getChartName(), this.i18n.getString("db_m126"), this.i18n.getString("sim_gui195"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui136");
    }

    @Override
    public String getChartKey() {
        return "sim_gui136";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_ENTDECKUNGSMETHODEN;
    }
}

