/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenEntdeckungsmethodeDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Color;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.category.DefaultCategoryDataset;

public final class DiscovererMethodsAndStatistics
implements IChart {
    private final ISprachcontainer sprache;
    private final IPlanetenEntdeckungsmethodeDAO planetenDAO;
    private DefaultCategoryDataset dataset;

    @Inject
    public DiscovererMethodsAndStatistics(IChartRepository iChartRepository, IPlanetenEntdeckungsmethodeDAO iPlanetenEntdeckungsmethodeDAO) {
        this.planetenDAO = iPlanetenEntdeckungsmethodeDAO;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        Map<String, Integer> map = this.planetenDAO.getEntdeckungsmethodeUndProzentPlaneten();
        this.addData("sim_gui171", map);
        Map<String, Integer> map2 = this.planetenDAO.getEntdeckungsmethodeInMehrfachsternsystemenUndProzentPlaneten();
        this.addData("sim_gui172", map2);
        Map<String, Integer> map3 = this.planetenDAO.getEntdeckungsmethodeUndProzentEntferntestePlaneten();
        this.addData("sim_gui173", map3);
        Map<String, Integer> map4 = this.planetenDAO.getEntdeckungsmethodeUndProzentKleinePlaneten();
        this.addData("sim_gui174", map4);
        Map<String, Integer> map5 = this.planetenDAO.getEntdeckungsmethodeUndProzentLanglaufendePlaneten();
        this.addData("sim_gui175", map5);
    }

    private void addData(String string, Map<String, Integer> map) {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            this.dataset.addValue(entry.getValue(), (Comparable)((Object)this.sprache.getUebersetzungFuerAktuelleSprache(entry.getKey())), (Comparable)((Object)this.sprache.getString(string)));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.getChartName(), this.sprache.getString("db_m126"), this.sprache.getString("sim_gui170"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        GroupedStackedBarRenderer groupedStackedBarRenderer = new GroupedStackedBarRenderer();
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap();
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)this.sprache.getString("ps_entd_radial")), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)this.sprache.getString("ps_entd_transit")), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)this.sprache.getString("ps_entd_micro")), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)this.sprache.getString("ps_entd_direkt")), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)this.sprache.getString("ps_entd_timing")), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)this.sprache.getString("ps_entd_astro")), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)this.sprache.getString("ps_entd_obm")), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)this.sprache.getString("ps_entd_unbekannt")), (Comparable)((Object)"G1"));
        groupedStackedBarRenderer.setSeriesToGroupMap(keyToGroupMap);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setRenderer(groupedStackedBarRenderer);
        categoryPlot.getRenderer().setSeriesPaint(0, Color.BLACK);
        categoryPlot.getRenderer().setSeriesPaint(1, Color.BLUE);
        categoryPlot.getRenderer().setSeriesPaint(2, Color.YELLOW);
        categoryPlot.getRenderer().setSeriesPaint(3, Color.GRAY);
        categoryPlot.getRenderer().setSeriesPaint(4, Color.CYAN);
        categoryPlot.getRenderer().setSeriesPaint(5, Color.RED);
        categoryPlot.getRenderer().setSeriesPaint(6, Color.ORANGE);
        categoryPlot.getRenderer().setSeriesPaint(7, Color.MAGENTA);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui169");
    }

    @Override
    public String getChartKey() {
        return "sim_gui169";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_ENTDECKUNGSMETHODEN_STATISTIC;
    }
}

