/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenEntdeckerDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class DiscovererTeamsAndPlanetCount
implements IChart {
    private final ISprachcontainer i18n;
    private final IPlanetenEntdeckerDAO planetenDAO;
    private DefaultCategoryDataset dataset;
    private String ueberschrift;

    @Inject
    public DiscovererTeamsAndPlanetCount(IChartRepository iChartRepository, IPlanetenEntdeckerDAO iPlanetenEntdeckerDAO) {
        this.planetenDAO = iPlanetenEntdeckerDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        Map<String, Integer> map = this.planetenDAO.getEntdeckerteamsUndAnzahlEntdeckungen();
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        int n = 0;
        for (String string : arrayList) {
            Integer n2 = map.get(string);
            this.dataset.addValue(n2, (Comparable)((Object)string), (Comparable)((Object)""));
            ++n;
        }
        this.ueberschrift = this.i18n.toLocalisedInt(n) + " " + this.i18n.getString("sim_m149");
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.ueberschrift, this.i18n.getString("sim_m149"), this.i18n.getString("sim_gui195"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui120");
    }

    @Override
    public String getChartKey() {
        return "sim_gui120";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_ENTDECKERTEAMS;
    }
}

